TYPO3 CMS
=========

TYPO3 is an open source PHP based web content management system released
under the GNU GPL. TYPO3 is copyright © 1999-2024 by Kasper Skårhøj.

This document provides a basic introduction to TYPO3.

Getting Started
---------------

TYPO3 requires a web server with PHP and a database (e.g. MySQL).
The backend is accessed via a supported browser.

Please see the [Installation Guide](https://docs.typo3.org/installation)
in order to set up a basic TYPO3 installation on your web server.

What is TYPO3?
--------------

TYPO3 is a free and open source Content Management Framework. It is
released under the GNU General Public License. It can run on several web
servers, such as Apache, nginx or IIS, on top of many operating systems,
among them Linux, Microsoft Windows, FreeBSD or macOS.

TYPO3 was initially authored by Kasper Skårhøj and is now further
developed by a community of contributors and the [TYPO3 Core Development
Team](https://typo3.org/community/teams/typo3-development/).

To get more info about the GPL license, visit
https://opensource.org/licenses/gpl-license

What is a Content Management Framework?
---------------------------------------

A Content Management Framework is more than just a content management
system, due to the separation of the streamlined core and optional
plugins (extensions). TYPO3 has an open API that allows you to extend
the frontend (website) and/or backend (administration) functionality.

The concept of extensions makes TYPO3 capable of being developed and
used in almost any way you can imagine, either by using any of the many
extensions which are available for download, or by writing your own.

TYPO3 System requirements
-------------------------

TYPO3 is based upon PHP and uses a database management system like
MySQL.

For more specific information regarding requirements see the file
[INSTALL.md](INSTALL.md#server-system-requirements) in this folder.

TYPO3 resources
---------------

Here is an overview of the most important TYPO3 resources to help you
get started:

### Get more information

* https://typo3.org/ is the main project website. It provides up-to-date
  official news, information about events and the TYPO3 community.

* https://docs.typo3.org/: TYPO3 is one of the most thoroughly
  documented OpenSource products around, with manuals covering basic
  tutorials, TypoScript, administration, development, core structure,
  etc. You should make the time to locate the various documents, and
  read those that apply to the work you want to do.

* https://get.typo3.org/ is the platform where you can download TYPO3
  and find all release notes and change logs of TYPO3 releases.

* https://extensions.typo3.org/ is the platform where you can search for
  and download TYPO3 extensions.

### Chat with us

The TYPO3 community is using a tool called Slack to openly communicate
with each other and with the public. Several TYPO3 teams use Slack as a
way to communicate internally and most channels are a welcome place for
you to join and get yourself involved.

* Register: https://my.typo3.org/about-mytypo3org/slack
* Slack: https://typo3.slack.com/

### Exchange information, ask questions, get help

Slack is nice for short discussions, but when asking questions, most
answers are lost in the noise after a few minutes.

#### StackOverflow

**To let everyone profit from an answer, we recommend to ask questions
on StackOverflow**. If you like, you can then post a link into the
corresponding Slack channel to raise attention. And please, do not
forget to tag your questions correctly with `typo3` (and possibly other
tags like `typo3-9.5.x`, `Fluid` or `Extbase`).

* [StackOverflow questions tagged "TYPO3"](https://stackoverflow.com/questions/tagged/typo3)

#### Official meet the TYPO3 Community overview:

Visit https://typo3.org/community/meet/

Contributing
------------

If you want to contribute to the TYPO3 source code, take a look at our
Contributors Walkthrough and Review System:

* https://docs.typo3.org/core-contribution
* https://review.typo3.org/

> Please use the [TYPO3 Slack chat](#chat-with-us), if you need help in
> setting up your contribution environment. The community is very
> helpful and get you up and running! (Please post your questions in
> Slack Channel `#typo3-cms-coredev` regarding contribution support)

The [repository at GitHub](https://github.com/typo3/typo3) is a
synchronized mirror of the primary TYPO3 core git repository:

* https://git.typo3.org/typo3/typo3

If you want to file a bug report, take a look at:

* [https://forge.typo3.org](https://forge.typo3.org/projects/typo3cms-core/issues)

Security
--------

If you learn about a potential security issue in the TYPO3 core or in
an extension, please always contact the TYPO3 Security Team via security@typo3.org.
Please always include the version number where you've discovered the issue.
If we can confirm a problem in a third-party extension, we will inform the
author immediately.

If you discover a security problem in your own extension, please inform
the TYPO3 Security Team as well. They can help you to fix it, and they
may want to issue an advisory once it is fixed.

For more details see [TYPO3 Security Team](https://typo3.org/community/teams/security/).

Final notes
-----------

TYPO3 is said to be one of the most sophisticated PHP / Internet related
applications available, and the more you play with it, the more you will
agree.

Due to the advanced level of the code and functionality, a degree of
study, time and perseverance is required to fully understand it, and get
the best from it. You should keep trying, as we say it's definitely
worth it. TYPO3 is the Enterprise Content Management System "for all".

The GPL license allows for developments that are based upon TYPO3 to
also be freely available under the GPL. Please remember this, because
TYPO3 is about "Inspiring People To Share". If you are making money with
TYPO3 you can donate or become a member of the
[TYPO3 Association](https://typo3.org/association).

By becoming a supporting member, individuals and organisations mainly
fund core development of TYPO3. The decision about what the funds are
used for, is made by all members of the Association and the TYPO3
Association Board. The decisions will be made transparent to the community
and especially the supporting members. Your funds will also serve for
other purposes as laid out in the bylaws.

* [Donate to TYPO3](https://typo3.org/donate)
* [Become a member of the TYPO3 Association](
  https://typo3.org/membership)

Copyleft
--------

This document is a part of the TYPO3 project.
