/*!
 * @kurkle/color v0.3.2
 * https://github.com/kurkle/color#readme
 * (c) 2023 Jukka Kurkela
 * Released under the MIT License
 */
function round(t){return t+.5|0}const lim=(t,e,i)=>Math.max(Math.min(t,i),e);function p2b(t){return lim(round(2.55*t),0,255)}function n2b(t){return lim(round(255*t),0,255)}function b2n(t){return lim(round(t/2.55)/100,0,1)}function n2p(t){return lim(round(100*t),0,100)}const map$1={0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9,A:10,B:11,C:12,D:13,E:14,F:15,a:10,b:11,c:12,d:13,e:14,f:15},hex=[..."0123456789ABCDEF"],h1=t=>hex[15&t],h2=t=>hex[(240&t)>>4]+hex[15&t],eq=t=>(240&t)>>4==(15&t),isShort=t=>eq(t.r)&&eq(t.g)&&eq(t.b)&&eq(t.a);function hexParse(t){var e,i=t.length;return"#"===t[0]&&(4===i||5===i?e={r:255&17*map$1[t[1]],g:255&17*map$1[t[2]],b:255&17*map$1[t[3]],a:5===i?17*map$1[t[4]]:255}:7!==i&&9!==i||(e={r:map$1[t[1]]<<4|map$1[t[2]],g:map$1[t[3]]<<4|map$1[t[4]],b:map$1[t[5]]<<4|map$1[t[6]],a:9===i?map$1[t[7]]<<4|map$1[t[8]]:255})),e}const alpha=(t,e)=>t<255?e(t):"";function hexString(t){var e=isShort(t)?h1:h2;return t?"#"+e(t.r)+e(t.g)+e(t.b)+alpha(t.a,e):void 0}const HUE_RE=/^(hsla?|hwb|hsv)\(\s*([-+.e\d]+)(?:deg)?[\s,]+([-+.e\d]+)%[\s,]+([-+.e\d]+)%(?:[\s,]+([-+.e\d]+)(%)?)?\s*\)$/;function hsl2rgbn(t,e,i){const s=e*Math.min(i,1-i),n=(e,n=(e+t/30)%12)=>i-s*Math.max(Math.min(n-3,9-n,1),-1);return[n(0),n(8),n(4)]}function hsv2rgbn(t,e,i){const s=(s,n=(s+t/60)%6)=>i-i*e*Math.max(Math.min(n,4-n,1),0);return[s(5),s(3),s(1)]}function hwb2rgbn(t,e,i){const s=hsl2rgbn(t,1,.5);let n;for(e+i>1&&(n=1/(e+i),e*=n,i*=n),n=0;n<3;n++)s[n]*=1-e-i,s[n]+=e;return s}function hueValue(t,e,i,s,n){return t===n?(e-i)/s+(e<i?6:0):e===n?(i-t)/s+2:(t-e)/s+4}function rgb2hsl(t){const e=t.r/255,i=t.g/255,s=t.b/255,n=Math.max(e,i,s),o=Math.min(e,i,s),a=(n+o)/2;let r,l,h;return n!==o&&(h=n-o,l=a>.5?h/(2-n-o):h/(n+o),r=hueValue(e,i,s,h,n),r=60*r+.5),[0|r,l||0,a]}function calln(t,e,i,s){return(Array.isArray(e)?t(e[0],e[1],e[2]):t(e,i,s)).map(n2b)}function hsl2rgb(t,e,i){return calln(hsl2rgbn,t,e,i)}function hwb2rgb(t,e,i){return calln(hwb2rgbn,t,e,i)}function hsv2rgb(t,e,i){return calln(hsv2rgbn,t,e,i)}function hue(t){return(t%360+360)%360}function hueParse(t){const e=HUE_RE.exec(t);let i,s=255;if(!e)return;e[5]!==i&&(s=e[6]?p2b(+e[5]):n2b(+e[5]));const n=hue(+e[2]),o=+e[3]/100,a=+e[4]/100;return i="hwb"===e[1]?hwb2rgb(n,o,a):"hsv"===e[1]?hsv2rgb(n,o,a):hsl2rgb(n,o,a),{r:i[0],g:i[1],b:i[2],a:s}}function rotate(t,e){var i=rgb2hsl(t);i[0]=hue(i[0]+e),i=hsl2rgb(i),t.r=i[0],t.g=i[1],t.b=i[2]}function hslString(t){if(!t)return;const e=rgb2hsl(t),i=e[0],s=n2p(e[1]),n=n2p(e[2]);return t.a<255?`hsla(${i}, ${s}%, ${n}%, ${b2n(t.a)})`:`hsl(${i}, ${s}%, ${n}%)`}const map$2={x:"dark",Z:"light",Y:"re",X:"blu",W:"gr",V:"medium",U:"slate",A:"ee",T:"ol",S:"or",B:"ra",C:"lateg",D:"ights",R:"in",Q:"turquois",E:"hi",P:"ro",O:"al",N:"le",M:"de",L:"yello",F:"en",K:"ch",G:"arks",H:"ea",I:"ightg",J:"wh"},names$1={OiceXe:"f0f8ff",antiquewEte:"faebd7",aqua:"ffff",aquamarRe:"7fffd4",azuY:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"0",blanKedOmond:"ffebcd",Xe:"ff",XeviTet:"8a2be2",bPwn:"a52a2a",burlywood:"deb887",caMtXe:"5f9ea0",KartYuse:"7fff00",KocTate:"d2691e",cSO:"ff7f50",cSnflowerXe:"6495ed",cSnsilk:"fff8dc",crimson:"dc143c",cyan:"ffff",xXe:"8b",xcyan:"8b8b",xgTMnPd:"b8860b",xWay:"a9a9a9",xgYF:"6400",xgYy:"a9a9a9",xkhaki:"bdb76b",xmagFta:"8b008b",xTivegYF:"556b2f",xSange:"ff8c00",xScEd:"9932cc",xYd:"8b0000",xsOmon:"e9967a",xsHgYF:"8fbc8f",xUXe:"483d8b",xUWay:"2f4f4f",xUgYy:"2f4f4f",xQe:"ced1",xviTet:"9400d3",dAppRk:"ff1493",dApskyXe:"bfff",dimWay:"696969",dimgYy:"696969",dodgerXe:"1e90ff",fiYbrick:"b22222",flSOwEte:"fffaf0",foYstWAn:"228b22",fuKsia:"ff00ff",gaRsbSo:"dcdcdc",ghostwEte:"f8f8ff",gTd:"ffd700",gTMnPd:"daa520",Way:"808080",gYF:"8000",gYFLw:"adff2f",gYy:"808080",honeyMw:"f0fff0",hotpRk:"ff69b4",RdianYd:"cd5c5c",Rdigo:"4b0082",ivSy:"fffff0",khaki:"f0e68c",lavFMr:"e6e6fa",lavFMrXsh:"fff0f5",lawngYF:"7cfc00",NmoncEffon:"fffacd",ZXe:"add8e6",ZcSO:"f08080",Zcyan:"e0ffff",ZgTMnPdLw:"fafad2",ZWay:"d3d3d3",ZgYF:"90ee90",ZgYy:"d3d3d3",ZpRk:"ffb6c1",ZsOmon:"ffa07a",ZsHgYF:"20b2aa",ZskyXe:"87cefa",ZUWay:"778899",ZUgYy:"778899",ZstAlXe:"b0c4de",ZLw:"ffffe0",lime:"ff00",limegYF:"32cd32",lRF:"faf0e6",magFta:"ff00ff",maPon:"800000",VaquamarRe:"66cdaa",VXe:"cd",VScEd:"ba55d3",VpurpN:"9370db",VsHgYF:"3cb371",VUXe:"7b68ee",VsprRggYF:"fa9a",VQe:"48d1cc",VviTetYd:"c71585",midnightXe:"191970",mRtcYam:"f5fffa",mistyPse:"ffe4e1",moccasR:"ffe4b5",navajowEte:"ffdead",navy:"80",Tdlace:"fdf5e6",Tive:"808000",TivedBb:"6b8e23",Sange:"ffa500",SangeYd:"ff4500",ScEd:"da70d6",pOegTMnPd:"eee8aa",pOegYF:"98fb98",pOeQe:"afeeee",pOeviTetYd:"db7093",papayawEp:"ffefd5",pHKpuff:"ffdab9",peru:"cd853f",pRk:"ffc0cb",plum:"dda0dd",powMrXe:"b0e0e6",purpN:"800080",YbeccapurpN:"663399",Yd:"ff0000",Psybrown:"bc8f8f",PyOXe:"4169e1",saddNbPwn:"8b4513",sOmon:"fa8072",sandybPwn:"f4a460",sHgYF:"2e8b57",sHshell:"fff5ee",siFna:"a0522d",silver:"c0c0c0",skyXe:"87ceeb",UXe:"6a5acd",UWay:"708090",UgYy:"708090",snow:"fffafa",sprRggYF:"ff7f",stAlXe:"4682b4",tan:"d2b48c",teO:"8080",tEstN:"d8bfd8",tomato:"ff6347",Qe:"40e0d0",viTet:"ee82ee",JHt:"f5deb3",wEte:"ffffff",wEtesmoke:"f5f5f5",Lw:"ffff00",LwgYF:"9acd32"};function unpack(){const t={},e=Object.keys(names$1),i=Object.keys(map$2);let s,n,o,a,r;for(s=0;s<e.length;s++){for(a=r=e[s],n=0;n<i.length;n++)o=i[n],r=r.replace(o,map$2[o]);o=parseInt(names$1[a],16),t[r]=[o>>16&255,o>>8&255,255&o]}return t}let names;function nameParse(t){names||(names=unpack(),names.transparent=[0,0,0,0]);const e=names[t.toLowerCase()];return e&&{r:e[0],g:e[1],b:e[2],a:4===e.length?e[3]:255}}const RGB_RE=/^rgba?\(\s*([-+.\d]+)(%)?[\s,]+([-+.e\d]+)(%)?[\s,]+([-+.e\d]+)(%)?(?:[\s,/]+([-+.e\d]+)(%)?)?\s*\)$/;function rgbParse(t){const e=RGB_RE.exec(t);let i,s,n,o=255;if(e){if(e[7]!==i){const t=+e[7];o=e[8]?p2b(t):lim(255*t,0,255)}return i=+e[1],s=+e[3],n=+e[5],i=255&(e[2]?p2b(i):lim(i,0,255)),s=255&(e[4]?p2b(s):lim(s,0,255)),n=255&(e[6]?p2b(n):lim(n,0,255)),{r:i,g:s,b:n,a:o}}}function rgbString(t){return t&&(t.a<255?`rgba(${t.r}, ${t.g}, ${t.b}, ${b2n(t.a)})`:`rgb(${t.r}, ${t.g}, ${t.b})`)}const to=t=>t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055,from=t=>t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4);function interpolate$1(t,e,i){const s=from(b2n(t.r)),n=from(b2n(t.g)),o=from(b2n(t.b));return{r:n2b(to(s+i*(from(b2n(e.r))-s))),g:n2b(to(n+i*(from(b2n(e.g))-n))),b:n2b(to(o+i*(from(b2n(e.b))-o))),a:t.a+i*(e.a-t.a)}}function modHSL(t,e,i){if(t){let s=rgb2hsl(t);s[e]=Math.max(0,Math.min(s[e]+s[e]*i,0===e?360:1)),s=hsl2rgb(s),t.r=s[0],t.g=s[1],t.b=s[2]}}function clone$1(t,e){return t?Object.assign(e||{},t):t}function fromObject(t){var e={r:0,g:0,b:0,a:255};return Array.isArray(t)?t.length>=3&&(e={r:t[0],g:t[1],b:t[2],a:255},t.length>3&&(e.a=n2b(t[3]))):(e=clone$1(t,{r:0,g:0,b:0,a:1})).a=n2b(e.a),e}function functionParse(t){return"r"===t.charAt(0)?rgbParse(t):hueParse(t)}class Color{constructor(t){if(t instanceof Color)return t;const e=typeof t;let i;"object"===e?i=fromObject(t):"string"===e&&(i=hexParse(t)||nameParse(t)||functionParse(t)),this._rgb=i,this._valid=!!i}get valid(){return this._valid}get rgb(){var t=clone$1(this._rgb);return t&&(t.a=b2n(t.a)),t}set rgb(t){this._rgb=fromObject(t)}rgbString(){return this._valid?rgbString(this._rgb):void 0}hexString(){return this._valid?hexString(this._rgb):void 0}hslString(){return this._valid?hslString(this._rgb):void 0}mix(t,e){if(t){const i=this.rgb,s=t.rgb;let n;const o=e===n?.5:e,a=2*o-1,r=i.a-s.a,l=((a*r==-1?a:(a+r)/(1+a*r))+1)/2;n=1-l,i.r=255&l*i.r+n*s.r+.5,i.g=255&l*i.g+n*s.g+.5,i.b=255&l*i.b+n*s.b+.5,i.a=o*i.a+(1-o)*s.a,this.rgb=i}return this}interpolate(t,e){return t&&(this._rgb=interpolate$1(this._rgb,t._rgb,e)),this}clone(){return new Color(this.rgb)}alpha(t){return this._rgb.a=n2b(t),this}clearer(t){return this._rgb.a*=1-t,this}greyscale(){const t=this._rgb,e=round(.3*t.r+.59*t.g+.11*t.b);return t.r=t.g=t.b=e,this}opaquer(t){return this._rgb.a*=1+t,this}negate(){const t=this._rgb;return t.r=255-t.r,t.g=255-t.g,t.b=255-t.b,this}lighten(t){return modHSL(this._rgb,2,t),this}darken(t){return modHSL(this._rgb,2,-t),this}saturate(t){return modHSL(this._rgb,1,t),this}desaturate(t){return modHSL(this._rgb,1,-t),this}rotate(t){return rotate(this._rgb,t),this}}
/*!
 * Chart.js v4.4.1
 * https://www.chartjs.org
 * (c) 2023 Chart.js Contributors
 * Released under the MIT License
 */function noop(){}const uid=(()=>{let t=0;return()=>t++})();function isNullOrUndef(t){return null==t}function isArray(t){if(Array.isArray&&Array.isArray(t))return!0;const e=Object.prototype.toString.call(t);return"[object"===e.slice(0,7)&&"Array]"===e.slice(-6)}function isObject(t){return null!==t&&"[object Object]"===Object.prototype.toString.call(t)}function isNumberFinite(t){return("number"==typeof t||t instanceof Number)&&isFinite(+t)}function finiteOrDefault(t,e){return isNumberFinite(t)?t:e}function valueOrDefault(t,e){return void 0===t?e:t}const toPercentage=(t,e)=>"string"==typeof t&&t.endsWith("%")?parseFloat(t)/100:+t/e,toDimension=(t,e)=>"string"==typeof t&&t.endsWith("%")?parseFloat(t)/100*e:+t;function callback(t,e,i){if(t&&"function"==typeof t.call)return t.apply(i,e)}function each(t,e,i,s){let n,o,a;if(isArray(t))if(o=t.length,s)for(n=o-1;n>=0;n--)e.call(i,t[n],n);else for(n=0;n<o;n++)e.call(i,t[n],n);else if(isObject(t))for(a=Object.keys(t),o=a.length,n=0;n<o;n++)e.call(i,t[a[n]],a[n])}function _elementsEqual(t,e){let i,s,n,o;if(!t||!e||t.length!==e.length)return!1;for(i=0,s=t.length;i<s;++i)if(n=t[i],o=e[i],n.datasetIndex!==o.datasetIndex||n.index!==o.index)return!1;return!0}function clone(t){if(isArray(t))return t.map(clone);if(isObject(t)){const e=Object.create(null),i=Object.keys(t),s=i.length;let n=0;for(;n<s;++n)e[i[n]]=clone(t[i[n]]);return e}return t}function isValidKey(t){return-1===["__proto__","prototype","constructor"].indexOf(t)}function _merger(t,e,i,s){if(!isValidKey(t))return;const n=e[t],o=i[t];isObject(n)&&isObject(o)?merge(n,o,s):e[t]=clone(o)}function merge(t,e,i){const s=isArray(e)?e:[e],n=s.length;if(!isObject(t))return t;const o=(i=i||{}).merger||_merger;let a;for(let e=0;e<n;++e){if(a=s[e],!isObject(a))continue;const n=Object.keys(a);for(let e=0,s=n.length;e<s;++e)o(n[e],t,a,i)}return t}function mergeIf(t,e){return merge(t,e,{merger:_mergerIf})}function _mergerIf(t,e,i){if(!isValidKey(t))return;const s=e[t],n=i[t];isObject(s)&&isObject(n)?mergeIf(s,n):Object.prototype.hasOwnProperty.call(e,t)||(e[t]=clone(n))}const keyResolvers={"":t=>t,x:t=>t.x,y:t=>t.y};function _splitKey(t){const e=t.split("."),i=[];let s="";for(const t of e)s+=t,s.endsWith("\\")?s=s.slice(0,-1)+".":(i.push(s),s="");return i}function _getKeyResolver(t){const e=_splitKey(t);return t=>{for(const i of e){if(""===i)break;t=t&&t[i]}return t}}function resolveObjectKey(t,e){return(keyResolvers[e]||(keyResolvers[e]=_getKeyResolver(e)))(t)}function _capitalize(t){return t.charAt(0).toUpperCase()+t.slice(1)}const defined=t=>void 0!==t,isFunction=t=>"function"==typeof t,setsEqual=(t,e)=>{if(t.size!==e.size)return!1;for(const i of t)if(!e.has(i))return!1;return!0};function _isClickEvent(t){return"mouseup"===t.type||"click"===t.type||"contextmenu"===t.type}const PI=Math.PI,TAU=2*PI,PITAU=TAU+PI,INFINITY=Number.POSITIVE_INFINITY,RAD_PER_DEG=PI/180,HALF_PI=PI/2,QUARTER_PI=PI/4,TWO_THIRDS_PI=2*PI/3,log10=Math.log10,sign=Math.sign;function almostEquals(t,e,i){return Math.abs(t-e)<i}function niceNum(t){const e=Math.round(t);t=almostEquals(t,e,t/1e3)?e:t;const i=Math.pow(10,Math.floor(log10(t))),s=t/i;return(s<=1?1:s<=2?2:s<=5?5:10)*i}function _factorize(t){const e=[],i=Math.sqrt(t);let s;for(s=1;s<i;s++)t%s==0&&(e.push(s),e.push(t/s));return i===(0|i)&&e.push(i),e.sort(((t,e)=>t-e)).pop(),e}function isNumber(t){return!isNaN(parseFloat(t))&&isFinite(t)}function almostWhole(t,e){const i=Math.round(t);return i-e<=t&&i+e>=t}function _setMinAndMaxByKey(t,e,i){let s,n,o;for(s=0,n=t.length;s<n;s++)o=t[s][i],isNaN(o)||(e.min=Math.min(e.min,o),e.max=Math.max(e.max,o))}function toRadians(t){return t*(PI/180)}function toDegrees(t){return t*(180/PI)}function _decimalPlaces(t){if(!isNumberFinite(t))return;let e=1,i=0;for(;Math.round(t*e)/e!==t;)e*=10,i++;return i}function getAngleFromPoint(t,e){const i=e.x-t.x,s=e.y-t.y,n=Math.sqrt(i*i+s*s);let o=Math.atan2(s,i);return o<-.5*PI&&(o+=TAU),{angle:o,distance:n}}function distanceBetweenPoints(t,e){return Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2))}function _angleDiff(t,e){return(t-e+PITAU)%TAU-PI}function _normalizeAngle(t){return(t%TAU+TAU)%TAU}function _angleBetween(t,e,i,s){const n=_normalizeAngle(t),o=_normalizeAngle(e),a=_normalizeAngle(i),r=_normalizeAngle(o-n),l=_normalizeAngle(a-n),h=_normalizeAngle(n-o),c=_normalizeAngle(n-a);return n===o||n===a||s&&o===a||r>l&&h<c}function _limitValue(t,e,i){return Math.max(e,Math.min(i,t))}function _int16Range(t){return _limitValue(t,-32768,32767)}function _isBetween(t,e,i,s=1e-6){return t>=Math.min(e,i)-s&&t<=Math.max(e,i)+s}function _lookup(t,e,i){i=i||(i=>t[i]<e);let s,n=t.length-1,o=0;for(;n-o>1;)s=o+n>>1,i(s)?o=s:n=s;return{lo:o,hi:n}}const _lookupByKey=(t,e,i,s)=>_lookup(t,i,s?s=>{const n=t[s][e];return n<i||n===i&&t[s+1][e]===i}:s=>t[s][e]<i),_rlookupByKey=(t,e,i)=>_lookup(t,i,(s=>t[s][e]>=i));function _filterBetween(t,e,i){let s=0,n=t.length;for(;s<n&&t[s]<e;)s++;for(;n>s&&t[n-1]>i;)n--;return s>0||n<t.length?t.slice(s,n):t}const arrayEvents=["push","pop","shift","splice","unshift"];function listenArrayEvents(t,e){t._chartjs?t._chartjs.listeners.push(e):(Object.defineProperty(t,"_chartjs",{configurable:!0,enumerable:!1,value:{listeners:[e]}}),arrayEvents.forEach((e=>{const i="_onData"+_capitalize(e),s=t[e];Object.defineProperty(t,e,{configurable:!0,enumerable:!1,value(...e){const n=s.apply(this,e);return t._chartjs.listeners.forEach((t=>{"function"==typeof t[i]&&t[i](...e)})),n}})})))}function unlistenArrayEvents(t,e){const i=t._chartjs;if(!i)return;const s=i.listeners,n=s.indexOf(e);-1!==n&&s.splice(n,1),s.length>0||(arrayEvents.forEach((e=>{delete t[e]})),delete t._chartjs)}function _arrayUnique(t){const e=new Set(t);return e.size===t.length?t:Array.from(e)}const requestAnimFrame="undefined"==typeof window?function(t){return t()}:window.requestAnimationFrame;function throttled(t,e){let i=[],s=!1;return function(...n){i=n,s||(s=!0,requestAnimFrame.call(window,(()=>{s=!1,t.apply(e,i)})))}}function debounce(t,e){let i;return function(...s){return e?(clearTimeout(i),i=setTimeout(t,e,s)):t.apply(this,s),e}}const _toLeftRightCenter=t=>"start"===t?"left":"end"===t?"right":"center",_alignStartEnd=(t,e,i)=>"start"===t?e:"end"===t?i:(e+i)/2,_textX=(t,e,i,s)=>t===(s?"left":"right")?i:"center"===t?(e+i)/2:e;function _getStartAndCountOfVisiblePoints(t,e,i){const s=e.length;let n=0,o=s;if(t._sorted){const{iScale:a,_parsed:r}=t,l=a.axis,{min:h,max:c,minDefined:d,maxDefined:u}=a.getUserBounds();d&&(n=_limitValue(Math.min(_lookupByKey(r,l,h).lo,i?s:_lookupByKey(e,l,a.getPixelForValue(h)).lo),0,s-1)),o=u?_limitValue(Math.max(_lookupByKey(r,a.axis,c,!0).hi+1,i?0:_lookupByKey(e,l,a.getPixelForValue(c),!0).hi+1),n,s)-n:s-n}return{start:n,count:o}}function _scaleRangesChanged(t){const{xScale:e,yScale:i,_scaleRanges:s}=t,n={xmin:e.min,xmax:e.max,ymin:i.min,ymax:i.max};if(!s)return t._scaleRanges=n,!0;const o=s.xmin!==e.min||s.xmax!==e.max||s.ymin!==i.min||s.ymax!==i.max;return Object.assign(s,n),o}const atEdge=t=>0===t||1===t,elasticIn=(t,e,i)=>-Math.pow(2,10*(t-=1))*Math.sin((t-e)*TAU/i),elasticOut=(t,e,i)=>Math.pow(2,-10*t)*Math.sin((t-e)*TAU/i)+1,effects={linear:t=>t,easeInQuad:t=>t*t,easeOutQuad:t=>-t*(t-2),easeInOutQuad:t=>(t/=.5)<1?.5*t*t:-.5*(--t*(t-2)-1),easeInCubic:t=>t*t*t,easeOutCubic:t=>(t-=1)*t*t+1,easeInOutCubic:t=>(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2),easeInQuart:t=>t*t*t*t,easeOutQuart:t=>-((t-=1)*t*t*t-1),easeInOutQuart:t=>(t/=.5)<1?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2),easeInQuint:t=>t*t*t*t*t,easeOutQuint:t=>(t-=1)*t*t*t*t+1,easeInOutQuint:t=>(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2),easeInSine:t=>1-Math.cos(t*HALF_PI),easeOutSine:t=>Math.sin(t*HALF_PI),easeInOutSine:t=>-.5*(Math.cos(PI*t)-1),easeInExpo:t=>0===t?0:Math.pow(2,10*(t-1)),easeOutExpo:t=>1===t?1:1-Math.pow(2,-10*t),easeInOutExpo:t=>atEdge(t)?t:t<.5?.5*Math.pow(2,10*(2*t-1)):.5*(2-Math.pow(2,-10*(2*t-1))),easeInCirc:t=>t>=1?t:-(Math.sqrt(1-t*t)-1),easeOutCirc:t=>Math.sqrt(1-(t-=1)*t),easeInOutCirc:t=>(t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1),easeInElastic:t=>atEdge(t)?t:elasticIn(t,.075,.3),easeOutElastic:t=>atEdge(t)?t:elasticOut(t,.075,.3),easeInOutElastic(t){const e=.1125;return atEdge(t)?t:t<.5?.5*elasticIn(2*t,e,.45):.5+.5*elasticOut(2*t-1,e,.45)},easeInBack(t){const e=1.70158;return t*t*((e+1)*t-e)},easeOutBack(t){const e=1.70158;return(t-=1)*t*((e+1)*t+e)+1},easeInOutBack(t){let e=1.70158;return(t/=.5)<1?t*t*((1+(e*=1.525))*t-e)*.5:.5*((t-=2)*t*((1+(e*=1.525))*t+e)+2)},easeInBounce:t=>1-effects.easeOutBounce(1-t),easeOutBounce(t){const e=7.5625,i=2.75;return t<1/i?e*t*t:t<2/i?e*(t-=1.5/i)*t+.75:t<2.5/i?e*(t-=2.25/i)*t+.9375:e*(t-=2.625/i)*t+.984375},easeInOutBounce:t=>t<.5?.5*effects.easeInBounce(2*t):.5*effects.easeOutBounce(2*t-1)+.5};function isPatternOrGradient(t){if(t&&"object"==typeof t){const e=t.toString();return"[object CanvasPattern]"===e||"[object CanvasGradient]"===e}return!1}function color(t){return isPatternOrGradient(t)?t:new Color(t)}function getHoverColor(t){return isPatternOrGradient(t)?t:new Color(t).saturate(.5).darken(.1).hexString()}const numbers=["x","y","borderWidth","radius","tension"],colors=["color","borderColor","backgroundColor"];function applyAnimationsDefaults(t){t.set("animation",{delay:void 0,duration:1e3,easing:"easeOutQuart",fn:void 0,from:void 0,loop:void 0,to:void 0,type:void 0}),t.describe("animation",{_fallback:!1,_indexable:!1,_scriptable:t=>"onProgress"!==t&&"onComplete"!==t&&"fn"!==t}),t.set("animations",{colors:{type:"color",properties:colors},numbers:{type:"number",properties:numbers}}),t.describe("animations",{_fallback:"animation"}),t.set("transitions",{active:{animation:{duration:400}},resize:{animation:{duration:0}},show:{animations:{colors:{from:"transparent"},visible:{type:"boolean",duration:0}}},hide:{animations:{colors:{to:"transparent"},visible:{type:"boolean",easing:"linear",fn:t=>0|t}}}})}function applyLayoutsDefaults(t){t.set("layout",{autoPadding:!0,padding:{top:0,right:0,bottom:0,left:0}})}const intlCache=new Map;function getNumberFormat(t,e){e=e||{};const i=t+JSON.stringify(e);let s=intlCache.get(i);return s||(s=new Intl.NumberFormat(t,e),intlCache.set(i,s)),s}function formatNumber(t,e,i){return getNumberFormat(e,i).format(t)}const formatters={values:t=>isArray(t)?t:""+t,numeric(t,e,i){if(0===t)return"0";const s=this.chart.options.locale;let n,o=t;if(i.length>1){const e=Math.max(Math.abs(i[0].value),Math.abs(i[i.length-1].value));(e<1e-4||e>1e15)&&(n="scientific"),o=calculateDelta(t,i)}const a=log10(Math.abs(o)),r=isNaN(a)?1:Math.max(Math.min(-1*Math.floor(a),20),0),l={notation:n,minimumFractionDigits:r,maximumFractionDigits:r};return Object.assign(l,this.options.ticks.format),formatNumber(t,s,l)},logarithmic(t,e,i){if(0===t)return"0";const s=i[e].significand||t/Math.pow(10,Math.floor(log10(t)));return[1,2,3,5,10,15].includes(s)||e>.8*i.length?formatters.numeric.call(this,t,e,i):""}};function calculateDelta(t,e){let i=e.length>3?e[2].value-e[1].value:e[1].value-e[0].value;return Math.abs(i)>=1&&t!==Math.floor(t)&&(i=t-Math.floor(t)),i}var Ticks={formatters};function applyScaleDefaults(t){t.set("scale",{display:!0,offset:!1,reverse:!1,beginAtZero:!1,bounds:"ticks",clip:!0,grace:0,grid:{display:!0,lineWidth:1,drawOnChartArea:!0,drawTicks:!0,tickLength:8,tickWidth:(t,e)=>e.lineWidth,tickColor:(t,e)=>e.color,offset:!1},border:{display:!0,dash:[],dashOffset:0,width:1},title:{display:!1,text:"",padding:{top:4,bottom:4}},ticks:{minRotation:0,maxRotation:50,mirror:!1,textStrokeWidth:0,textStrokeColor:"",padding:3,display:!0,autoSkip:!0,autoSkipPadding:3,labelOffset:0,callback:Ticks.formatters.values,minor:{},major:{},align:"center",crossAlign:"near",showLabelBackdrop:!1,backdropColor:"rgba(255, 255, 255, 0.75)",backdropPadding:2}}),t.route("scale.ticks","color","","color"),t.route("scale.grid","color","","borderColor"),t.route("scale.border","color","","borderColor"),t.route("scale.title","color","","color"),t.describe("scale",{_fallback:!1,_scriptable:t=>!t.startsWith("before")&&!t.startsWith("after")&&"callback"!==t&&"parser"!==t,_indexable:t=>"borderDash"!==t&&"tickBorderDash"!==t&&"dash"!==t}),t.describe("scales",{_fallback:"scale"}),t.describe("scale.ticks",{_scriptable:t=>"backdropPadding"!==t&&"callback"!==t,_indexable:t=>"backdropPadding"!==t})}const overrides=Object.create(null),descriptors=Object.create(null);function getScope$1(t,e){if(!e)return t;const i=e.split(".");for(let e=0,s=i.length;e<s;++e){const s=i[e];t=t[s]||(t[s]=Object.create(null))}return t}function set(t,e,i){return"string"==typeof e?merge(getScope$1(t,e),i):merge(getScope$1(t,""),e)}class Defaults{constructor(t,e){this.animation=void 0,this.backgroundColor="rgba(0,0,0,0.1)",this.borderColor="rgba(0,0,0,0.1)",this.color="#666",this.datasets={},this.devicePixelRatio=t=>t.chart.platform.getDevicePixelRatio(),this.elements={},this.events=["mousemove","mouseout","click","touchstart","touchmove"],this.font={family:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",size:12,style:"normal",lineHeight:1.2,weight:null},this.hover={},this.hoverBackgroundColor=(t,e)=>getHoverColor(e.backgroundColor),this.hoverBorderColor=(t,e)=>getHoverColor(e.borderColor),this.hoverColor=(t,e)=>getHoverColor(e.color),this.indexAxis="x",this.interaction={mode:"nearest",intersect:!0,includeInvisible:!1},this.maintainAspectRatio=!0,this.onHover=null,this.onClick=null,this.parsing=!0,this.plugins={},this.responsive=!0,this.scale=void 0,this.scales={},this.showLine=!0,this.drawActiveElementsOnTop=!0,this.describe(t),this.apply(e)}set(t,e){return set(this,t,e)}get(t){return getScope$1(this,t)}describe(t,e){return set(descriptors,t,e)}override(t,e){return set(overrides,t,e)}route(t,e,i,s){const n=getScope$1(this,t),o=getScope$1(this,i),a="_"+e;Object.defineProperties(n,{[a]:{value:n[e],writable:!0},[e]:{enumerable:!0,get(){const t=this[a],e=o[s];return isObject(t)?Object.assign({},e,t):valueOrDefault(t,e)},set(t){this[a]=t}}})}apply(t){t.forEach((t=>t(this)))}}var defaults=new Defaults({_scriptable:t=>!t.startsWith("on"),_indexable:t=>"events"!==t,hover:{_fallback:"interaction"},interaction:{_scriptable:!1,_indexable:!1}},[applyAnimationsDefaults,applyLayoutsDefaults,applyScaleDefaults]);function toFontString(t){return!t||isNullOrUndef(t.size)||isNullOrUndef(t.family)?null:(t.style?t.style+" ":"")+(t.weight?t.weight+" ":"")+t.size+"px "+t.family}function _measureText(t,e,i,s,n){let o=e[n];return o||(o=e[n]=t.measureText(n).width,i.push(n)),o>s&&(s=o),s}function _longestText(t,e,i,s){let n=(s=s||{}).data=s.data||{},o=s.garbageCollect=s.garbageCollect||[];s.font!==e&&(n=s.data={},o=s.garbageCollect=[],s.font=e),t.save(),t.font=e;let a=0;const r=i.length;let l,h,c,d,u;for(l=0;l<r;l++)if(d=i[l],null==d||isArray(d)){if(isArray(d))for(h=0,c=d.length;h<c;h++)u=d[h],null==u||isArray(u)||(a=_measureText(t,n,o,a,u))}else a=_measureText(t,n,o,a,d);t.restore();const g=o.length/2;if(g>i.length){for(l=0;l<g;l++)delete n[o[l]];o.splice(0,g)}return a}function _alignPixel(t,e,i){const s=t.currentDevicePixelRatio,n=0!==i?Math.max(i/2,.5):0;return Math.round((e-n)*s)/s+n}function clearCanvas(t,e){(e=e||t.getContext("2d")).save(),e.resetTransform(),e.clearRect(0,0,t.width,t.height),e.restore()}function drawPoint(t,e,i,s){drawPointLegend(t,e,i,s,null)}function drawPointLegend(t,e,i,s,n){let o,a,r,l,h,c,d,u;const g=e.pointStyle,f=e.rotation,p=e.radius;let m=(f||0)*RAD_PER_DEG;if(g&&"object"==typeof g&&(o=g.toString(),"[object HTMLImageElement]"===o||"[object HTMLCanvasElement]"===o))return t.save(),t.translate(i,s),t.rotate(m),t.drawImage(g,-g.width/2,-g.height/2,g.width,g.height),void t.restore();if(!(isNaN(p)||p<=0)){switch(t.beginPath(),g){default:n?t.ellipse(i,s,n/2,p,0,0,TAU):t.arc(i,s,p,0,TAU),t.closePath();break;case"triangle":c=n?n/2:p,t.moveTo(i+Math.sin(m)*c,s-Math.cos(m)*p),m+=TWO_THIRDS_PI,t.lineTo(i+Math.sin(m)*c,s-Math.cos(m)*p),m+=TWO_THIRDS_PI,t.lineTo(i+Math.sin(m)*c,s-Math.cos(m)*p),t.closePath();break;case"rectRounded":h=.516*p,l=p-h,a=Math.cos(m+QUARTER_PI)*l,d=Math.cos(m+QUARTER_PI)*(n?n/2-h:l),r=Math.sin(m+QUARTER_PI)*l,u=Math.sin(m+QUARTER_PI)*(n?n/2-h:l),t.arc(i-d,s-r,h,m-PI,m-HALF_PI),t.arc(i+u,s-a,h,m-HALF_PI,m),t.arc(i+d,s+r,h,m,m+HALF_PI),t.arc(i-u,s+a,h,m+HALF_PI,m+PI),t.closePath();break;case"rect":if(!f){l=Math.SQRT1_2*p,c=n?n/2:l,t.rect(i-c,s-l,2*c,2*l);break}m+=QUARTER_PI;case"rectRot":d=Math.cos(m)*(n?n/2:p),a=Math.cos(m)*p,r=Math.sin(m)*p,u=Math.sin(m)*(n?n/2:p),t.moveTo(i-d,s-r),t.lineTo(i+u,s-a),t.lineTo(i+d,s+r),t.lineTo(i-u,s+a),t.closePath();break;case"crossRot":m+=QUARTER_PI;case"cross":d=Math.cos(m)*(n?n/2:p),a=Math.cos(m)*p,r=Math.sin(m)*p,u=Math.sin(m)*(n?n/2:p),t.moveTo(i-d,s-r),t.lineTo(i+d,s+r),t.moveTo(i+u,s-a),t.lineTo(i-u,s+a);break;case"star":d=Math.cos(m)*(n?n/2:p),a=Math.cos(m)*p,r=Math.sin(m)*p,u=Math.sin(m)*(n?n/2:p),t.moveTo(i-d,s-r),t.lineTo(i+d,s+r),t.moveTo(i+u,s-a),t.lineTo(i-u,s+a),m+=QUARTER_PI,d=Math.cos(m)*(n?n/2:p),a=Math.cos(m)*p,r=Math.sin(m)*p,u=Math.sin(m)*(n?n/2:p),t.moveTo(i-d,s-r),t.lineTo(i+d,s+r),t.moveTo(i+u,s-a),t.lineTo(i-u,s+a);break;case"line":a=n?n/2:Math.cos(m)*p,r=Math.sin(m)*p,t.moveTo(i-a,s-r),t.lineTo(i+a,s+r);break;case"dash":t.moveTo(i,s),t.lineTo(i+Math.cos(m)*(n?n/2:p),s+Math.sin(m)*p);break;case!1:t.closePath()}t.fill(),e.borderWidth>0&&t.stroke()}}function _isPointInArea(t,e,i){return i=i||.5,!e||t&&t.x>e.left-i&&t.x<e.right+i&&t.y>e.top-i&&t.y<e.bottom+i}function clipArea(t,e){t.save(),t.beginPath(),t.rect(e.left,e.top,e.right-e.left,e.bottom-e.top),t.clip()}function unclipArea(t){t.restore()}function _steppedLineTo(t,e,i,s,n){if(!e)return t.lineTo(i.x,i.y);if("middle"===n){const s=(e.x+i.x)/2;t.lineTo(s,e.y),t.lineTo(s,i.y)}else"after"===n!=!!s?t.lineTo(e.x,i.y):t.lineTo(i.x,e.y);t.lineTo(i.x,i.y)}function _bezierCurveTo(t,e,i,s){if(!e)return t.lineTo(i.x,i.y);t.bezierCurveTo(s?e.cp1x:e.cp2x,s?e.cp1y:e.cp2y,s?i.cp2x:i.cp1x,s?i.cp2y:i.cp1y,i.x,i.y)}function setRenderOpts(t,e){e.translation&&t.translate(e.translation[0],e.translation[1]),isNullOrUndef(e.rotation)||t.rotate(e.rotation),e.color&&(t.fillStyle=e.color),e.textAlign&&(t.textAlign=e.textAlign),e.textBaseline&&(t.textBaseline=e.textBaseline)}function decorateText(t,e,i,s,n){if(n.strikethrough||n.underline){const o=t.measureText(s),a=e-o.actualBoundingBoxLeft,r=e+o.actualBoundingBoxRight,l=i-o.actualBoundingBoxAscent,h=i+o.actualBoundingBoxDescent,c=n.strikethrough?(l+h)/2:h;t.strokeStyle=t.fillStyle,t.beginPath(),t.lineWidth=n.decorationWidth||2,t.moveTo(a,c),t.lineTo(r,c),t.stroke()}}function drawBackdrop(t,e){const i=t.fillStyle;t.fillStyle=e.color,t.fillRect(e.left,e.top,e.width,e.height),t.fillStyle=i}function renderText(t,e,i,s,n,o={}){const a=isArray(e)?e:[e],r=o.strokeWidth>0&&""!==o.strokeColor;let l,h;for(t.save(),t.font=n.string,setRenderOpts(t,o),l=0;l<a.length;++l)h=a[l],o.backdrop&&drawBackdrop(t,o.backdrop),r&&(o.strokeColor&&(t.strokeStyle=o.strokeColor),isNullOrUndef(o.strokeWidth)||(t.lineWidth=o.strokeWidth),t.strokeText(h,i,s,o.maxWidth)),t.fillText(h,i,s,o.maxWidth),decorateText(t,i,s,h,o),s+=Number(n.lineHeight);t.restore()}function addRoundedRectPath(t,e){const{x:i,y:s,w:n,h:o,radius:a}=e;t.arc(i+a.topLeft,s+a.topLeft,a.topLeft,1.5*PI,PI,!0),t.lineTo(i,s+o-a.bottomLeft),t.arc(i+a.bottomLeft,s+o-a.bottomLeft,a.bottomLeft,PI,HALF_PI,!0),t.lineTo(i+n-a.bottomRight,s+o),t.arc(i+n-a.bottomRight,s+o-a.bottomRight,a.bottomRight,HALF_PI,0,!0),t.lineTo(i+n,s+a.topRight),t.arc(i+n-a.topRight,s+a.topRight,a.topRight,0,-HALF_PI,!0),t.lineTo(i+a.topLeft,s)}const LINE_HEIGHT=/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/,FONT_STYLE=/^(normal|italic|initial|inherit|unset|(oblique( -?[0-9]?[0-9]deg)?))$/;function toLineHeight(t,e){const i=(""+t).match(LINE_HEIGHT);if(!i||"normal"===i[1])return 1.2*e;switch(t=+i[2],i[3]){case"px":return t;case"%":t/=100}return e*t}const numberOrZero=t=>+t||0;function _readValueToProps(t,e){const i={},s=isObject(e),n=s?Object.keys(e):e,o=isObject(t)?s?i=>valueOrDefault(t[i],t[e[i]]):e=>t[e]:()=>t;for(const t of n)i[t]=numberOrZero(o(t));return i}function toTRBL(t){return _readValueToProps(t,{top:"y",right:"x",bottom:"y",left:"x"})}function toTRBLCorners(t){return _readValueToProps(t,["topLeft","topRight","bottomLeft","bottomRight"])}function toPadding(t){const e=toTRBL(t);return e.width=e.left+e.right,e.height=e.top+e.bottom,e}function toFont(t,e){t=t||{},e=e||defaults.font;let i=valueOrDefault(t.size,e.size);"string"==typeof i&&(i=parseInt(i,10));let s=valueOrDefault(t.style,e.style);s&&!(""+s).match(FONT_STYLE)&&(console.warn('Invalid font style specified: "'+s+'"'),s=void 0);const n={family:valueOrDefault(t.family,e.family),lineHeight:toLineHeight(valueOrDefault(t.lineHeight,e.lineHeight),i),size:i,style:s,weight:valueOrDefault(t.weight,e.weight),string:""};return n.string=toFontString(n),n}function resolve(t,e,i,s){let n,o,a,r=!0;for(n=0,o=t.length;n<o;++n)if(a=t[n],void 0!==a&&(void 0!==e&&"function"==typeof a&&(a=a(e),r=!1),void 0!==i&&isArray(a)&&(a=a[i%a.length],r=!1),void 0!==a))return s&&!r&&(s.cacheable=!1),a}function _addGrace(t,e,i){const{min:s,max:n}=t,o=toDimension(e,(n-s)/2),a=(t,e)=>i&&0===t?0:t+e;return{min:a(s,-Math.abs(o)),max:a(n,o)}}function createContext(t,e){return Object.assign(Object.create(t),e)}function _createResolver(t,e=[""],i,s,n=(()=>t[0])){const o=i||t;void 0===s&&(s=_resolve("_fallback",t));const a={[Symbol.toStringTag]:"Object",_cacheable:!0,_scopes:t,_rootScopes:o,_fallback:s,_getTarget:n,override:i=>_createResolver([i,...t],e,o,s)};return new Proxy(a,{deleteProperty:(e,i)=>(delete e[i],delete e._keys,delete t[0][i],!0),get:(i,s)=>_cached(i,s,(()=>_resolveWithPrefixes(s,e,t,i))),getOwnPropertyDescriptor:(t,e)=>Reflect.getOwnPropertyDescriptor(t._scopes[0],e),getPrototypeOf:()=>Reflect.getPrototypeOf(t[0]),has:(t,e)=>getKeysFromAllScopes(t).includes(e),ownKeys:t=>getKeysFromAllScopes(t),set(t,e,i){const s=t._storage||(t._storage=n());return t[e]=s[e]=i,delete t._keys,!0}})}function _attachContext(t,e,i,s){const n={_cacheable:!1,_proxy:t,_context:e,_subProxy:i,_stack:new Set,_descriptors:_descriptors(t,s),setContext:e=>_attachContext(t,e,i,s),override:n=>_attachContext(t.override(n),e,i,s)};return new Proxy(n,{deleteProperty:(e,i)=>(delete e[i],delete t[i],!0),get:(t,e,i)=>_cached(t,e,(()=>_resolveWithContext(t,e,i))),getOwnPropertyDescriptor:(e,i)=>e._descriptors.allKeys?Reflect.has(t,i)?{enumerable:!0,configurable:!0}:void 0:Reflect.getOwnPropertyDescriptor(t,i),getPrototypeOf:()=>Reflect.getPrototypeOf(t),has:(e,i)=>Reflect.has(t,i),ownKeys:()=>Reflect.ownKeys(t),set:(e,i,s)=>(t[i]=s,delete e[i],!0)})}function _descriptors(t,e={scriptable:!0,indexable:!0}){const{_scriptable:i=e.scriptable,_indexable:s=e.indexable,_allKeys:n=e.allKeys}=t;return{allKeys:n,scriptable:i,indexable:s,isScriptable:isFunction(i)?i:()=>i,isIndexable:isFunction(s)?s:()=>s}}const readKey=(t,e)=>t?t+_capitalize(e):e,needsSubResolver=(t,e)=>isObject(e)&&"adapters"!==t&&(null===Object.getPrototypeOf(e)||e.constructor===Object);function _cached(t,e,i){if(Object.prototype.hasOwnProperty.call(t,e))return t[e];const s=i();return t[e]=s,s}function _resolveWithContext(t,e,i){const{_proxy:s,_context:n,_subProxy:o,_descriptors:a}=t;let r=s[e];return isFunction(r)&&a.isScriptable(e)&&(r=_resolveScriptable(e,r,t,i)),isArray(r)&&r.length&&(r=_resolveArray(e,r,t,a.isIndexable)),needsSubResolver(e,r)&&(r=_attachContext(r,n,o&&o[e],a)),r}function _resolveScriptable(t,e,i,s){const{_proxy:n,_context:o,_subProxy:a,_stack:r}=i;if(r.has(t))throw new Error("Recursion detected: "+Array.from(r).join("->")+"->"+t);r.add(t);let l=e(o,a||s);return r.delete(t),needsSubResolver(t,l)&&(l=createSubResolver(n._scopes,n,t,l)),l}function _resolveArray(t,e,i,s){const{_proxy:n,_context:o,_subProxy:a,_descriptors:r}=i;if(void 0!==o.index&&s(t))return e[o.index%e.length];if(isObject(e[0])){const i=e,s=n._scopes.filter((t=>t!==i));e=[];for(const l of i){const i=createSubResolver(s,n,t,l);e.push(_attachContext(i,o,a&&a[t],r))}}return e}function resolveFallback(t,e,i){return isFunction(t)?t(e,i):t}const getScope=(t,e)=>!0===t?e:"string"==typeof t?resolveObjectKey(e,t):void 0;function addScopes(t,e,i,s,n){for(const o of e){const e=getScope(i,o);if(e){t.add(e);const o=resolveFallback(e._fallback,i,n);if(void 0!==o&&o!==i&&o!==s)return o}else if(!1===e&&void 0!==s&&i!==s)return null}return!1}function createSubResolver(t,e,i,s){const n=e._rootScopes,o=resolveFallback(e._fallback,i,s),a=[...t,...n],r=new Set;r.add(s);let l=addScopesFromKey(r,a,i,o||i,s);return null!==l&&((void 0===o||o===i||(l=addScopesFromKey(r,a,o,l,s),null!==l))&&_createResolver(Array.from(r),[""],n,o,(()=>subGetTarget(e,i,s))))}function addScopesFromKey(t,e,i,s,n){for(;i;)i=addScopes(t,e,i,s,n);return i}function subGetTarget(t,e,i){const s=t._getTarget();e in s||(s[e]={});const n=s[e];return isArray(n)&&isObject(i)?i:n||{}}function _resolveWithPrefixes(t,e,i,s){let n;for(const o of e)if(n=_resolve(readKey(o,t),i),void 0!==n)return needsSubResolver(t,n)?createSubResolver(i,s,t,n):n}function _resolve(t,e){for(const i of e){if(!i)continue;const e=i[t];if(void 0!==e)return e}}function getKeysFromAllScopes(t){let e=t._keys;return e||(e=t._keys=resolveKeysFromAllScopes(t._scopes)),e}function resolveKeysFromAllScopes(t){const e=new Set;for(const i of t)for(const t of Object.keys(i).filter((t=>!t.startsWith("_"))))e.add(t);return Array.from(e)}function _parseObjectDataRadialScale(t,e,i,s){const{iScale:n}=t,{key:o="r"}=this._parsing,a=new Array(s);let r,l,h,c;for(r=0,l=s;r<l;++r)h=r+i,c=e[h],a[r]={r:n.parse(resolveObjectKey(c,o),h)};return a}const EPSILON=Number.EPSILON||1e-14,getPoint=(t,e)=>e<t.length&&!t[e].skip&&t[e],getValueAxis=t=>"x"===t?"y":"x";function splineCurve(t,e,i,s){const n=t.skip?e:t,o=e,a=i.skip?e:i,r=distanceBetweenPoints(o,n),l=distanceBetweenPoints(a,o);let h=r/(r+l),c=l/(r+l);h=isNaN(h)?0:h,c=isNaN(c)?0:c;const d=s*h,u=s*c;return{previous:{x:o.x-d*(a.x-n.x),y:o.y-d*(a.y-n.y)},next:{x:o.x+u*(a.x-n.x),y:o.y+u*(a.y-n.y)}}}function monotoneAdjust(t,e,i){const s=t.length;let n,o,a,r,l,h=getPoint(t,0);for(let c=0;c<s-1;++c)l=h,h=getPoint(t,c+1),l&&h&&(almostEquals(e[c],0,EPSILON)?i[c]=i[c+1]=0:(n=i[c]/e[c],o=i[c+1]/e[c],r=Math.pow(n,2)+Math.pow(o,2),r<=9||(a=3/Math.sqrt(r),i[c]=n*a*e[c],i[c+1]=o*a*e[c])))}function monotoneCompute(t,e,i="x"){const s=getValueAxis(i),n=t.length;let o,a,r,l=getPoint(t,0);for(let h=0;h<n;++h){if(a=r,r=l,l=getPoint(t,h+1),!r)continue;const n=r[i],c=r[s];a&&(o=(n-a[i])/3,r[`cp1${i}`]=n-o,r[`cp1${s}`]=c-o*e[h]),l&&(o=(l[i]-n)/3,r[`cp2${i}`]=n+o,r[`cp2${s}`]=c+o*e[h])}}function splineCurveMonotone(t,e="x"){const i=getValueAxis(e),s=t.length,n=Array(s).fill(0),o=Array(s);let a,r,l,h=getPoint(t,0);for(a=0;a<s;++a)if(r=l,l=h,h=getPoint(t,a+1),l){if(h){const t=h[e]-l[e];n[a]=0!==t?(h[i]-l[i])/t:0}o[a]=r?h?sign(n[a-1])!==sign(n[a])?0:(n[a-1]+n[a])/2:n[a-1]:n[a]}monotoneAdjust(t,n,o),monotoneCompute(t,o,e)}function capControlPoint(t,e,i){return Math.max(Math.min(t,i),e)}function capBezierPoints(t,e){let i,s,n,o,a,r=_isPointInArea(t[0],e);for(i=0,s=t.length;i<s;++i)a=o,o=r,r=i<s-1&&_isPointInArea(t[i+1],e),o&&(n=t[i],a&&(n.cp1x=capControlPoint(n.cp1x,e.left,e.right),n.cp1y=capControlPoint(n.cp1y,e.top,e.bottom)),r&&(n.cp2x=capControlPoint(n.cp2x,e.left,e.right),n.cp2y=capControlPoint(n.cp2y,e.top,e.bottom)))}function _updateBezierControlPoints(t,e,i,s,n){let o,a,r,l;if(e.spanGaps&&(t=t.filter((t=>!t.skip))),"monotone"===e.cubicInterpolationMode)splineCurveMonotone(t,n);else{let i=s?t[t.length-1]:t[0];for(o=0,a=t.length;o<a;++o)r=t[o],l=splineCurve(i,r,t[Math.min(o+1,a-(s?0:1))%a],e.tension),r.cp1x=l.previous.x,r.cp1y=l.previous.y,r.cp2x=l.next.x,r.cp2y=l.next.y,i=r}e.capBezierPoints&&capBezierPoints(t,i)}function _isDomSupported(){return"undefined"!=typeof window&&"undefined"!=typeof document}function _getParentNode(t){let e=t.parentNode;return e&&"[object ShadowRoot]"===e.toString()&&(e=e.host),e}function parseMaxStyle(t,e,i){let s;return"string"==typeof t?(s=parseInt(t,10),-1!==t.indexOf("%")&&(s=s/100*e.parentNode[i])):s=t,s}const getComputedStyle=t=>t.ownerDocument.defaultView.getComputedStyle(t,null);function getStyle(t,e){return getComputedStyle(t).getPropertyValue(e)}const positions=["top","right","bottom","left"];function getPositionedStyle(t,e,i){const s={};i=i?"-"+i:"";for(let n=0;n<4;n++){const o=positions[n];s[o]=parseFloat(t[e+"-"+o+i])||0}return s.width=s.left+s.right,s.height=s.top+s.bottom,s}const useOffsetPos=(t,e,i)=>(t>0||e>0)&&(!i||!i.shadowRoot);function getCanvasPosition(t,e){const i=t.touches,s=i&&i.length?i[0]:t,{offsetX:n,offsetY:o}=s;let a,r,l=!1;if(useOffsetPos(n,o,t.target))a=n,r=o;else{const t=e.getBoundingClientRect();a=s.clientX-t.left,r=s.clientY-t.top,l=!0}return{x:a,y:r,box:l}}function getRelativePosition(t,e){if("native"in t)return t;const{canvas:i,currentDevicePixelRatio:s}=e,n=getComputedStyle(i),o="border-box"===n.boxSizing,a=getPositionedStyle(n,"padding"),r=getPositionedStyle(n,"border","width"),{x:l,y:h,box:c}=getCanvasPosition(t,i),d=a.left+(c&&r.left),u=a.top+(c&&r.top);let{width:g,height:f}=e;return o&&(g-=a.width+r.width,f-=a.height+r.height),{x:Math.round((l-d)/g*i.width/s),y:Math.round((h-u)/f*i.height/s)}}function getContainerSize(t,e,i){let s,n;if(void 0===e||void 0===i){const o=_getParentNode(t);if(o){const t=o.getBoundingClientRect(),a=getComputedStyle(o),r=getPositionedStyle(a,"border","width"),l=getPositionedStyle(a,"padding");e=t.width-l.width-r.width,i=t.height-l.height-r.height,s=parseMaxStyle(a.maxWidth,o,"clientWidth"),n=parseMaxStyle(a.maxHeight,o,"clientHeight")}else e=t.clientWidth,i=t.clientHeight}return{width:e,height:i,maxWidth:s||INFINITY,maxHeight:n||INFINITY}}const round1=t=>Math.round(10*t)/10;function getMaximumSize(t,e,i,s){const n=getComputedStyle(t),o=getPositionedStyle(n,"margin"),a=parseMaxStyle(n.maxWidth,t,"clientWidth")||INFINITY,r=parseMaxStyle(n.maxHeight,t,"clientHeight")||INFINITY,l=getContainerSize(t,e,i);let{width:h,height:c}=l;if("content-box"===n.boxSizing){const t=getPositionedStyle(n,"border","width"),e=getPositionedStyle(n,"padding");h-=e.width+t.width,c-=e.height+t.height}h=Math.max(0,h-o.width),c=Math.max(0,s?h/s:c-o.height),h=round1(Math.min(h,a,l.maxWidth)),c=round1(Math.min(c,r,l.maxHeight)),h&&!c&&(c=round1(h/2));return(void 0!==e||void 0!==i)&&s&&l.height&&c>l.height&&(c=l.height,h=round1(Math.floor(c*s))),{width:h,height:c}}function retinaScale(t,e,i){const s=e||1,n=Math.floor(t.height*s),o=Math.floor(t.width*s);t.height=Math.floor(t.height),t.width=Math.floor(t.width);const a=t.canvas;return a.style&&(i||!a.style.height&&!a.style.width)&&(a.style.height=`${t.height}px`,a.style.width=`${t.width}px`),(t.currentDevicePixelRatio!==s||a.height!==n||a.width!==o)&&(t.currentDevicePixelRatio=s,a.height=n,a.width=o,t.ctx.setTransform(s,0,0,s,0,0),!0)}const supportsEventListenerOptions=function(){let t=!1;try{const e={get passive(){return t=!0,!1}};_isDomSupported()&&(window.addEventListener("test",null,e),window.removeEventListener("test",null,e))}catch(t){}return t}();function readUsedSize(t,e){const i=getStyle(t,e),s=i&&i.match(/^(\d+)(\.\d+)?px$/);return s?+s[1]:void 0}function _pointInLine(t,e,i,s){return{x:t.x+i*(e.x-t.x),y:t.y+i*(e.y-t.y)}}function _steppedInterpolation(t,e,i,s){return{x:t.x+i*(e.x-t.x),y:"middle"===s?i<.5?t.y:e.y:"after"===s?i<1?t.y:e.y:i>0?e.y:t.y}}function _bezierInterpolation(t,e,i,s){const n={x:t.cp2x,y:t.cp2y},o={x:e.cp1x,y:e.cp1y},a=_pointInLine(t,n,i),r=_pointInLine(n,o,i),l=_pointInLine(o,e,i),h=_pointInLine(a,r,i),c=_pointInLine(r,l,i);return _pointInLine(h,c,i)}const getRightToLeftAdapter=function(t,e){return{x:i=>t+t+e-i,setWidth(t){e=t},textAlign:t=>"center"===t?t:"right"===t?"left":"right",xPlus:(t,e)=>t-e,leftForLtr:(t,e)=>t-e}},getLeftToRightAdapter=function(){return{x:t=>t,setWidth(t){},textAlign:t=>t,xPlus:(t,e)=>t+e,leftForLtr:(t,e)=>t}};function getRtlAdapter(t,e,i){return t?getRightToLeftAdapter(e,i):getLeftToRightAdapter()}function overrideTextDirection(t,e){let i,s;"ltr"!==e&&"rtl"!==e||(i=t.canvas.style,s=[i.getPropertyValue("direction"),i.getPropertyPriority("direction")],i.setProperty("direction",e,"important"),t.prevTextDirection=s)}function restoreTextDirection(t,e){void 0!==e&&(delete t.prevTextDirection,t.canvas.style.setProperty("direction",e[0],e[1]))}function propertyFn(t){return"angle"===t?{between:_angleBetween,compare:_angleDiff,normalize:_normalizeAngle}:{between:_isBetween,compare:(t,e)=>t-e,normalize:t=>t}}function normalizeSegment({start:t,end:e,count:i,loop:s,style:n}){return{start:t%i,end:e%i,loop:s&&(e-t+1)%i==0,style:n}}function getSegment(t,e,i){const{property:s,start:n,end:o}=i,{between:a,normalize:r}=propertyFn(s),l=e.length;let h,c,{start:d,end:u,loop:g}=t;if(g){for(d+=l,u+=l,h=0,c=l;h<c&&a(r(e[d%l][s]),n,o);++h)d--,u--;d%=l,u%=l}return u<d&&(u+=l),{start:d,end:u,loop:g,style:t.style}}function _boundSegment(t,e,i){if(!i)return[t];const{property:s,start:n,end:o}=i,a=e.length,{compare:r,between:l,normalize:h}=propertyFn(s),{start:c,end:d,loop:u,style:g}=getSegment(t,e,i),f=[];let p,m,b,x=!1,_=null;const y=()=>x||l(n,b,p)&&0!==r(n,b),v=()=>!x||0===r(o,p)||l(o,b,p);for(let t=c,i=c;t<=d;++t)m=e[t%a],m.skip||(p=h(m[s]),p!==b&&(x=l(p,n,o),null===_&&y()&&(_=0===r(p,n)?t:i),null!==_&&v()&&(f.push(normalizeSegment({start:_,end:t,loop:u,count:a,style:g})),_=null),i=t,b=p));return null!==_&&f.push(normalizeSegment({start:_,end:d,loop:u,count:a,style:g})),f}function _boundSegments(t,e){const i=[],s=t.segments;for(let n=0;n<s.length;n++){const o=_boundSegment(s[n],t.points,e);o.length&&i.push(...o)}return i}function findStartAndEnd(t,e,i,s){let n=0,o=e-1;if(i&&!s)for(;n<e&&!t[n].skip;)n++;for(;n<e&&t[n].skip;)n++;for(n%=e,i&&(o+=n);o>n&&t[o%e].skip;)o--;return o%=e,{start:n,end:o}}function solidSegments(t,e,i,s){const n=t.length,o=[];let a,r=e,l=t[e];for(a=e+1;a<=i;++a){const i=t[a%n];i.skip||i.stop?l.skip||(s=!1,o.push({start:e%n,end:(a-1)%n,loop:s}),e=r=i.stop?a:null):(r=a,l.skip&&(e=a)),l=i}return null!==r&&o.push({start:e%n,end:r%n,loop:s}),o}function _computeSegments(t,e){const i=t.points,s=t.options.spanGaps,n=i.length;if(!n)return[];const o=!!t._loop,{start:a,end:r}=findStartAndEnd(i,n,o,s);if(!0===s)return splitByStyles(t,[{start:a,end:r,loop:o}],i,e);return splitByStyles(t,solidSegments(i,a,r<a?r+n:r,!!t._fullLoop&&0===a&&r===n-1),i,e)}function splitByStyles(t,e,i,s){return s&&s.setContext&&i?doSplitByStyles(t,e,i,s):e}function doSplitByStyles(t,e,i,s){const n=t._chart.getContext(),o=readStyle(t.options),{_datasetIndex:a,options:{spanGaps:r}}=t,l=i.length,h=[];let c=o,d=e[0].start,u=d;function g(t,e,s,n){const o=r?-1:1;if(t!==e){for(t+=l;i[t%l].skip;)t-=o;for(;i[e%l].skip;)e+=o;t%l!=e%l&&(h.push({start:t%l,end:e%l,loop:s,style:n}),c=n,d=e%l)}}for(const t of e){d=r?d:t.start;let e,o=i[d%l];for(u=d+1;u<=t.end;u++){const r=i[u%l];e=readStyle(s.setContext(createContext(n,{type:"segment",p0:o,p1:r,p0DataIndex:(u-1)%l,p1DataIndex:u%l,datasetIndex:a}))),styleChanged(e,c)&&g(d,u-1,t.loop,c),o=r,c=e}d<u-1&&g(d,u-1,t.loop,c)}return h}function readStyle(t){return{backgroundColor:t.backgroundColor,borderCapStyle:t.borderCapStyle,borderDash:t.borderDash,borderDashOffset:t.borderDashOffset,borderJoinStyle:t.borderJoinStyle,borderWidth:t.borderWidth,borderColor:t.borderColor}}function styleChanged(t,e){if(!e)return!1;const i=[],s=function(t,e){return isPatternOrGradient(e)?(i.includes(e)||i.push(e),i.indexOf(e)):e};return JSON.stringify(t,s)!==JSON.stringify(e,s)}
/*!
 * Chart.js v4.4.1
 * https://www.chartjs.org
 * (c) 2023 Chart.js Contributors
 * Released under the MIT License
 */class Animator{constructor(){this._request=null,this._charts=new Map,this._running=!1,this._lastDate=void 0}_notify(t,e,i,s){const n=e.listeners[s],o=e.duration;n.forEach((s=>s({chart:t,initial:e.initial,numSteps:o,currentStep:Math.min(i-e.start,o)})))}_refresh(){this._request||(this._running=!0,this._request=requestAnimFrame.call(window,(()=>{this._update(),this._request=null,this._running&&this._refresh()})))}_update(t=Date.now()){let e=0;this._charts.forEach(((i,s)=>{if(!i.running||!i.items.length)return;const n=i.items;let o,a=n.length-1,r=!1;for(;a>=0;--a)o=n[a],o._active?(o._total>i.duration&&(i.duration=o._total),o.tick(t),r=!0):(n[a]=n[n.length-1],n.pop());r&&(s.draw(),this._notify(s,i,t,"progress")),n.length||(i.running=!1,this._notify(s,i,t,"complete"),i.initial=!1),e+=n.length})),this._lastDate=t,0===e&&(this._running=!1)}_getAnims(t){const e=this._charts;let i=e.get(t);return i||(i={running:!1,initial:!0,items:[],listeners:{complete:[],progress:[]}},e.set(t,i)),i}listen(t,e,i){this._getAnims(t).listeners[e].push(i)}add(t,e){e&&e.length&&this._getAnims(t).items.push(...e)}has(t){return this._getAnims(t).items.length>0}start(t){const e=this._charts.get(t);e&&(e.running=!0,e.start=Date.now(),e.duration=e.items.reduce(((t,e)=>Math.max(t,e._duration)),0),this._refresh())}running(t){if(!this._running)return!1;const e=this._charts.get(t);return!!(e&&e.running&&e.items.length)}stop(t){const e=this._charts.get(t);if(!e||!e.items.length)return;const i=e.items;let s=i.length-1;for(;s>=0;--s)i[s].cancel();e.items=[],this._notify(t,e,Date.now(),"complete")}remove(t){return this._charts.delete(t)}}var animator=new Animator;const transparent="transparent",interpolators={boolean:(t,e,i)=>i>.5?e:t,color(t,e,i){const s=color(t||transparent),n=s.valid&&color(e||transparent);return n&&n.valid?n.mix(s,i).hexString():e},number:(t,e,i)=>t+(e-t)*i};class Animation{constructor(t,e,i,s){const n=e[i];s=resolve([t.to,s,n,t.from]);const o=resolve([t.from,n,s]);this._active=!0,this._fn=t.fn||interpolators[t.type||typeof o],this._easing=effects[t.easing]||effects.linear,this._start=Math.floor(Date.now()+(t.delay||0)),this._duration=this._total=Math.floor(t.duration),this._loop=!!t.loop,this._target=e,this._prop=i,this._from=o,this._to=s,this._promises=void 0}active(){return this._active}update(t,e,i){if(this._active){this._notify(!1);const s=this._target[this._prop],n=i-this._start,o=this._duration-n;this._start=i,this._duration=Math.floor(Math.max(o,t.duration)),this._total+=n,this._loop=!!t.loop,this._to=resolve([t.to,e,s,t.from]),this._from=resolve([t.from,s,e])}}cancel(){this._active&&(this.tick(Date.now()),this._active=!1,this._notify(!1))}tick(t){const e=t-this._start,i=this._duration,s=this._prop,n=this._from,o=this._loop,a=this._to;let r;if(this._active=n!==a&&(o||e<i),!this._active)return this._target[s]=a,void this._notify(!0);e<0?this._target[s]=n:(r=e/i%2,r=o&&r>1?2-r:r,r=this._easing(Math.min(1,Math.max(0,r))),this._target[s]=this._fn(n,a,r))}wait(){const t=this._promises||(this._promises=[]);return new Promise(((e,i)=>{t.push({res:e,rej:i})}))}_notify(t){const e=t?"res":"rej",i=this._promises||[];for(let t=0;t<i.length;t++)i[t][e]()}}class Animations{constructor(t,e){this._chart=t,this._properties=new Map,this.configure(e)}configure(t){if(!isObject(t))return;const e=Object.keys(defaults.animation),i=this._properties;Object.getOwnPropertyNames(t).forEach((s=>{const n=t[s];if(!isObject(n))return;const o={};for(const t of e)o[t]=n[t];(isArray(n.properties)&&n.properties||[s]).forEach((t=>{t!==s&&i.has(t)||i.set(t,o)}))}))}_animateOptions(t,e){const i=e.options,s=resolveTargetOptions(t,i);if(!s)return[];const n=this._createAnimations(s,i);return i.$shared&&awaitAll(t.options.$animations,i).then((()=>{t.options=i}),(()=>{})),n}_createAnimations(t,e){const i=this._properties,s=[],n=t.$animations||(t.$animations={}),o=Object.keys(e),a=Date.now();let r;for(r=o.length-1;r>=0;--r){const l=o[r];if("$"===l.charAt(0))continue;if("options"===l){s.push(...this._animateOptions(t,e));continue}const h=e[l];let c=n[l];const d=i.get(l);if(c){if(d&&c.active()){c.update(d,h,a);continue}c.cancel()}d&&d.duration?(n[l]=c=new Animation(d,t,l,h),s.push(c)):t[l]=h}return s}update(t,e){if(0===this._properties.size)return void Object.assign(t,e);const i=this._createAnimations(t,e);return i.length?(animator.add(this._chart,i),!0):void 0}}function awaitAll(t,e){const i=[],s=Object.keys(e);for(let e=0;e<s.length;e++){const n=t[s[e]];n&&n.active()&&i.push(n.wait())}return Promise.all(i)}function resolveTargetOptions(t,e){if(!e)return;let i=t.options;if(i)return i.$shared&&(t.options=i=Object.assign({},i,{$shared:!1,$animations:{}})),i;t.options=e}function scaleClip(t,e){const i=t&&t.options||{},s=i.reverse,n=void 0===i.min?e:0,o=void 0===i.max?e:0;return{start:s?o:n,end:s?n:o}}function defaultClip(t,e,i){if(!1===i)return!1;const s=scaleClip(t,i),n=scaleClip(e,i);return{top:n.end,right:s.end,bottom:n.start,left:s.start}}function toClip(t){let e,i,s,n;return isObject(t)?(e=t.top,i=t.right,s=t.bottom,n=t.left):e=i=s=n=t,{top:e,right:i,bottom:s,left:n,disabled:!1===t}}function getSortedDatasetIndices(t,e){const i=[],s=t._getSortedDatasetMetas(e);let n,o;for(n=0,o=s.length;n<o;++n)i.push(s[n].index);return i}function applyStack(t,e,i,s={}){const n=t.keys,o="single"===s.mode;let a,r,l,h;if(null!==e){for(a=0,r=n.length;a<r;++a){if(l=+n[a],l===i){if(s.all)continue;break}h=t.values[l],isNumberFinite(h)&&(o||0===e||sign(e)===sign(h))&&(e+=h)}return e}}function convertObjectDataToArray(t){const e=Object.keys(t),i=new Array(e.length);let s,n,o;for(s=0,n=e.length;s<n;++s)o=e[s],i[s]={x:o,y:t[o]};return i}function isStacked(t,e){const i=t&&t.options.stacked;return i||void 0===i&&void 0!==e.stack}function getStackKey(t,e,i){return`${t.id}.${e.id}.${i.stack||i.type}`}function getUserBounds(t){const{min:e,max:i,minDefined:s,maxDefined:n}=t.getUserBounds();return{min:s?e:Number.NEGATIVE_INFINITY,max:n?i:Number.POSITIVE_INFINITY}}function getOrCreateStack(t,e,i){const s=t[e]||(t[e]={});return s[i]||(s[i]={})}function getLastIndexInStack(t,e,i,s){for(const n of e.getMatchingVisibleMetas(s).reverse()){const e=t[n.index];if(i&&e>0||!i&&e<0)return n.index}return null}function updateStacks(t,e){const{chart:i,_cachedMeta:s}=t,n=i._stacks||(i._stacks={}),{iScale:o,vScale:a,index:r}=s,l=o.axis,h=a.axis,c=getStackKey(o,a,s),d=e.length;let u;for(let t=0;t<d;++t){const i=e[t],{[l]:o,[h]:d}=i;u=(i._stacks||(i._stacks={}))[h]=getOrCreateStack(n,c,o),u[r]=d,u._top=getLastIndexInStack(u,a,!0,s.type),u._bottom=getLastIndexInStack(u,a,!1,s.type);(u._visualValues||(u._visualValues={}))[r]=d}}function getFirstScaleId(t,e){const i=t.scales;return Object.keys(i).filter((t=>i[t].axis===e)).shift()}function createDatasetContext(t,e){return createContext(t,{active:!1,dataset:void 0,datasetIndex:e,index:e,mode:"default",type:"dataset"})}function createDataContext(t,e,i){return createContext(t,{active:!1,dataIndex:e,parsed:void 0,raw:void 0,element:i,index:e,mode:"default",type:"data"})}function clearStacks(t,e){const i=t.controller.index,s=t.vScale&&t.vScale.axis;if(s){e=e||t._parsed;for(const t of e){const e=t._stacks;if(!e||void 0===e[s]||void 0===e[s][i])return;delete e[s][i],void 0!==e[s]._visualValues&&void 0!==e[s]._visualValues[i]&&delete e[s]._visualValues[i]}}}const isDirectUpdateMode=t=>"reset"===t||"none"===t,cloneIfNotShared=(t,e)=>e?t:Object.assign({},t),createStack=(t,e,i)=>t&&!e.hidden&&e._stacked&&{keys:getSortedDatasetIndices(i,!0),values:null};class DatasetController{static defaults={};static datasetElementType=null;static dataElementType=null;constructor(t,e){this.chart=t,this._ctx=t.ctx,this.index=e,this._cachedDataOpts={},this._cachedMeta=this.getMeta(),this._type=this._cachedMeta.type,this.options=void 0,this._parsing=!1,this._data=void 0,this._objectData=void 0,this._sharedOptions=void 0,this._drawStart=void 0,this._drawCount=void 0,this.enableOptionSharing=!1,this.supportsDecimation=!1,this.$context=void 0,this._syncList=[],this.datasetElementType=new.target.datasetElementType,this.dataElementType=new.target.dataElementType,this.initialize()}initialize(){const t=this._cachedMeta;this.configure(),this.linkScales(),t._stacked=isStacked(t.vScale,t),this.addElements(),this.options.fill&&!this.chart.isPluginEnabled("filler")&&console.warn("Tried to use the 'fill' option without the 'Filler' plugin enabled. Please import and register the 'Filler' plugin and make sure it is not disabled in the options")}updateIndex(t){this.index!==t&&clearStacks(this._cachedMeta),this.index=t}linkScales(){const t=this.chart,e=this._cachedMeta,i=this.getDataset(),s=(t,e,i,s)=>"x"===t?e:"r"===t?s:i,n=e.xAxisID=valueOrDefault(i.xAxisID,getFirstScaleId(t,"x")),o=e.yAxisID=valueOrDefault(i.yAxisID,getFirstScaleId(t,"y")),a=e.rAxisID=valueOrDefault(i.rAxisID,getFirstScaleId(t,"r")),r=e.indexAxis,l=e.iAxisID=s(r,n,o,a),h=e.vAxisID=s(r,o,n,a);e.xScale=this.getScaleForId(n),e.yScale=this.getScaleForId(o),e.rScale=this.getScaleForId(a),e.iScale=this.getScaleForId(l),e.vScale=this.getScaleForId(h)}getDataset(){return this.chart.data.datasets[this.index]}getMeta(){return this.chart.getDatasetMeta(this.index)}getScaleForId(t){return this.chart.scales[t]}_getOtherScale(t){const e=this._cachedMeta;return t===e.iScale?e.vScale:e.iScale}reset(){this._update("reset")}_destroy(){const t=this._cachedMeta;this._data&&unlistenArrayEvents(this._data,this),t._stacked&&clearStacks(t)}_dataCheck(){const t=this.getDataset(),e=t.data||(t.data=[]),i=this._data;if(isObject(e))this._data=convertObjectDataToArray(e);else if(i!==e){if(i){unlistenArrayEvents(i,this);const t=this._cachedMeta;clearStacks(t),t._parsed=[]}e&&Object.isExtensible(e)&&listenArrayEvents(e,this),this._syncList=[],this._data=e}}addElements(){const t=this._cachedMeta;this._dataCheck(),this.datasetElementType&&(t.dataset=new this.datasetElementType)}buildOrUpdateElements(t){const e=this._cachedMeta,i=this.getDataset();let s=!1;this._dataCheck();const n=e._stacked;e._stacked=isStacked(e.vScale,e),e.stack!==i.stack&&(s=!0,clearStacks(e),e.stack=i.stack),this._resyncElements(t),(s||n!==e._stacked)&&updateStacks(this,e._parsed)}configure(){const t=this.chart.config,e=t.datasetScopeKeys(this._type),i=t.getOptionScopes(this.getDataset(),e,!0);this.options=t.createResolver(i,this.getContext()),this._parsing=this.options.parsing,this._cachedDataOpts={}}parse(t,e){const{_cachedMeta:i,_data:s}=this,{iScale:n,_stacked:o}=i,a=n.axis;let r,l,h,c=0===t&&e===s.length||i._sorted,d=t>0&&i._parsed[t-1];if(!1===this._parsing)i._parsed=s,i._sorted=!0,h=s;else{h=isArray(s[t])?this.parseArrayData(i,s,t,e):isObject(s[t])?this.parseObjectData(i,s,t,e):this.parsePrimitiveData(i,s,t,e);const n=()=>null===l[a]||d&&l[a]<d[a];for(r=0;r<e;++r)i._parsed[r+t]=l=h[r],c&&(n()&&(c=!1),d=l);i._sorted=c}o&&updateStacks(this,h)}parsePrimitiveData(t,e,i,s){const{iScale:n,vScale:o}=t,a=n.axis,r=o.axis,l=n.getLabels(),h=n===o,c=new Array(s);let d,u,g;for(d=0,u=s;d<u;++d)g=d+i,c[d]={[a]:h||n.parse(l[g],g),[r]:o.parse(e[g],g)};return c}parseArrayData(t,e,i,s){const{xScale:n,yScale:o}=t,a=new Array(s);let r,l,h,c;for(r=0,l=s;r<l;++r)h=r+i,c=e[h],a[r]={x:n.parse(c[0],h),y:o.parse(c[1],h)};return a}parseObjectData(t,e,i,s){const{xScale:n,yScale:o}=t,{xAxisKey:a="x",yAxisKey:r="y"}=this._parsing,l=new Array(s);let h,c,d,u;for(h=0,c=s;h<c;++h)d=h+i,u=e[d],l[h]={x:n.parse(resolveObjectKey(u,a),d),y:o.parse(resolveObjectKey(u,r),d)};return l}getParsed(t){return this._cachedMeta._parsed[t]}getDataElement(t){return this._cachedMeta.data[t]}applyStack(t,e,i){const s=this.chart,n=this._cachedMeta,o=e[t.axis];return applyStack({keys:getSortedDatasetIndices(s,!0),values:e._stacks[t.axis]._visualValues},o,n.index,{mode:i})}updateRangeFromParsed(t,e,i,s){const n=i[e.axis];let o=null===n?NaN:n;const a=s&&i._stacks[e.axis];s&&a&&(s.values=a,o=applyStack(s,n,this._cachedMeta.index)),t.min=Math.min(t.min,o),t.max=Math.max(t.max,o)}getMinMax(t,e){const i=this._cachedMeta,s=i._parsed,n=i._sorted&&t===i.iScale,o=s.length,a=this._getOtherScale(t),r=createStack(e,i,this.chart),l={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY},{min:h,max:c}=getUserBounds(a);let d,u;function g(){u=s[d];const e=u[a.axis];return!isNumberFinite(u[t.axis])||h>e||c<e}for(d=0;d<o&&(g()||(this.updateRangeFromParsed(l,t,u,r),!n));++d);if(n)for(d=o-1;d>=0;--d)if(!g()){this.updateRangeFromParsed(l,t,u,r);break}return l}getAllParsedValues(t){const e=this._cachedMeta._parsed,i=[];let s,n,o;for(s=0,n=e.length;s<n;++s)o=e[s][t.axis],isNumberFinite(o)&&i.push(o);return i}getMaxOverflow(){return!1}getLabelAndValue(t){const e=this._cachedMeta,i=e.iScale,s=e.vScale,n=this.getParsed(t);return{label:i?""+i.getLabelForValue(n[i.axis]):"",value:s?""+s.getLabelForValue(n[s.axis]):""}}_update(t){const e=this._cachedMeta;this.update(t||"default"),e._clip=toClip(valueOrDefault(this.options.clip,defaultClip(e.xScale,e.yScale,this.getMaxOverflow())))}update(t){}draw(){const t=this._ctx,e=this.chart,i=this._cachedMeta,s=i.data||[],n=e.chartArea,o=[],a=this._drawStart||0,r=this._drawCount||s.length-a,l=this.options.drawActiveElementsOnTop;let h;for(i.dataset&&i.dataset.draw(t,n,a,r),h=a;h<a+r;++h){const e=s[h];e.hidden||(e.active&&l?o.push(e):e.draw(t,n))}for(h=0;h<o.length;++h)o[h].draw(t,n)}getStyle(t,e){const i=e?"active":"default";return void 0===t&&this._cachedMeta.dataset?this.resolveDatasetElementOptions(i):this.resolveDataElementOptions(t||0,i)}getContext(t,e,i){const s=this.getDataset();let n;if(t>=0&&t<this._cachedMeta.data.length){const e=this._cachedMeta.data[t];n=e.$context||(e.$context=createDataContext(this.getContext(),t,e)),n.parsed=this.getParsed(t),n.raw=s.data[t],n.index=n.dataIndex=t}else n=this.$context||(this.$context=createDatasetContext(this.chart.getContext(),this.index)),n.dataset=s,n.index=n.datasetIndex=this.index;return n.active=!!e,n.mode=i,n}resolveDatasetElementOptions(t){return this._resolveElementOptions(this.datasetElementType.id,t)}resolveDataElementOptions(t,e){return this._resolveElementOptions(this.dataElementType.id,e,t)}_resolveElementOptions(t,e="default",i){const s="active"===e,n=this._cachedDataOpts,o=t+"-"+e,a=n[o],r=this.enableOptionSharing&&defined(i);if(a)return cloneIfNotShared(a,r);const l=this.chart.config,h=l.datasetElementScopeKeys(this._type,t),c=s?[`${t}Hover`,"hover",t,""]:[t,""],d=l.getOptionScopes(this.getDataset(),h),u=Object.keys(defaults.elements[t]),g=l.resolveNamedOptions(d,u,(()=>this.getContext(i,s,e)),c);return g.$shared&&(g.$shared=r,n[o]=Object.freeze(cloneIfNotShared(g,r))),g}_resolveAnimations(t,e,i){const s=this.chart,n=this._cachedDataOpts,o=`animation-${e}`,a=n[o];if(a)return a;let r;if(!1!==s.options.animation){const s=this.chart.config,n=s.datasetAnimationScopeKeys(this._type,e),o=s.getOptionScopes(this.getDataset(),n);r=s.createResolver(o,this.getContext(t,i,e))}const l=new Animations(s,r&&r.animations);return r&&r._cacheable&&(n[o]=Object.freeze(l)),l}getSharedOptions(t){if(t.$shared)return this._sharedOptions||(this._sharedOptions=Object.assign({},t))}includeOptions(t,e){return!e||isDirectUpdateMode(t)||this.chart._animationsDisabled}_getSharedOptions(t,e){const i=this.resolveDataElementOptions(t,e),s=this._sharedOptions,n=this.getSharedOptions(i),o=this.includeOptions(e,n)||n!==s;return this.updateSharedOptions(n,e,i),{sharedOptions:n,includeOptions:o}}updateElement(t,e,i,s){isDirectUpdateMode(s)?Object.assign(t,i):this._resolveAnimations(e,s).update(t,i)}updateSharedOptions(t,e,i){t&&!isDirectUpdateMode(e)&&this._resolveAnimations(void 0,e).update(t,i)}_setStyle(t,e,i,s){t.active=s;const n=this.getStyle(e,s);this._resolveAnimations(e,i,s).update(t,{options:!s&&this.getSharedOptions(n)||n})}removeHoverStyle(t,e,i){this._setStyle(t,i,"active",!1)}setHoverStyle(t,e,i){this._setStyle(t,i,"active",!0)}_removeDatasetHoverStyle(){const t=this._cachedMeta.dataset;t&&this._setStyle(t,void 0,"active",!1)}_setDatasetHoverStyle(){const t=this._cachedMeta.dataset;t&&this._setStyle(t,void 0,"active",!0)}_resyncElements(t){const e=this._data,i=this._cachedMeta.data;for(const[t,e,i]of this._syncList)this[t](e,i);this._syncList=[];const s=i.length,n=e.length,o=Math.min(n,s);o&&this.parse(0,o),n>s?this._insertElements(s,n-s,t):n<s&&this._removeElements(n,s-n)}_insertElements(t,e,i=!0){const s=this._cachedMeta,n=s.data,o=t+e;let a;const r=t=>{for(t.length+=e,a=t.length-1;a>=o;a--)t[a]=t[a-e]};for(r(n),a=t;a<o;++a)n[a]=new this.dataElementType;this._parsing&&r(s._parsed),this.parse(t,e),i&&this.updateElements(n,t,e,"reset")}updateElements(t,e,i,s){}_removeElements(t,e){const i=this._cachedMeta;if(this._parsing){const s=i._parsed.splice(t,e);i._stacked&&clearStacks(i,s)}i.data.splice(t,e)}_sync(t){if(this._parsing)this._syncList.push(t);else{const[e,i,s]=t;this[e](i,s)}this.chart._dataChanges.push([this.index,...t])}_onDataPush(){const t=arguments.length;this._sync(["_insertElements",this.getDataset().data.length-t,t])}_onDataPop(){this._sync(["_removeElements",this._cachedMeta.data.length-1,1])}_onDataShift(){this._sync(["_removeElements",0,1])}_onDataSplice(t,e){e&&this._sync(["_removeElements",t,e]);const i=arguments.length-2;i&&this._sync(["_insertElements",t,i])}_onDataUnshift(){this._sync(["_insertElements",0,arguments.length])}}function getAllScaleValues(t,e){if(!t._cache.$bar){const i=t.getMatchingVisibleMetas(e);let s=[];for(let e=0,n=i.length;e<n;e++)s=s.concat(i[e].controller.getAllParsedValues(t));t._cache.$bar=_arrayUnique(s.sort(((t,e)=>t-e)))}return t._cache.$bar}function computeMinSampleSize(t){const e=t.iScale,i=getAllScaleValues(e,t.type);let s,n,o,a,r=e._length;const l=()=>{32767!==o&&-32768!==o&&(defined(a)&&(r=Math.min(r,Math.abs(o-a)||r)),a=o)};for(s=0,n=i.length;s<n;++s)o=e.getPixelForValue(i[s]),l();for(a=void 0,s=0,n=e.ticks.length;s<n;++s)o=e.getPixelForTick(s),l();return r}function computeFitCategoryTraits(t,e,i,s){const n=i.barThickness;let o,a;return isNullOrUndef(n)?(o=e.min*i.categoryPercentage,a=i.barPercentage):(o=n*s,a=1),{chunk:o/s,ratio:a,start:e.pixels[t]-o/2}}function computeFlexCategoryTraits(t,e,i,s){const n=e.pixels,o=n[t];let a=t>0?n[t-1]:null,r=t<n.length-1?n[t+1]:null;const l=i.categoryPercentage;null===a&&(a=o-(null===r?e.end-e.start:r-o)),null===r&&(r=o+o-a);const h=o-(o-Math.min(a,r))/2*l;return{chunk:Math.abs(r-a)/2*l/s,ratio:i.barPercentage,start:h}}function parseFloatBar(t,e,i,s){const n=i.parse(t[0],s),o=i.parse(t[1],s),a=Math.min(n,o),r=Math.max(n,o);let l=a,h=r;Math.abs(a)>Math.abs(r)&&(l=r,h=a),e[i.axis]=h,e._custom={barStart:l,barEnd:h,start:n,end:o,min:a,max:r}}function parseValue(t,e,i,s){return isArray(t)?parseFloatBar(t,e,i,s):e[i.axis]=i.parse(t,s),e}function parseArrayOrPrimitive(t,e,i,s){const n=t.iScale,o=t.vScale,a=n.getLabels(),r=n===o,l=[];let h,c,d,u;for(h=i,c=i+s;h<c;++h)u=e[h],d={},d[n.axis]=r||n.parse(a[h],h),l.push(parseValue(u,d,o,h));return l}function isFloatBar(t){return t&&void 0!==t.barStart&&void 0!==t.barEnd}function barSign(t,e,i){return 0!==t?sign(t):(e.isHorizontal()?1:-1)*(e.min>=i?1:-1)}function borderProps(t){let e,i,s,n,o;return t.horizontal?(e=t.base>t.x,i="left",s="right"):(e=t.base<t.y,i="bottom",s="top"),e?(n="end",o="start"):(n="start",o="end"),{start:i,end:s,reverse:e,top:n,bottom:o}}function setBorderSkipped(t,e,i,s){let n=e.borderSkipped;const o={};if(!n)return void(t.borderSkipped=o);if(!0===n)return void(t.borderSkipped={top:!0,right:!0,bottom:!0,left:!0});const{start:a,end:r,reverse:l,top:h,bottom:c}=borderProps(t);"middle"===n&&i&&(t.enableBorderRadius=!0,(i._top||0)===s?n=h:(i._bottom||0)===s?n=c:(o[parseEdge(c,a,r,l)]=!0,n=h)),o[parseEdge(n,a,r,l)]=!0,t.borderSkipped=o}function parseEdge(t,e,i,s){return t=s?startEnd(t=swap(t,e,i),i,e):startEnd(t,e,i)}function swap(t,e,i){return t===e?i:t===i?e:t}function startEnd(t,e,i){return"start"===t?e:"end"===t?i:t}function setInflateAmount(t,{inflateAmount:e},i){t.inflateAmount="auto"===e?1===i?.33:0:e}class BarController extends DatasetController{static id="bar";static defaults={datasetElementType:!1,dataElementType:"bar",categoryPercentage:.8,barPercentage:.9,grouped:!0,animations:{numbers:{type:"number",properties:["x","y","base","width","height"]}}};static overrides={scales:{_index_:{type:"category",offset:!0,grid:{offset:!0}},_value_:{type:"linear",beginAtZero:!0}}};parsePrimitiveData(t,e,i,s){return parseArrayOrPrimitive(t,e,i,s)}parseArrayData(t,e,i,s){return parseArrayOrPrimitive(t,e,i,s)}parseObjectData(t,e,i,s){const{iScale:n,vScale:o}=t,{xAxisKey:a="x",yAxisKey:r="y"}=this._parsing,l="x"===n.axis?a:r,h="x"===o.axis?a:r,c=[];let d,u,g,f;for(d=i,u=i+s;d<u;++d)f=e[d],g={},g[n.axis]=n.parse(resolveObjectKey(f,l),d),c.push(parseValue(resolveObjectKey(f,h),g,o,d));return c}updateRangeFromParsed(t,e,i,s){super.updateRangeFromParsed(t,e,i,s);const n=i._custom;n&&e===this._cachedMeta.vScale&&(t.min=Math.min(t.min,n.min),t.max=Math.max(t.max,n.max))}getMaxOverflow(){return 0}getLabelAndValue(t){const e=this._cachedMeta,{iScale:i,vScale:s}=e,n=this.getParsed(t),o=n._custom,a=isFloatBar(o)?"["+o.start+", "+o.end+"]":""+s.getLabelForValue(n[s.axis]);return{label:""+i.getLabelForValue(n[i.axis]),value:a}}initialize(){this.enableOptionSharing=!0,super.initialize();this._cachedMeta.stack=this.getDataset().stack}update(t){const e=this._cachedMeta;this.updateElements(e.data,0,e.data.length,t)}updateElements(t,e,i,s){const n="reset"===s,{index:o,_cachedMeta:{vScale:a}}=this,r=a.getBasePixel(),l=a.isHorizontal(),h=this._getRuler(),{sharedOptions:c,includeOptions:d}=this._getSharedOptions(e,s);for(let u=e;u<e+i;u++){const e=this.getParsed(u),i=n||isNullOrUndef(e[a.axis])?{base:r,head:r}:this._calculateBarValuePixels(u),g=this._calculateBarIndexPixels(u,h),f=(e._stacks||{})[a.axis],p={horizontal:l,base:i.base,enableBorderRadius:!f||isFloatBar(e._custom)||o===f._top||o===f._bottom,x:l?i.head:g.center,y:l?g.center:i.head,height:l?g.size:Math.abs(i.size),width:l?Math.abs(i.size):g.size};d&&(p.options=c||this.resolveDataElementOptions(u,t[u].active?"active":s));const m=p.options||t[u].options;setBorderSkipped(p,m,f,o),setInflateAmount(p,m,h.ratio),this.updateElement(t[u],u,p,s)}}_getStacks(t,e){const{iScale:i}=this._cachedMeta,s=i.getMatchingVisibleMetas(this._type).filter((t=>t.controller.options.grouped)),n=i.options.stacked,o=[],a=t=>{const i=t.controller.getParsed(e),s=i&&i[t.vScale.axis];if(isNullOrUndef(s)||isNaN(s))return!0};for(const i of s)if((void 0===e||!a(i))&&((!1===n||-1===o.indexOf(i.stack)||void 0===n&&void 0===i.stack)&&o.push(i.stack),i.index===t))break;return o.length||o.push(void 0),o}_getStackCount(t){return this._getStacks(void 0,t).length}_getStackIndex(t,e,i){const s=this._getStacks(t,i),n=void 0!==e?s.indexOf(e):-1;return-1===n?s.length-1:n}_getRuler(){const t=this.options,e=this._cachedMeta,i=e.iScale,s=[];let n,o;for(n=0,o=e.data.length;n<o;++n)s.push(i.getPixelForValue(this.getParsed(n)[i.axis],n));const a=t.barThickness;return{min:a||computeMinSampleSize(e),pixels:s,start:i._startPixel,end:i._endPixel,stackCount:this._getStackCount(),scale:i,grouped:t.grouped,ratio:a?1:t.categoryPercentage*t.barPercentage}}_calculateBarValuePixels(t){const{_cachedMeta:{vScale:e,_stacked:i,index:s},options:{base:n,minBarLength:o}}=this,a=n||0,r=this.getParsed(t),l=r._custom,h=isFloatBar(l);let c,d,u=r[e.axis],g=0,f=i?this.applyStack(e,r,i):u;f!==u&&(g=f-u,f=u),h&&(u=l.barStart,f=l.barEnd-l.barStart,0!==u&&sign(u)!==sign(l.barEnd)&&(g=0),g+=u);const p=isNullOrUndef(n)||h?g:n;let m=e.getPixelForValue(p);if(c=this.chart.getDataVisibility(t)?e.getPixelForValue(g+f):m,d=c-m,Math.abs(d)<o){d=barSign(d,e,a)*o,u===a&&(m-=d/2);const t=e.getPixelForDecimal(0),n=e.getPixelForDecimal(1),l=Math.min(t,n),g=Math.max(t,n);m=Math.max(Math.min(m,g),l),c=m+d,i&&!h&&(r._stacks[e.axis]._visualValues[s]=e.getValueForPixel(c)-e.getValueForPixel(m))}if(m===e.getPixelForValue(a)){const t=sign(d)*e.getLineWidthForValue(a)/2;m+=t,d-=t}return{size:d,base:m,head:c,center:c+d/2}}_calculateBarIndexPixels(t,e){const i=e.scale,s=this.options,n=s.skipNull,o=valueOrDefault(s.maxBarThickness,1/0);let a,r;if(e.grouped){const i=n?this._getStackCount(t):e.stackCount,l="flex"===s.barThickness?computeFlexCategoryTraits(t,e,s,i):computeFitCategoryTraits(t,e,s,i),h=this._getStackIndex(this.index,this._cachedMeta.stack,n?t:void 0);a=l.start+l.chunk*h+l.chunk/2,r=Math.min(o,l.chunk*l.ratio)}else a=i.getPixelForValue(this.getParsed(t)[i.axis],t),r=Math.min(o,e.min*e.ratio);return{base:a-r/2,head:a+r/2,center:a,size:r}}draw(){const t=this._cachedMeta,e=t.vScale,i=t.data,s=i.length;let n=0;for(;n<s;++n)null!==this.getParsed(n)[e.axis]&&i[n].draw(this._ctx)}}class BubbleController extends DatasetController{static id="bubble";static defaults={datasetElementType:!1,dataElementType:"point",animations:{numbers:{type:"number",properties:["x","y","borderWidth","radius"]}}};static overrides={scales:{x:{type:"linear"},y:{type:"linear"}}};initialize(){this.enableOptionSharing=!0,super.initialize()}parsePrimitiveData(t,e,i,s){const n=super.parsePrimitiveData(t,e,i,s);for(let t=0;t<n.length;t++)n[t]._custom=this.resolveDataElementOptions(t+i).radius;return n}parseArrayData(t,e,i,s){const n=super.parseArrayData(t,e,i,s);for(let t=0;t<n.length;t++){const s=e[i+t];n[t]._custom=valueOrDefault(s[2],this.resolveDataElementOptions(t+i).radius)}return n}parseObjectData(t,e,i,s){const n=super.parseObjectData(t,e,i,s);for(let t=0;t<n.length;t++){const s=e[i+t];n[t]._custom=valueOrDefault(s&&s.r&&+s.r,this.resolveDataElementOptions(t+i).radius)}return n}getMaxOverflow(){const t=this._cachedMeta.data;let e=0;for(let i=t.length-1;i>=0;--i)e=Math.max(e,t[i].size(this.resolveDataElementOptions(i))/2);return e>0&&e}getLabelAndValue(t){const e=this._cachedMeta,i=this.chart.data.labels||[],{xScale:s,yScale:n}=e,o=this.getParsed(t),a=s.getLabelForValue(o.x),r=n.getLabelForValue(o.y),l=o._custom;return{label:i[t]||"",value:"("+a+", "+r+(l?", "+l:"")+")"}}update(t){const e=this._cachedMeta.data;this.updateElements(e,0,e.length,t)}updateElements(t,e,i,s){const n="reset"===s,{iScale:o,vScale:a}=this._cachedMeta,{sharedOptions:r,includeOptions:l}=this._getSharedOptions(e,s),h=o.axis,c=a.axis;for(let d=e;d<e+i;d++){const e=t[d],i=!n&&this.getParsed(d),u={},g=u[h]=n?o.getPixelForDecimal(.5):o.getPixelForValue(i[h]),f=u[c]=n?a.getBasePixel():a.getPixelForValue(i[c]);u.skip=isNaN(g)||isNaN(f),l&&(u.options=r||this.resolveDataElementOptions(d,e.active?"active":s),n&&(u.options.radius=0)),this.updateElement(e,d,u,s)}}resolveDataElementOptions(t,e){const i=this.getParsed(t);let s=super.resolveDataElementOptions(t,e);s.$shared&&(s=Object.assign({},s,{$shared:!1}));const n=s.radius;return"active"!==e&&(s.radius=0),s.radius+=valueOrDefault(i&&i._custom,n),s}}function getRatioAndOffset(t,e,i){let s=1,n=1,o=0,a=0;if(e<TAU){const r=t,l=r+e,h=Math.cos(r),c=Math.sin(r),d=Math.cos(l),u=Math.sin(l),g=(t,e,s)=>_angleBetween(t,r,l,!0)?1:Math.max(e,e*i,s,s*i),f=(t,e,s)=>_angleBetween(t,r,l,!0)?-1:Math.min(e,e*i,s,s*i),p=g(0,h,d),m=g(HALF_PI,c,u),b=f(PI,h,d),x=f(PI+HALF_PI,c,u);s=(p-b)/2,n=(m-x)/2,o=-(p+b)/2,a=-(m+x)/2}return{ratioX:s,ratioY:n,offsetX:o,offsetY:a}}class DoughnutController extends DatasetController{static id="doughnut";static defaults={datasetElementType:!1,dataElementType:"arc",animation:{animateRotate:!0,animateScale:!1},animations:{numbers:{type:"number",properties:["circumference","endAngle","innerRadius","outerRadius","startAngle","x","y","offset","borderWidth","spacing"]}},cutout:"50%",rotation:0,circumference:360,radius:"100%",spacing:0,indexAxis:"r"};static descriptors={_scriptable:t=>"spacing"!==t,_indexable:t=>"spacing"!==t&&!t.startsWith("borderDash")&&!t.startsWith("hoverBorderDash")};static overrides={aspectRatio:1,plugins:{legend:{labels:{generateLabels(t){const e=t.data;if(e.labels.length&&e.datasets.length){const{labels:{pointStyle:i,color:s}}=t.legend.options;return e.labels.map(((e,n)=>{const o=t.getDatasetMeta(0).controller.getStyle(n);return{text:e,fillStyle:o.backgroundColor,strokeStyle:o.borderColor,fontColor:s,lineWidth:o.borderWidth,pointStyle:i,hidden:!t.getDataVisibility(n),index:n}}))}return[]}},onClick(t,e,i){i.chart.toggleDataVisibility(e.index),i.chart.update()}}}};constructor(t,e){super(t,e),this.enableOptionSharing=!0,this.innerRadius=void 0,this.outerRadius=void 0,this.offsetX=void 0,this.offsetY=void 0}linkScales(){}parse(t,e){const i=this.getDataset().data,s=this._cachedMeta;if(!1===this._parsing)s._parsed=i;else{let n,o,a=t=>+i[t];if(isObject(i[t])){const{key:t="value"}=this._parsing;a=e=>+resolveObjectKey(i[e],t)}for(n=t,o=t+e;n<o;++n)s._parsed[n]=a(n)}}_getRotation(){return toRadians(this.options.rotation-90)}_getCircumference(){return toRadians(this.options.circumference)}_getRotationExtents(){let t=TAU,e=-TAU;for(let i=0;i<this.chart.data.datasets.length;++i)if(this.chart.isDatasetVisible(i)&&this.chart.getDatasetMeta(i).type===this._type){const s=this.chart.getDatasetMeta(i).controller,n=s._getRotation(),o=s._getCircumference();t=Math.min(t,n),e=Math.max(e,n+o)}return{rotation:t,circumference:e-t}}update(t){const e=this.chart,{chartArea:i}=e,s=this._cachedMeta,n=s.data,o=this.getMaxBorderWidth()+this.getMaxOffset(n)+this.options.spacing,a=Math.max((Math.min(i.width,i.height)-o)/2,0),r=Math.min(toPercentage(this.options.cutout,a),1),l=this._getRingWeight(this.index),{circumference:h,rotation:c}=this._getRotationExtents(),{ratioX:d,ratioY:u,offsetX:g,offsetY:f}=getRatioAndOffset(c,h,r),p=(i.width-o)/d,m=(i.height-o)/u,b=Math.max(Math.min(p,m)/2,0),x=toDimension(this.options.radius,b),_=(x-Math.max(x*r,0))/this._getVisibleDatasetWeightTotal();this.offsetX=g*x,this.offsetY=f*x,s.total=this.calculateTotal(),this.outerRadius=x-_*this._getRingWeightOffset(this.index),this.innerRadius=Math.max(this.outerRadius-_*l,0),this.updateElements(n,0,n.length,t)}_circumference(t,e){const i=this.options,s=this._cachedMeta,n=this._getCircumference();return e&&i.animation.animateRotate||!this.chart.getDataVisibility(t)||null===s._parsed[t]||s.data[t].hidden?0:this.calculateCircumference(s._parsed[t]*n/TAU)}updateElements(t,e,i,s){const n="reset"===s,o=this.chart,a=o.chartArea,r=o.options.animation,l=(a.left+a.right)/2,h=(a.top+a.bottom)/2,c=n&&r.animateScale,d=c?0:this.innerRadius,u=c?0:this.outerRadius,{sharedOptions:g,includeOptions:f}=this._getSharedOptions(e,s);let p,m=this._getRotation();for(p=0;p<e;++p)m+=this._circumference(p,n);for(p=e;p<e+i;++p){const e=this._circumference(p,n),i=t[p],o={x:l+this.offsetX,y:h+this.offsetY,startAngle:m,endAngle:m+e,circumference:e,outerRadius:u,innerRadius:d};f&&(o.options=g||this.resolveDataElementOptions(p,i.active?"active":s)),m+=e,this.updateElement(i,p,o,s)}}calculateTotal(){const t=this._cachedMeta,e=t.data;let i,s=0;for(i=0;i<e.length;i++){const n=t._parsed[i];null===n||isNaN(n)||!this.chart.getDataVisibility(i)||e[i].hidden||(s+=Math.abs(n))}return s}calculateCircumference(t){const e=this._cachedMeta.total;return e>0&&!isNaN(t)?TAU*(Math.abs(t)/e):0}getLabelAndValue(t){const e=this._cachedMeta,i=this.chart,s=i.data.labels||[],n=formatNumber(e._parsed[t],i.options.locale);return{label:s[t]||"",value:n}}getMaxBorderWidth(t){let e=0;const i=this.chart;let s,n,o,a,r;if(!t)for(s=0,n=i.data.datasets.length;s<n;++s)if(i.isDatasetVisible(s)){o=i.getDatasetMeta(s),t=o.data,a=o.controller;break}if(!t)return 0;for(s=0,n=t.length;s<n;++s)r=a.resolveDataElementOptions(s),"inner"!==r.borderAlign&&(e=Math.max(e,r.borderWidth||0,r.hoverBorderWidth||0));return e}getMaxOffset(t){let e=0;for(let i=0,s=t.length;i<s;++i){const t=this.resolveDataElementOptions(i);e=Math.max(e,t.offset||0,t.hoverOffset||0)}return e}_getRingWeightOffset(t){let e=0;for(let i=0;i<t;++i)this.chart.isDatasetVisible(i)&&(e+=this._getRingWeight(i));return e}_getRingWeight(t){return Math.max(valueOrDefault(this.chart.data.datasets[t].weight,1),0)}_getVisibleDatasetWeightTotal(){return this._getRingWeightOffset(this.chart.data.datasets.length)||1}}class LineController extends DatasetController{static id="line";static defaults={datasetElementType:"line",dataElementType:"point",showLine:!0,spanGaps:!1};static overrides={scales:{_index_:{type:"category"},_value_:{type:"linear"}}};initialize(){this.enableOptionSharing=!0,this.supportsDecimation=!0,super.initialize()}update(t){const e=this._cachedMeta,{dataset:i,data:s=[],_dataset:n}=e,o=this.chart._animationsDisabled;let{start:a,count:r}=_getStartAndCountOfVisiblePoints(e,s,o);this._drawStart=a,this._drawCount=r,_scaleRangesChanged(e)&&(a=0,r=s.length),i._chart=this.chart,i._datasetIndex=this.index,i._decimated=!!n._decimated,i.points=s;const l=this.resolveDatasetElementOptions(t);this.options.showLine||(l.borderWidth=0),l.segment=this.options.segment,this.updateElement(i,void 0,{animated:!o,options:l},t),this.updateElements(s,a,r,t)}updateElements(t,e,i,s){const n="reset"===s,{iScale:o,vScale:a,_stacked:r,_dataset:l}=this._cachedMeta,{sharedOptions:h,includeOptions:c}=this._getSharedOptions(e,s),d=o.axis,u=a.axis,{spanGaps:g,segment:f}=this.options,p=isNumber(g)?g:Number.POSITIVE_INFINITY,m=this.chart._animationsDisabled||n||"none"===s,b=e+i,x=t.length;let _=e>0&&this.getParsed(e-1);for(let i=0;i<x;++i){const g=t[i],x=m?g:{};if(i<e||i>=b){x.skip=!0;continue}const y=this.getParsed(i),v=isNullOrUndef(y[u]),S=x[d]=o.getPixelForValue(y[d],i),k=x[u]=n||v?a.getBasePixel():a.getPixelForValue(r?this.applyStack(a,y,r):y[u],i);x.skip=isNaN(S)||isNaN(k)||v,x.stop=i>0&&Math.abs(y[d]-_[d])>p,f&&(x.parsed=y,x.raw=l.data[i]),c&&(x.options=h||this.resolveDataElementOptions(i,g.active?"active":s)),m||this.updateElement(g,i,x,s),_=y}}getMaxOverflow(){const t=this._cachedMeta,e=t.dataset,i=e.options&&e.options.borderWidth||0,s=t.data||[];if(!s.length)return i;const n=s[0].size(this.resolveDataElementOptions(0)),o=s[s.length-1].size(this.resolveDataElementOptions(s.length-1));return Math.max(i,n,o)/2}draw(){const t=this._cachedMeta;t.dataset.updateControlPoints(this.chart.chartArea,t.iScale.axis),super.draw()}}class PolarAreaController extends DatasetController{static id="polarArea";static defaults={dataElementType:"arc",animation:{animateRotate:!0,animateScale:!0},animations:{numbers:{type:"number",properties:["x","y","startAngle","endAngle","innerRadius","outerRadius"]}},indexAxis:"r",startAngle:0};static overrides={aspectRatio:1,plugins:{legend:{labels:{generateLabels(t){const e=t.data;if(e.labels.length&&e.datasets.length){const{labels:{pointStyle:i,color:s}}=t.legend.options;return e.labels.map(((e,n)=>{const o=t.getDatasetMeta(0).controller.getStyle(n);return{text:e,fillStyle:o.backgroundColor,strokeStyle:o.borderColor,fontColor:s,lineWidth:o.borderWidth,pointStyle:i,hidden:!t.getDataVisibility(n),index:n}}))}return[]}},onClick(t,e,i){i.chart.toggleDataVisibility(e.index),i.chart.update()}}},scales:{r:{type:"radialLinear",angleLines:{display:!1},beginAtZero:!0,grid:{circular:!0},pointLabels:{display:!1},startAngle:0}}};constructor(t,e){super(t,e),this.innerRadius=void 0,this.outerRadius=void 0}getLabelAndValue(t){const e=this._cachedMeta,i=this.chart,s=i.data.labels||[],n=formatNumber(e._parsed[t].r,i.options.locale);return{label:s[t]||"",value:n}}parseObjectData(t,e,i,s){return _parseObjectDataRadialScale.bind(this)(t,e,i,s)}update(t){const e=this._cachedMeta.data;this._updateRadius(),this.updateElements(e,0,e.length,t)}getMinMax(){const t=this._cachedMeta,e={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY};return t.data.forEach(((t,i)=>{const s=this.getParsed(i).r;!isNaN(s)&&this.chart.getDataVisibility(i)&&(s<e.min&&(e.min=s),s>e.max&&(e.max=s))})),e}_updateRadius(){const t=this.chart,e=t.chartArea,i=t.options,s=Math.min(e.right-e.left,e.bottom-e.top),n=Math.max(s/2,0),o=(n-Math.max(i.cutoutPercentage?n/100*i.cutoutPercentage:1,0))/t.getVisibleDatasetCount();this.outerRadius=n-o*this.index,this.innerRadius=this.outerRadius-o}updateElements(t,e,i,s){const n="reset"===s,o=this.chart,a=o.options.animation,r=this._cachedMeta.rScale,l=r.xCenter,h=r.yCenter,c=r.getIndexAngle(0)-.5*PI;let d,u=c;const g=360/this.countVisibleElements();for(d=0;d<e;++d)u+=this._computeAngle(d,s,g);for(d=e;d<e+i;d++){const e=t[d];let i=u,f=u+this._computeAngle(d,s,g),p=o.getDataVisibility(d)?r.getDistanceFromCenterForValue(this.getParsed(d).r):0;u=f,n&&(a.animateScale&&(p=0),a.animateRotate&&(i=f=c));const m={x:l,y:h,innerRadius:0,outerRadius:p,startAngle:i,endAngle:f,options:this.resolveDataElementOptions(d,e.active?"active":s)};this.updateElement(e,d,m,s)}}countVisibleElements(){const t=this._cachedMeta;let e=0;return t.data.forEach(((t,i)=>{!isNaN(this.getParsed(i).r)&&this.chart.getDataVisibility(i)&&e++})),e}_computeAngle(t,e,i){return this.chart.getDataVisibility(t)?toRadians(this.resolveDataElementOptions(t,e).angle||i):0}}class PieController extends DoughnutController{static id="pie";static defaults={cutout:0,rotation:0,circumference:360,radius:"100%"}}class RadarController extends DatasetController{static id="radar";static defaults={datasetElementType:"line",dataElementType:"point",indexAxis:"r",showLine:!0,elements:{line:{fill:"start"}}};static overrides={aspectRatio:1,scales:{r:{type:"radialLinear"}}};getLabelAndValue(t){const e=this._cachedMeta.vScale,i=this.getParsed(t);return{label:e.getLabels()[t],value:""+e.getLabelForValue(i[e.axis])}}parseObjectData(t,e,i,s){return _parseObjectDataRadialScale.bind(this)(t,e,i,s)}update(t){const e=this._cachedMeta,i=e.dataset,s=e.data||[],n=e.iScale.getLabels();if(i.points=s,"resize"!==t){const e=this.resolveDatasetElementOptions(t);this.options.showLine||(e.borderWidth=0);const o={_loop:!0,_fullLoop:n.length===s.length,options:e};this.updateElement(i,void 0,o,t)}this.updateElements(s,0,s.length,t)}updateElements(t,e,i,s){const n=this._cachedMeta.rScale,o="reset"===s;for(let a=e;a<e+i;a++){const e=t[a],i=this.resolveDataElementOptions(a,e.active?"active":s),r=n.getPointPositionForValue(a,this.getParsed(a).r),l=o?n.xCenter:r.x,h=o?n.yCenter:r.y,c={x:l,y:h,angle:r.angle,skip:isNaN(l)||isNaN(h),options:i};this.updateElement(e,a,c,s)}}}class ScatterController extends DatasetController{static id="scatter";static defaults={datasetElementType:!1,dataElementType:"point",showLine:!1,fill:!1};static overrides={interaction:{mode:"point"},scales:{x:{type:"linear"},y:{type:"linear"}}};getLabelAndValue(t){const e=this._cachedMeta,i=this.chart.data.labels||[],{xScale:s,yScale:n}=e,o=this.getParsed(t),a=s.getLabelForValue(o.x),r=n.getLabelForValue(o.y);return{label:i[t]||"",value:"("+a+", "+r+")"}}update(t){const e=this._cachedMeta,{data:i=[]}=e,s=this.chart._animationsDisabled;let{start:n,count:o}=_getStartAndCountOfVisiblePoints(e,i,s);if(this._drawStart=n,this._drawCount=o,_scaleRangesChanged(e)&&(n=0,o=i.length),this.options.showLine){this.datasetElementType||this.addElements();const{dataset:n,_dataset:o}=e;n._chart=this.chart,n._datasetIndex=this.index,n._decimated=!!o._decimated,n.points=i;const a=this.resolveDatasetElementOptions(t);a.segment=this.options.segment,this.updateElement(n,void 0,{animated:!s,options:a},t)}else this.datasetElementType&&(delete e.dataset,this.datasetElementType=!1);this.updateElements(i,n,o,t)}addElements(){const{showLine:t}=this.options;!this.datasetElementType&&t&&(this.datasetElementType=this.chart.registry.getElement("line")),super.addElements()}updateElements(t,e,i,s){const n="reset"===s,{iScale:o,vScale:a,_stacked:r,_dataset:l}=this._cachedMeta,h=this.resolveDataElementOptions(e,s),c=this.getSharedOptions(h),d=this.includeOptions(s,c),u=o.axis,g=a.axis,{spanGaps:f,segment:p}=this.options,m=isNumber(f)?f:Number.POSITIVE_INFINITY,b=this.chart._animationsDisabled||n||"none"===s;let x=e>0&&this.getParsed(e-1);for(let h=e;h<e+i;++h){const e=t[h],i=this.getParsed(h),f=b?e:{},_=isNullOrUndef(i[g]),y=f[u]=o.getPixelForValue(i[u],h),v=f[g]=n||_?a.getBasePixel():a.getPixelForValue(r?this.applyStack(a,i,r):i[g],h);f.skip=isNaN(y)||isNaN(v)||_,f.stop=h>0&&Math.abs(i[u]-x[u])>m,p&&(f.parsed=i,f.raw=l.data[h]),d&&(f.options=c||this.resolveDataElementOptions(h,e.active?"active":s)),b||this.updateElement(e,h,f,s),x=i}this.updateSharedOptions(c,s,h)}getMaxOverflow(){const t=this._cachedMeta,e=t.data||[];if(!this.options.showLine){let t=0;for(let i=e.length-1;i>=0;--i)t=Math.max(t,e[i].size(this.resolveDataElementOptions(i))/2);return t>0&&t}const i=t.dataset,s=i.options&&i.options.borderWidth||0;if(!e.length)return s;const n=e[0].size(this.resolveDataElementOptions(0)),o=e[e.length-1].size(this.resolveDataElementOptions(e.length-1));return Math.max(s,n,o)/2}}var controllers=Object.freeze({__proto__:null,BarController,BubbleController,DoughnutController,LineController,PieController,PolarAreaController,RadarController,ScatterController});function abstract(){throw new Error("This method is not implemented: Check that a complete date adapter is provided.")}class DateAdapterBase{static override(t){Object.assign(DateAdapterBase.prototype,t)}options;constructor(t){this.options=t||{}}init(){}formats(){return abstract()}parse(){return abstract()}format(){return abstract()}add(){return abstract()}diff(){return abstract()}startOf(){return abstract()}endOf(){return abstract()}}var adapters={_date:DateAdapterBase};function binarySearch(t,e,i,s){const{controller:n,data:o,_sorted:a}=t,r=n._cachedMeta.iScale;if(r&&e===r.axis&&"r"!==e&&a&&o.length){const t=r._reversePixels?_rlookupByKey:_lookupByKey;if(!s)return t(o,e,i);if(n._sharedOptions){const s=o[0],n="function"==typeof s.getRange&&s.getRange(e);if(n){const s=t(o,e,i-n),a=t(o,e,i+n);return{lo:s.lo,hi:a.hi}}}}return{lo:0,hi:o.length-1}}function evaluateInteractionItems(t,e,i,s,n){const o=t.getSortedVisibleDatasetMetas(),a=i[e];for(let t=0,i=o.length;t<i;++t){const{index:i,data:r}=o[t],{lo:l,hi:h}=binarySearch(o[t],e,a,n);for(let t=l;t<=h;++t){const e=r[t];e.skip||s(e,i,t)}}}function getDistanceMetricForAxis(t){const e=-1!==t.indexOf("x"),i=-1!==t.indexOf("y");return function(t,s){const n=e?Math.abs(t.x-s.x):0,o=i?Math.abs(t.y-s.y):0;return Math.sqrt(Math.pow(n,2)+Math.pow(o,2))}}function getIntersectItems(t,e,i,s,n){const o=[];if(!n&&!t.isPointInArea(e))return o;return evaluateInteractionItems(t,i,e,(function(i,a,r){(n||_isPointInArea(i,t.chartArea,0))&&i.inRange(e.x,e.y,s)&&o.push({element:i,datasetIndex:a,index:r})}),!0),o}function getNearestRadialItems(t,e,i,s){let n=[];return evaluateInteractionItems(t,i,e,(function(t,i,o){const{startAngle:a,endAngle:r}=t.getProps(["startAngle","endAngle"],s),{angle:l}=getAngleFromPoint(t,{x:e.x,y:e.y});_angleBetween(l,a,r)&&n.push({element:t,datasetIndex:i,index:o})})),n}function getNearestCartesianItems(t,e,i,s,n,o){let a=[];const r=getDistanceMetricForAxis(i);let l=Number.POSITIVE_INFINITY;return evaluateInteractionItems(t,i,e,(function(i,h,c){const d=i.inRange(e.x,e.y,n);if(s&&!d)return;const u=i.getCenterPoint(n);if(!(!!o||t.isPointInArea(u))&&!d)return;const g=r(e,u);g<l?(a=[{element:i,datasetIndex:h,index:c}],l=g):g===l&&a.push({element:i,datasetIndex:h,index:c})})),a}function getNearestItems(t,e,i,s,n,o){return o||t.isPointInArea(e)?"r"!==i||s?getNearestCartesianItems(t,e,i,s,n,o):getNearestRadialItems(t,e,i,n):[]}function getAxisItems(t,e,i,s,n){const o=[],a="x"===i?"inXRange":"inYRange";let r=!1;return evaluateInteractionItems(t,i,e,((t,s,l)=>{t[a](e[i],n)&&(o.push({element:t,datasetIndex:s,index:l}),r=r||t.inRange(e.x,e.y,n))})),s&&!r?[]:o}var Interaction={evaluateInteractionItems,modes:{index(t,e,i,s){const n=getRelativePosition(e,t),o=i.axis||"x",a=i.includeInvisible||!1,r=i.intersect?getIntersectItems(t,n,o,s,a):getNearestItems(t,n,o,!1,s,a),l=[];return r.length?(t.getSortedVisibleDatasetMetas().forEach((t=>{const e=r[0].index,i=t.data[e];i&&!i.skip&&l.push({element:i,datasetIndex:t.index,index:e})})),l):[]},dataset(t,e,i,s){const n=getRelativePosition(e,t),o=i.axis||"xy",a=i.includeInvisible||!1;let r=i.intersect?getIntersectItems(t,n,o,s,a):getNearestItems(t,n,o,!1,s,a);if(r.length>0){const e=r[0].datasetIndex,i=t.getDatasetMeta(e).data;r=[];for(let t=0;t<i.length;++t)r.push({element:i[t],datasetIndex:e,index:t})}return r},point:(t,e,i,s)=>getIntersectItems(t,getRelativePosition(e,t),i.axis||"xy",s,i.includeInvisible||!1),nearest(t,e,i,s){const n=getRelativePosition(e,t),o=i.axis||"xy",a=i.includeInvisible||!1;return getNearestItems(t,n,o,i.intersect,s,a)},x:(t,e,i,s)=>getAxisItems(t,getRelativePosition(e,t),"x",i.intersect,s),y:(t,e,i,s)=>getAxisItems(t,getRelativePosition(e,t),"y",i.intersect,s)}};const STATIC_POSITIONS=["left","top","right","bottom"];function filterByPosition(t,e){return t.filter((t=>t.pos===e))}function filterDynamicPositionByAxis(t,e){return t.filter((t=>-1===STATIC_POSITIONS.indexOf(t.pos)&&t.box.axis===e))}function sortByWeight(t,e){return t.sort(((t,i)=>{const s=e?i:t,n=e?t:i;return s.weight===n.weight?s.index-n.index:s.weight-n.weight}))}function wrapBoxes(t){const e=[];let i,s,n,o,a,r;for(i=0,s=(t||[]).length;i<s;++i)n=t[i],({position:o,options:{stack:a,stackWeight:r=1}}=n),e.push({index:i,box:n,pos:o,horizontal:n.isHorizontal(),weight:n.weight,stack:a&&o+a,stackWeight:r});return e}function buildStacks(t){const e={};for(const i of t){const{stack:t,pos:s,stackWeight:n}=i;if(!t||!STATIC_POSITIONS.includes(s))continue;const o=e[t]||(e[t]={count:0,placed:0,weight:0,size:0});o.count++,o.weight+=n}return e}function setLayoutDims(t,e){const i=buildStacks(t),{vBoxMaxWidth:s,hBoxMaxHeight:n}=e;let o,a,r;for(o=0,a=t.length;o<a;++o){r=t[o];const{fullSize:a}=r.box,l=i[r.stack],h=l&&r.stackWeight/l.weight;r.horizontal?(r.width=h?h*s:a&&e.availableWidth,r.height=n):(r.width=s,r.height=h?h*n:a&&e.availableHeight)}return i}function buildLayoutBoxes(t){const e=wrapBoxes(t),i=sortByWeight(e.filter((t=>t.box.fullSize)),!0),s=sortByWeight(filterByPosition(e,"left"),!0),n=sortByWeight(filterByPosition(e,"right")),o=sortByWeight(filterByPosition(e,"top"),!0),a=sortByWeight(filterByPosition(e,"bottom")),r=filterDynamicPositionByAxis(e,"x"),l=filterDynamicPositionByAxis(e,"y");return{fullSize:i,leftAndTop:s.concat(o),rightAndBottom:n.concat(l).concat(a).concat(r),chartArea:filterByPosition(e,"chartArea"),vertical:s.concat(n).concat(l),horizontal:o.concat(a).concat(r)}}function getCombinedMax(t,e,i,s){return Math.max(t[i],e[i])+Math.max(t[s],e[s])}function updateMaxPadding(t,e){t.top=Math.max(t.top,e.top),t.left=Math.max(t.left,e.left),t.bottom=Math.max(t.bottom,e.bottom),t.right=Math.max(t.right,e.right)}function updateDims(t,e,i,s){const{pos:n,box:o}=i,a=t.maxPadding;if(!isObject(n)){i.size&&(t[n]-=i.size);const e=s[i.stack]||{size:0,count:1};e.size=Math.max(e.size,i.horizontal?o.height:o.width),i.size=e.size/e.count,t[n]+=i.size}o.getPadding&&updateMaxPadding(a,o.getPadding());const r=Math.max(0,e.outerWidth-getCombinedMax(a,t,"left","right")),l=Math.max(0,e.outerHeight-getCombinedMax(a,t,"top","bottom")),h=r!==t.w,c=l!==t.h;return t.w=r,t.h=l,i.horizontal?{same:h,other:c}:{same:c,other:h}}function handleMaxPadding(t){const e=t.maxPadding;function i(i){const s=Math.max(e[i]-t[i],0);return t[i]+=s,s}t.y+=i("top"),t.x+=i("left"),i("right"),i("bottom")}function getMargins(t,e){const i=e.maxPadding;function s(t){const s={left:0,top:0,right:0,bottom:0};return t.forEach((t=>{s[t]=Math.max(e[t],i[t])})),s}return s(t?["left","right"]:["top","bottom"])}function fitBoxes(t,e,i,s){const n=[];let o,a,r,l,h,c;for(o=0,a=t.length,h=0;o<a;++o){r=t[o],l=r.box,l.update(r.width||e.w,r.height||e.h,getMargins(r.horizontal,e));const{same:a,other:d}=updateDims(e,i,r,s);h|=a&&n.length,c=c||d,l.fullSize||n.push(r)}return h&&fitBoxes(n,e,i,s)||c}function setBoxDims(t,e,i,s,n){t.top=i,t.left=e,t.right=e+s,t.bottom=i+n,t.width=s,t.height=n}function placeBoxes(t,e,i,s){const n=i.padding;let{x:o,y:a}=e;for(const r of t){const t=r.box,l=s[r.stack]||{count:1,placed:0,weight:1},h=r.stackWeight/l.weight||1;if(r.horizontal){const s=e.w*h,o=l.size||t.height;defined(l.start)&&(a=l.start),t.fullSize?setBoxDims(t,n.left,a,i.outerWidth-n.right-n.left,o):setBoxDims(t,e.left+l.placed,a,s,o),l.start=a,l.placed+=s,a=t.bottom}else{const s=e.h*h,a=l.size||t.width;defined(l.start)&&(o=l.start),t.fullSize?setBoxDims(t,o,n.top,a,i.outerHeight-n.bottom-n.top):setBoxDims(t,o,e.top+l.placed,a,s),l.start=o,l.placed+=s,o=t.right}}e.x=o,e.y=a}var layouts={addBox(t,e){t.boxes||(t.boxes=[]),e.fullSize=e.fullSize||!1,e.position=e.position||"top",e.weight=e.weight||0,e._layers=e._layers||function(){return[{z:0,draw(t){e.draw(t)}}]},t.boxes.push(e)},removeBox(t,e){const i=t.boxes?t.boxes.indexOf(e):-1;-1!==i&&t.boxes.splice(i,1)},configure(t,e,i){e.fullSize=i.fullSize,e.position=i.position,e.weight=i.weight},update(t,e,i,s){if(!t)return;const n=toPadding(t.options.layout.padding),o=Math.max(e-n.width,0),a=Math.max(i-n.height,0),r=buildLayoutBoxes(t.boxes),l=r.vertical,h=r.horizontal;each(t.boxes,(t=>{"function"==typeof t.beforeLayout&&t.beforeLayout()}));const c=l.reduce(((t,e)=>e.box.options&&!1===e.box.options.display?t:t+1),0)||1,d=Object.freeze({outerWidth:e,outerHeight:i,padding:n,availableWidth:o,availableHeight:a,vBoxMaxWidth:o/2/c,hBoxMaxHeight:a/2}),u=Object.assign({},n);updateMaxPadding(u,toPadding(s));const g=Object.assign({maxPadding:u,w:o,h:a,x:n.left,y:n.top},n),f=setLayoutDims(l.concat(h),d);fitBoxes(r.fullSize,g,d,f),fitBoxes(l,g,d,f),fitBoxes(h,g,d,f)&&fitBoxes(l,g,d,f),handleMaxPadding(g),placeBoxes(r.leftAndTop,g,d,f),g.x+=g.w,g.y+=g.h,placeBoxes(r.rightAndBottom,g,d,f),t.chartArea={left:g.left,top:g.top,right:g.left+g.w,bottom:g.top+g.h,height:g.h,width:g.w},each(r.chartArea,(e=>{const i=e.box;Object.assign(i,t.chartArea),i.update(g.w,g.h,{left:0,top:0,right:0,bottom:0})}))}};class BasePlatform{acquireContext(t,e){}releaseContext(t){return!1}addEventListener(t,e,i){}removeEventListener(t,e,i){}getDevicePixelRatio(){return 1}getMaximumSize(t,e,i,s){return e=Math.max(0,e||t.width),i=i||t.height,{width:e,height:Math.max(0,s?Math.floor(e/s):i)}}isAttached(t){return!0}updateConfig(t){}}class BasicPlatform extends BasePlatform{acquireContext(t){return t&&t.getContext&&t.getContext("2d")||null}updateConfig(t){t.options.animation=!1}}const EXPANDO_KEY="$chartjs",EVENT_TYPES={touchstart:"mousedown",touchmove:"mousemove",touchend:"mouseup",pointerenter:"mouseenter",pointerdown:"mousedown",pointermove:"mousemove",pointerup:"mouseup",pointerleave:"mouseout",pointerout:"mouseout"},isNullOrEmpty=t=>null===t||""===t;function initCanvas(t,e){const i=t.style,s=t.getAttribute("height"),n=t.getAttribute("width");if(t.$chartjs={initial:{height:s,width:n,style:{display:i.display,height:i.height,width:i.width}}},i.display=i.display||"block",i.boxSizing=i.boxSizing||"border-box",isNullOrEmpty(n)){const e=readUsedSize(t,"width");void 0!==e&&(t.width=e)}if(isNullOrEmpty(s))if(""===t.style.height)t.height=t.width/(e||2);else{const e=readUsedSize(t,"height");void 0!==e&&(t.height=e)}return t}const eventListenerOptions=!!supportsEventListenerOptions&&{passive:!0};function addListener(t,e,i){t.addEventListener(e,i,eventListenerOptions)}function removeListener(t,e,i){t.canvas.removeEventListener(e,i,eventListenerOptions)}function fromNativeEvent(t,e){const i=EVENT_TYPES[t.type]||t.type,{x:s,y:n}=getRelativePosition(t,e);return{type:i,chart:e,native:t,x:void 0!==s?s:null,y:void 0!==n?n:null}}function nodeListContains(t,e){for(const i of t)if(i===e||i.contains(e))return!0}function createAttachObserver(t,e,i){const s=t.canvas,n=new MutationObserver((t=>{let e=!1;for(const i of t)e=e||nodeListContains(i.addedNodes,s),e=e&&!nodeListContains(i.removedNodes,s);e&&i()}));return n.observe(document,{childList:!0,subtree:!0}),n}function createDetachObserver(t,e,i){const s=t.canvas,n=new MutationObserver((t=>{let e=!1;for(const i of t)e=e||nodeListContains(i.removedNodes,s),e=e&&!nodeListContains(i.addedNodes,s);e&&i()}));return n.observe(document,{childList:!0,subtree:!0}),n}const drpListeningCharts=new Map;let oldDevicePixelRatio=0;function onWindowResize(){const t=window.devicePixelRatio;t!==oldDevicePixelRatio&&(oldDevicePixelRatio=t,drpListeningCharts.forEach(((e,i)=>{i.currentDevicePixelRatio!==t&&e()})))}function listenDevicePixelRatioChanges(t,e){drpListeningCharts.size||window.addEventListener("resize",onWindowResize),drpListeningCharts.set(t,e)}function unlistenDevicePixelRatioChanges(t){drpListeningCharts.delete(t),drpListeningCharts.size||window.removeEventListener("resize",onWindowResize)}function createResizeObserver(t,e,i){const s=t.canvas,n=s&&_getParentNode(s);if(!n)return;const o=throttled(((t,e)=>{const s=n.clientWidth;i(t,e),s<n.clientWidth&&i()}),window),a=new ResizeObserver((t=>{const e=t[0],i=e.contentRect.width,s=e.contentRect.height;0===i&&0===s||o(i,s)}));return a.observe(n),listenDevicePixelRatioChanges(t,o),a}function releaseObserver(t,e,i){i&&i.disconnect(),"resize"===e&&unlistenDevicePixelRatioChanges(t)}function createProxyAndListen(t,e,i){const s=t.canvas,n=throttled((e=>{null!==t.ctx&&i(fromNativeEvent(e,t))}),t);return addListener(s,e,n),n}class DomPlatform extends BasePlatform{acquireContext(t,e){const i=t&&t.getContext&&t.getContext("2d");return i&&i.canvas===t?(initCanvas(t,e),i):null}releaseContext(t){const e=t.canvas;if(!e.$chartjs)return!1;const i=e.$chartjs.initial;["height","width"].forEach((t=>{const s=i[t];isNullOrUndef(s)?e.removeAttribute(t):e.setAttribute(t,s)}));const s=i.style||{};return Object.keys(s).forEach((t=>{e.style[t]=s[t]})),e.width=e.width,delete e.$chartjs,!0}addEventListener(t,e,i){this.removeEventListener(t,e);const s=t.$proxies||(t.$proxies={}),n={attach:createAttachObserver,detach:createDetachObserver,resize:createResizeObserver}[e]||createProxyAndListen;s[e]=n(t,e,i)}removeEventListener(t,e){const i=t.$proxies||(t.$proxies={}),s=i[e];if(!s)return;({attach:releaseObserver,detach:releaseObserver,resize:releaseObserver}[e]||removeListener)(t,e,s),i[e]=void 0}getDevicePixelRatio(){return window.devicePixelRatio}getMaximumSize(t,e,i,s){return getMaximumSize(t,e,i,s)}isAttached(t){const e=_getParentNode(t);return!(!e||!e.isConnected)}}function _detectPlatform(t){return!_isDomSupported()||"undefined"!=typeof OffscreenCanvas&&t instanceof OffscreenCanvas?BasicPlatform:DomPlatform}class Element{static defaults={};static defaultRoutes=void 0;x;y;active=!1;options;$animations;tooltipPosition(t){const{x:e,y:i}=this.getProps(["x","y"],t);return{x:e,y:i}}hasValue(){return isNumber(this.x)&&isNumber(this.y)}getProps(t,e){const i=this.$animations;if(!e||!i)return this;const s={};return t.forEach((t=>{s[t]=i[t]&&i[t].active()?i[t]._to:this[t]})),s}}function autoSkip(t,e){const i=t.options.ticks,s=determineMaxTicks(t),n=Math.min(i.maxTicksLimit||s,s),o=i.major.enabled?getMajorIndices(e):[],a=o.length,r=o[0],l=o[a-1],h=[];if(a>n)return skipMajors(e,h,o,a/n),h;const c=calculateSpacing(o,e,n);if(a>0){let t,i;const s=a>1?Math.round((l-r)/(a-1)):null;for(skip(e,h,c,isNullOrUndef(s)?0:r-s,r),t=0,i=a-1;t<i;t++)skip(e,h,c,o[t],o[t+1]);return skip(e,h,c,l,isNullOrUndef(s)?e.length:l+s),h}return skip(e,h,c),h}function determineMaxTicks(t){const e=t.options.offset,i=t._tickSize(),s=t._length/i+(e?0:1),n=t._maxLength/i;return Math.floor(Math.min(s,n))}function calculateSpacing(t,e,i){const s=getEvenSpacing(t),n=e.length/i;if(!s)return Math.max(n,1);const o=_factorize(s);for(let t=0,e=o.length-1;t<e;t++){const e=o[t];if(e>n)return e}return Math.max(n,1)}function getMajorIndices(t){const e=[];let i,s;for(i=0,s=t.length;i<s;i++)t[i].major&&e.push(i);return e}function skipMajors(t,e,i,s){let n,o=0,a=i[0];for(s=Math.ceil(s),n=0;n<t.length;n++)n===a&&(e.push(t[n]),o++,a=i[o*s])}function skip(t,e,i,s,n){const o=valueOrDefault(s,0),a=Math.min(valueOrDefault(n,t.length),t.length);let r,l,h,c=0;for(i=Math.ceil(i),n&&(r=n-s,i=r/Math.floor(r/i)),h=o;h<0;)c++,h=Math.round(o+c*i);for(l=Math.max(o,0);l<a;l++)l===h&&(e.push(t[l]),c++,h=Math.round(o+c*i))}function getEvenSpacing(t){const e=t.length;let i,s;if(e<2)return!1;for(s=t[0],i=1;i<e;++i)if(t[i]-t[i-1]!==s)return!1;return s}const reverseAlign=t=>"left"===t?"right":"right"===t?"left":t,offsetFromEdge=(t,e,i)=>"top"===e||"left"===e?t[e]+i:t[e]-i,getTicksLimit=(t,e)=>Math.min(e||t,t);function sample(t,e){const i=[],s=t.length/e,n=t.length;let o=0;for(;o<n;o+=s)i.push(t[Math.floor(o)]);return i}function getPixelForGridLine(t,e,i){const s=t.ticks.length,n=Math.min(e,s-1),o=t._startPixel,a=t._endPixel,r=1e-6;let l,h=t.getPixelForTick(n);if(!(i&&(l=1===s?Math.max(h-o,a-h):0===e?(t.getPixelForTick(1)-h)/2:(h-t.getPixelForTick(n-1))/2,h+=n<e?l:-l,h<o-r||h>a+r)))return h}function garbageCollect(t,e){each(t,(t=>{const i=t.gc,s=i.length/2;let n;if(s>e){for(n=0;n<s;++n)delete t.data[i[n]];i.splice(0,s)}}))}function getTickMarkLength(t){return t.drawTicks?t.tickLength:0}function getTitleHeight(t,e){if(!t.display)return 0;const i=toFont(t.font,e),s=toPadding(t.padding);return(isArray(t.text)?t.text.length:1)*i.lineHeight+s.height}function createScaleContext(t,e){return createContext(t,{scale:e,type:"scale"})}function createTickContext(t,e,i){return createContext(t,{tick:i,index:e,type:"tick"})}function titleAlign(t,e,i){let s=_toLeftRightCenter(t);return(i&&"right"!==e||!i&&"right"===e)&&(s=reverseAlign(s)),s}function titleArgs(t,e,i,s){const{top:n,left:o,bottom:a,right:r,chart:l}=t,{chartArea:h,scales:c}=l;let d,u,g,f=0;const p=a-n,m=r-o;if(t.isHorizontal()){if(u=_alignStartEnd(s,o,r),isObject(i)){const t=Object.keys(i)[0],s=i[t];g=c[t].getPixelForValue(s)+p-e}else g="center"===i?(h.bottom+h.top)/2+p-e:offsetFromEdge(t,i,e);d=r-o}else{if(isObject(i)){const t=Object.keys(i)[0],s=i[t];u=c[t].getPixelForValue(s)-m+e}else u="center"===i?(h.left+h.right)/2-m+e:offsetFromEdge(t,i,e);g=_alignStartEnd(s,a,n),f="left"===i?-HALF_PI:HALF_PI}return{titleX:u,titleY:g,maxWidth:d,rotation:f}}class Scale extends Element{constructor(t){super(),this.id=t.id,this.type=t.type,this.options=void 0,this.ctx=t.ctx,this.chart=t.chart,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.width=void 0,this.height=void 0,this._margins={left:0,right:0,top:0,bottom:0},this.maxWidth=void 0,this.maxHeight=void 0,this.paddingTop=void 0,this.paddingBottom=void 0,this.paddingLeft=void 0,this.paddingRight=void 0,this.axis=void 0,this.labelRotation=void 0,this.min=void 0,this.max=void 0,this._range=void 0,this.ticks=[],this._gridLineItems=null,this._labelItems=null,this._labelSizes=null,this._length=0,this._maxLength=0,this._longestTextCache={},this._startPixel=void 0,this._endPixel=void 0,this._reversePixels=!1,this._userMax=void 0,this._userMin=void 0,this._suggestedMax=void 0,this._suggestedMin=void 0,this._ticksLength=0,this._borderValue=0,this._cache={},this._dataLimitsCached=!1,this.$context=void 0}init(t){this.options=t.setContext(this.getContext()),this.axis=t.axis,this._userMin=this.parse(t.min),this._userMax=this.parse(t.max),this._suggestedMin=this.parse(t.suggestedMin),this._suggestedMax=this.parse(t.suggestedMax)}parse(t,e){return t}getUserBounds(){let{_userMin:t,_userMax:e,_suggestedMin:i,_suggestedMax:s}=this;return t=finiteOrDefault(t,Number.POSITIVE_INFINITY),e=finiteOrDefault(e,Number.NEGATIVE_INFINITY),i=finiteOrDefault(i,Number.POSITIVE_INFINITY),s=finiteOrDefault(s,Number.NEGATIVE_INFINITY),{min:finiteOrDefault(t,i),max:finiteOrDefault(e,s),minDefined:isNumberFinite(t),maxDefined:isNumberFinite(e)}}getMinMax(t){let e,{min:i,max:s,minDefined:n,maxDefined:o}=this.getUserBounds();if(n&&o)return{min:i,max:s};const a=this.getMatchingVisibleMetas();for(let r=0,l=a.length;r<l;++r)e=a[r].controller.getMinMax(this,t),n||(i=Math.min(i,e.min)),o||(s=Math.max(s,e.max));return i=o&&i>s?s:i,s=n&&i>s?i:s,{min:finiteOrDefault(i,finiteOrDefault(s,i)),max:finiteOrDefault(s,finiteOrDefault(i,s))}}getPadding(){return{left:this.paddingLeft||0,top:this.paddingTop||0,right:this.paddingRight||0,bottom:this.paddingBottom||0}}getTicks(){return this.ticks}getLabels(){const t=this.chart.data;return this.options.labels||(this.isHorizontal()?t.xLabels:t.yLabels)||t.labels||[]}getLabelItems(t=this.chart.chartArea){return this._labelItems||(this._labelItems=this._computeLabelItems(t))}beforeLayout(){this._cache={},this._dataLimitsCached=!1}beforeUpdate(){callback(this.options.beforeUpdate,[this])}update(t,e,i){const{beginAtZero:s,grace:n,ticks:o}=this.options,a=o.sampleSize;this.beforeUpdate(),this.maxWidth=t,this.maxHeight=e,this._margins=i=Object.assign({left:0,right:0,top:0,bottom:0},i),this.ticks=null,this._labelSizes=null,this._gridLineItems=null,this._labelItems=null,this.beforeSetDimensions(),this.setDimensions(),this.afterSetDimensions(),this._maxLength=this.isHorizontal()?this.width+i.left+i.right:this.height+i.top+i.bottom,this._dataLimitsCached||(this.beforeDataLimits(),this.determineDataLimits(),this.afterDataLimits(),this._range=_addGrace(this,n,s),this._dataLimitsCached=!0),this.beforeBuildTicks(),this.ticks=this.buildTicks()||[],this.afterBuildTicks();const r=a<this.ticks.length;this._convertTicksToLabels(r?sample(this.ticks,a):this.ticks),this.configure(),this.beforeCalculateLabelRotation(),this.calculateLabelRotation(),this.afterCalculateLabelRotation(),o.display&&(o.autoSkip||"auto"===o.source)&&(this.ticks=autoSkip(this,this.ticks),this._labelSizes=null,this.afterAutoSkip()),r&&this._convertTicksToLabels(this.ticks),this.beforeFit(),this.fit(),this.afterFit(),this.afterUpdate()}configure(){let t,e,i=this.options.reverse;this.isHorizontal()?(t=this.left,e=this.right):(t=this.top,e=this.bottom,i=!i),this._startPixel=t,this._endPixel=e,this._reversePixels=i,this._length=e-t,this._alignToPixels=this.options.alignToPixels}afterUpdate(){callback(this.options.afterUpdate,[this])}beforeSetDimensions(){callback(this.options.beforeSetDimensions,[this])}setDimensions(){this.isHorizontal()?(this.width=this.maxWidth,this.left=0,this.right=this.width):(this.height=this.maxHeight,this.top=0,this.bottom=this.height),this.paddingLeft=0,this.paddingTop=0,this.paddingRight=0,this.paddingBottom=0}afterSetDimensions(){callback(this.options.afterSetDimensions,[this])}_callHooks(t){this.chart.notifyPlugins(t,this.getContext()),callback(this.options[t],[this])}beforeDataLimits(){this._callHooks("beforeDataLimits")}determineDataLimits(){}afterDataLimits(){this._callHooks("afterDataLimits")}beforeBuildTicks(){this._callHooks("beforeBuildTicks")}buildTicks(){return[]}afterBuildTicks(){this._callHooks("afterBuildTicks")}beforeTickToLabelConversion(){callback(this.options.beforeTickToLabelConversion,[this])}generateTickLabels(t){const e=this.options.ticks;let i,s,n;for(i=0,s=t.length;i<s;i++)n=t[i],n.label=callback(e.callback,[n.value,i,t],this)}afterTickToLabelConversion(){callback(this.options.afterTickToLabelConversion,[this])}beforeCalculateLabelRotation(){callback(this.options.beforeCalculateLabelRotation,[this])}calculateLabelRotation(){const t=this.options,e=t.ticks,i=getTicksLimit(this.ticks.length,t.ticks.maxTicksLimit),s=e.minRotation||0,n=e.maxRotation;let o,a,r,l=s;if(!this._isVisible()||!e.display||s>=n||i<=1||!this.isHorizontal())return void(this.labelRotation=s);const h=this._getLabelSizes(),c=h.widest.width,d=h.highest.height,u=_limitValue(this.chart.width-c,0,this.maxWidth);o=t.offset?this.maxWidth/i:u/(i-1),c+6>o&&(o=u/(i-(t.offset?.5:1)),a=this.maxHeight-getTickMarkLength(t.grid)-e.padding-getTitleHeight(t.title,this.chart.options.font),r=Math.sqrt(c*c+d*d),l=toDegrees(Math.min(Math.asin(_limitValue((h.highest.height+6)/o,-1,1)),Math.asin(_limitValue(a/r,-1,1))-Math.asin(_limitValue(d/r,-1,1)))),l=Math.max(s,Math.min(n,l))),this.labelRotation=l}afterCalculateLabelRotation(){callback(this.options.afterCalculateLabelRotation,[this])}afterAutoSkip(){}beforeFit(){callback(this.options.beforeFit,[this])}fit(){const t={width:0,height:0},{chart:e,options:{ticks:i,title:s,grid:n}}=this,o=this._isVisible(),a=this.isHorizontal();if(o){const o=getTitleHeight(s,e.options.font);if(a?(t.width=this.maxWidth,t.height=getTickMarkLength(n)+o):(t.height=this.maxHeight,t.width=getTickMarkLength(n)+o),i.display&&this.ticks.length){const{first:e,last:s,widest:n,highest:o}=this._getLabelSizes(),r=2*i.padding,l=toRadians(this.labelRotation),h=Math.cos(l),c=Math.sin(l);if(a){const e=i.mirror?0:c*n.width+h*o.height;t.height=Math.min(this.maxHeight,t.height+e+r)}else{const e=i.mirror?0:h*n.width+c*o.height;t.width=Math.min(this.maxWidth,t.width+e+r)}this._calculatePadding(e,s,c,h)}}this._handleMargins(),a?(this.width=this._length=e.width-this._margins.left-this._margins.right,this.height=t.height):(this.width=t.width,this.height=this._length=e.height-this._margins.top-this._margins.bottom)}_calculatePadding(t,e,i,s){const{ticks:{align:n,padding:o},position:a}=this.options,r=0!==this.labelRotation,l="top"!==a&&"x"===this.axis;if(this.isHorizontal()){const a=this.getPixelForTick(0)-this.left,h=this.right-this.getPixelForTick(this.ticks.length-1);let c=0,d=0;r?l?(c=s*t.width,d=i*e.height):(c=i*t.height,d=s*e.width):"start"===n?d=e.width:"end"===n?c=t.width:"inner"!==n&&(c=t.width/2,d=e.width/2),this.paddingLeft=Math.max((c-a+o)*this.width/(this.width-a),0),this.paddingRight=Math.max((d-h+o)*this.width/(this.width-h),0)}else{let i=e.height/2,s=t.height/2;"start"===n?(i=0,s=t.height):"end"===n&&(i=e.height,s=0),this.paddingTop=i+o,this.paddingBottom=s+o}}_handleMargins(){this._margins&&(this._margins.left=Math.max(this.paddingLeft,this._margins.left),this._margins.top=Math.max(this.paddingTop,this._margins.top),this._margins.right=Math.max(this.paddingRight,this._margins.right),this._margins.bottom=Math.max(this.paddingBottom,this._margins.bottom))}afterFit(){callback(this.options.afterFit,[this])}isHorizontal(){const{axis:t,position:e}=this.options;return"top"===e||"bottom"===e||"x"===t}isFullSize(){return this.options.fullSize}_convertTicksToLabels(t){let e,i;for(this.beforeTickToLabelConversion(),this.generateTickLabels(t),e=0,i=t.length;e<i;e++)isNullOrUndef(t[e].label)&&(t.splice(e,1),i--,e--);this.afterTickToLabelConversion()}_getLabelSizes(){let t=this._labelSizes;if(!t){const e=this.options.ticks.sampleSize;let i=this.ticks;e<i.length&&(i=sample(i,e)),this._labelSizes=t=this._computeLabelSizes(i,i.length,this.options.ticks.maxTicksLimit)}return t}_computeLabelSizes(t,e,i){const{ctx:s,_longestTextCache:n}=this,o=[],a=[],r=Math.floor(e/getTicksLimit(e,i));let l,h,c,d,u,g,f,p,m,b,x,_=0,y=0;for(l=0;l<e;l+=r){if(d=t[l].label,u=this._resolveTickFontOptions(l),s.font=g=u.string,f=n[g]=n[g]||{data:{},gc:[]},p=u.lineHeight,m=b=0,isNullOrUndef(d)||isArray(d)){if(isArray(d))for(h=0,c=d.length;h<c;++h)x=d[h],isNullOrUndef(x)||isArray(x)||(m=_measureText(s,f.data,f.gc,m,x),b+=p)}else m=_measureText(s,f.data,f.gc,m,d),b=p;o.push(m),a.push(b),_=Math.max(m,_),y=Math.max(b,y)}garbageCollect(n,e);const v=o.indexOf(_),S=a.indexOf(y),k=t=>({width:o[t]||0,height:a[t]||0});return{first:k(0),last:k(e-1),widest:k(v),highest:k(S),widths:o,heights:a}}getLabelForValue(t){return t}getPixelForValue(t,e){return NaN}getValueForPixel(t){}getPixelForTick(t){const e=this.ticks;return t<0||t>e.length-1?null:this.getPixelForValue(e[t].value)}getPixelForDecimal(t){this._reversePixels&&(t=1-t);const e=this._startPixel+t*this._length;return _int16Range(this._alignToPixels?_alignPixel(this.chart,e,0):e)}getDecimalForPixel(t){const e=(t-this._startPixel)/this._length;return this._reversePixels?1-e:e}getBasePixel(){return this.getPixelForValue(this.getBaseValue())}getBaseValue(){const{min:t,max:e}=this;return t<0&&e<0?e:t>0&&e>0?t:0}getContext(t){const e=this.ticks||[];if(t>=0&&t<e.length){const i=e[t];return i.$context||(i.$context=createTickContext(this.getContext(),t,i))}return this.$context||(this.$context=createScaleContext(this.chart.getContext(),this))}_tickSize(){const t=this.options.ticks,e=toRadians(this.labelRotation),i=Math.abs(Math.cos(e)),s=Math.abs(Math.sin(e)),n=this._getLabelSizes(),o=t.autoSkipPadding||0,a=n?n.widest.width+o:0,r=n?n.highest.height+o:0;return this.isHorizontal()?r*i>a*s?a/i:r/s:r*s<a*i?r/i:a/s}_isVisible(){const t=this.options.display;return"auto"!==t?!!t:this.getMatchingVisibleMetas().length>0}_computeGridLineItems(t){const e=this.axis,i=this.chart,s=this.options,{grid:n,position:o,border:a}=s,r=n.offset,l=this.isHorizontal(),h=this.ticks.length+(r?1:0),c=getTickMarkLength(n),d=[],u=a.setContext(this.getContext()),g=u.display?u.width:0,f=g/2,p=function(t){return _alignPixel(i,t,g)};let m,b,x,_,y,v,S,k,P,M,w,A;if("top"===o)m=p(this.bottom),v=this.bottom-c,k=m-f,M=p(t.top)+f,A=t.bottom;else if("bottom"===o)m=p(this.top),M=t.top,A=p(t.bottom)-f,v=m+f,k=this.top+c;else if("left"===o)m=p(this.right),y=this.right-c,S=m-f,P=p(t.left)+f,w=t.right;else if("right"===o)m=p(this.left),P=t.left,w=p(t.right)-f,y=m+f,S=this.left+c;else if("x"===e){if("center"===o)m=p((t.top+t.bottom)/2+.5);else if(isObject(o)){const t=Object.keys(o)[0],e=o[t];m=p(this.chart.scales[t].getPixelForValue(e))}M=t.top,A=t.bottom,v=m+f,k=v+c}else if("y"===e){if("center"===o)m=p((t.left+t.right)/2);else if(isObject(o)){const t=Object.keys(o)[0],e=o[t];m=p(this.chart.scales[t].getPixelForValue(e))}y=m-f,S=y-c,P=t.left,w=t.right}const C=valueOrDefault(s.ticks.maxTicksLimit,h),O=Math.max(1,Math.ceil(h/C));for(b=0;b<h;b+=O){const t=this.getContext(b),e=n.setContext(t),s=a.setContext(t),o=e.lineWidth,h=e.color,c=s.dash||[],u=s.dashOffset,g=e.tickWidth,f=e.tickColor,p=e.tickBorderDash||[],m=e.tickBorderDashOffset;x=getPixelForGridLine(this,b,r),void 0!==x&&(_=_alignPixel(i,x,o),l?y=S=P=w=_:v=k=M=A=_,d.push({tx1:y,ty1:v,tx2:S,ty2:k,x1:P,y1:M,x2:w,y2:A,width:o,color:h,borderDash:c,borderDashOffset:u,tickWidth:g,tickColor:f,tickBorderDash:p,tickBorderDashOffset:m}))}return this._ticksLength=h,this._borderValue=m,d}_computeLabelItems(t){const e=this.axis,i=this.options,{position:s,ticks:n}=i,o=this.isHorizontal(),a=this.ticks,{align:r,crossAlign:l,padding:h,mirror:c}=n,d=getTickMarkLength(i.grid),u=d+h,g=c?-h:u,f=-toRadians(this.labelRotation),p=[];let m,b,x,_,y,v,S,k,P,M,w,A,C="middle";if("top"===s)v=this.bottom-g,S=this._getXAxisLabelAlignment();else if("bottom"===s)v=this.top+g,S=this._getXAxisLabelAlignment();else if("left"===s){const t=this._getYAxisLabelAlignment(d);S=t.textAlign,y=t.x}else if("right"===s){const t=this._getYAxisLabelAlignment(d);S=t.textAlign,y=t.x}else if("x"===e){if("center"===s)v=(t.top+t.bottom)/2+u;else if(isObject(s)){const t=Object.keys(s)[0],e=s[t];v=this.chart.scales[t].getPixelForValue(e)+u}S=this._getXAxisLabelAlignment()}else if("y"===e){if("center"===s)y=(t.left+t.right)/2-u;else if(isObject(s)){const t=Object.keys(s)[0],e=s[t];y=this.chart.scales[t].getPixelForValue(e)}S=this._getYAxisLabelAlignment(d).textAlign}"y"===e&&("start"===r?C="top":"end"===r&&(C="bottom"));const O=this._getLabelSizes();for(m=0,b=a.length;m<b;++m){x=a[m],_=x.label;const t=n.setContext(this.getContext(m));k=this.getPixelForTick(m)+n.labelOffset,P=this._resolveTickFontOptions(m),M=P.lineHeight,w=isArray(_)?_.length:1;const e=w/2,i=t.color,r=t.textStrokeColor,h=t.textStrokeWidth;let d,u=S;if(o?(y=k,"inner"===S&&(u=m===b-1?this.options.reverse?"left":"right":0===m?this.options.reverse?"right":"left":"center"),A="top"===s?"near"===l||0!==f?-w*M+M/2:"center"===l?-O.highest.height/2-e*M+M:-O.highest.height+M/2:"near"===l||0!==f?M/2:"center"===l?O.highest.height/2-e*M:O.highest.height-w*M,c&&(A*=-1),0===f||t.showLabelBackdrop||(y+=M/2*Math.sin(f))):(v=k,A=(1-w)*M/2),t.showLabelBackdrop){const e=toPadding(t.backdropPadding),i=O.heights[m],s=O.widths[m];let n=A-e.top,o=0-e.left;switch(C){case"middle":n-=i/2;break;case"bottom":n-=i}switch(S){case"center":o-=s/2;break;case"right":o-=s;break;case"inner":m===b-1?o-=s:m>0&&(o-=s/2)}d={left:o,top:n,width:s+e.width,height:i+e.height,color:t.backdropColor}}p.push({label:_,font:P,textOffset:A,options:{rotation:f,color:i,strokeColor:r,strokeWidth:h,textAlign:u,textBaseline:C,translation:[y,v],backdrop:d}})}return p}_getXAxisLabelAlignment(){const{position:t,ticks:e}=this.options;if(-toRadians(this.labelRotation))return"top"===t?"left":"right";let i="center";return"start"===e.align?i="left":"end"===e.align?i="right":"inner"===e.align&&(i="inner"),i}_getYAxisLabelAlignment(t){const{position:e,ticks:{crossAlign:i,mirror:s,padding:n}}=this.options,o=t+n,a=this._getLabelSizes().widest.width;let r,l;return"left"===e?s?(l=this.right+n,"near"===i?r="left":"center"===i?(r="center",l+=a/2):(r="right",l+=a)):(l=this.right-o,"near"===i?r="right":"center"===i?(r="center",l-=a/2):(r="left",l=this.left)):"right"===e?s?(l=this.left+n,"near"===i?r="right":"center"===i?(r="center",l-=a/2):(r="left",l-=a)):(l=this.left+o,"near"===i?r="left":"center"===i?(r="center",l+=a/2):(r="right",l=this.right)):r="right",{textAlign:r,x:l}}_computeLabelArea(){if(this.options.ticks.mirror)return;const t=this.chart,e=this.options.position;return"left"===e||"right"===e?{top:0,left:this.left,bottom:t.height,right:this.right}:"top"===e||"bottom"===e?{top:this.top,left:0,bottom:this.bottom,right:t.width}:void 0}drawBackground(){const{ctx:t,options:{backgroundColor:e},left:i,top:s,width:n,height:o}=this;e&&(t.save(),t.fillStyle=e,t.fillRect(i,s,n,o),t.restore())}getLineWidthForValue(t){const e=this.options.grid;if(!this._isVisible()||!e.display)return 0;const i=this.ticks.findIndex((e=>e.value===t));if(i>=0){return e.setContext(this.getContext(i)).lineWidth}return 0}drawGrid(t){const e=this.options.grid,i=this.ctx,s=this._gridLineItems||(this._gridLineItems=this._computeGridLineItems(t));let n,o;const a=(t,e,s)=>{s.width&&s.color&&(i.save(),i.lineWidth=s.width,i.strokeStyle=s.color,i.setLineDash(s.borderDash||[]),i.lineDashOffset=s.borderDashOffset,i.beginPath(),i.moveTo(t.x,t.y),i.lineTo(e.x,e.y),i.stroke(),i.restore())};if(e.display)for(n=0,o=s.length;n<o;++n){const t=s[n];e.drawOnChartArea&&a({x:t.x1,y:t.y1},{x:t.x2,y:t.y2},t),e.drawTicks&&a({x:t.tx1,y:t.ty1},{x:t.tx2,y:t.ty2},{color:t.tickColor,width:t.tickWidth,borderDash:t.tickBorderDash,borderDashOffset:t.tickBorderDashOffset})}}drawBorder(){const{chart:t,ctx:e,options:{border:i,grid:s}}=this,n=i.setContext(this.getContext()),o=i.display?n.width:0;if(!o)return;const a=s.setContext(this.getContext(0)).lineWidth,r=this._borderValue;let l,h,c,d;this.isHorizontal()?(l=_alignPixel(t,this.left,o)-o/2,h=_alignPixel(t,this.right,a)+a/2,c=d=r):(c=_alignPixel(t,this.top,o)-o/2,d=_alignPixel(t,this.bottom,a)+a/2,l=h=r),e.save(),e.lineWidth=n.width,e.strokeStyle=n.color,e.beginPath(),e.moveTo(l,c),e.lineTo(h,d),e.stroke(),e.restore()}drawLabels(t){if(!this.options.ticks.display)return;const e=this.ctx,i=this._computeLabelArea();i&&clipArea(e,i);const s=this.getLabelItems(t);for(const t of s){const i=t.options,s=t.font;renderText(e,t.label,0,t.textOffset,s,i)}i&&unclipArea(e)}drawTitle(){const{ctx:t,options:{position:e,title:i,reverse:s}}=this;if(!i.display)return;const n=toFont(i.font),o=toPadding(i.padding),a=i.align;let r=n.lineHeight/2;"bottom"===e||"center"===e||isObject(e)?(r+=o.bottom,isArray(i.text)&&(r+=n.lineHeight*(i.text.length-1))):r+=o.top;const{titleX:l,titleY:h,maxWidth:c,rotation:d}=titleArgs(this,r,e,a);renderText(t,i.text,0,0,n,{color:i.color,maxWidth:c,rotation:d,textAlign:titleAlign(a,e,s),textBaseline:"middle",translation:[l,h]})}draw(t){this._isVisible()&&(this.drawBackground(),this.drawGrid(t),this.drawBorder(),this.drawTitle(),this.drawLabels(t))}_layers(){const t=this.options,e=t.ticks&&t.ticks.z||0,i=valueOrDefault(t.grid&&t.grid.z,-1),s=valueOrDefault(t.border&&t.border.z,0);return this._isVisible()&&this.draw===Scale.prototype.draw?[{z:i,draw:t=>{this.drawBackground(),this.drawGrid(t),this.drawTitle()}},{z:s,draw:()=>{this.drawBorder()}},{z:e,draw:t=>{this.drawLabels(t)}}]:[{z:e,draw:t=>{this.draw(t)}}]}getMatchingVisibleMetas(t){const e=this.chart.getSortedVisibleDatasetMetas(),i=this.axis+"AxisID",s=[];let n,o;for(n=0,o=e.length;n<o;++n){const o=e[n];o[i]!==this.id||t&&o.type!==t||s.push(o)}return s}_resolveTickFontOptions(t){return toFont(this.options.ticks.setContext(this.getContext(t)).font)}_maxDigits(){const t=this._resolveTickFontOptions(0).lineHeight;return(this.isHorizontal()?this.width:this.height)/t}}class TypedRegistry{constructor(t,e,i){this.type=t,this.scope=e,this.override=i,this.items=Object.create(null)}isForType(t){return Object.prototype.isPrototypeOf.call(this.type.prototype,t.prototype)}register(t){const e=Object.getPrototypeOf(t);let i;isIChartComponent(e)&&(i=this.register(e));const s=this.items,n=t.id,o=this.scope+"."+n;if(!n)throw new Error("class does not have id: "+t);return n in s||(s[n]=t,registerDefaults(t,o,i),this.override&&defaults.override(t.id,t.overrides)),o}get(t){return this.items[t]}unregister(t){const e=this.items,i=t.id,s=this.scope;i in e&&delete e[i],s&&i in defaults[s]&&(delete defaults[s][i],this.override&&delete overrides[i])}}function registerDefaults(t,e,i){const s=merge(Object.create(null),[i?defaults.get(i):{},defaults.get(e),t.defaults]);defaults.set(e,s),t.defaultRoutes&&routeDefaults(e,t.defaultRoutes),t.descriptors&&defaults.describe(e,t.descriptors)}function routeDefaults(t,e){Object.keys(e).forEach((i=>{const s=i.split("."),n=s.pop(),o=[t].concat(s).join("."),a=e[i].split("."),r=a.pop(),l=a.join(".");defaults.route(o,n,l,r)}))}function isIChartComponent(t){return"id"in t&&"defaults"in t}class Registry{constructor(){this.controllers=new TypedRegistry(DatasetController,"datasets",!0),this.elements=new TypedRegistry(Element,"elements"),this.plugins=new TypedRegistry(Object,"plugins"),this.scales=new TypedRegistry(Scale,"scales"),this._typedRegistries=[this.controllers,this.scales,this.elements]}add(...t){this._each("register",t)}remove(...t){this._each("unregister",t)}addControllers(...t){this._each("register",t,this.controllers)}addElements(...t){this._each("register",t,this.elements)}addPlugins(...t){this._each("register",t,this.plugins)}addScales(...t){this._each("register",t,this.scales)}getController(t){return this._get(t,this.controllers,"controller")}getElement(t){return this._get(t,this.elements,"element")}getPlugin(t){return this._get(t,this.plugins,"plugin")}getScale(t){return this._get(t,this.scales,"scale")}removeControllers(...t){this._each("unregister",t,this.controllers)}removeElements(...t){this._each("unregister",t,this.elements)}removePlugins(...t){this._each("unregister",t,this.plugins)}removeScales(...t){this._each("unregister",t,this.scales)}_each(t,e,i){[...e].forEach((e=>{const s=i||this._getRegistryForType(e);i||s.isForType(e)||s===this.plugins&&e.id?this._exec(t,s,e):each(e,(e=>{const s=i||this._getRegistryForType(e);this._exec(t,s,e)}))}))}_exec(t,e,i){const s=_capitalize(t);callback(i["before"+s],[],i),e[t](i),callback(i["after"+s],[],i)}_getRegistryForType(t){for(let e=0;e<this._typedRegistries.length;e++){const i=this._typedRegistries[e];if(i.isForType(t))return i}return this.plugins}_get(t,e,i){const s=e.get(t);if(void 0===s)throw new Error('"'+t+'" is not a registered '+i+".");return s}}var registry=new Registry;class PluginService{constructor(){this._init=[]}notify(t,e,i,s){"beforeInit"===e&&(this._init=this._createDescriptors(t,!0),this._notify(this._init,t,"install"));const n=s?this._descriptors(t).filter(s):this._descriptors(t),o=this._notify(n,t,e,i);return"afterDestroy"===e&&(this._notify(n,t,"stop"),this._notify(this._init,t,"uninstall")),o}_notify(t,e,i,s){s=s||{};for(const n of t){const t=n.plugin;if(!1===callback(t[i],[e,s,n.options],t)&&s.cancelable)return!1}return!0}invalidate(){isNullOrUndef(this._cache)||(this._oldCache=this._cache,this._cache=void 0)}_descriptors(t){if(this._cache)return this._cache;const e=this._cache=this._createDescriptors(t);return this._notifyStateChanges(t),e}_createDescriptors(t,e){const i=t&&t.config,s=valueOrDefault(i.options&&i.options.plugins,{}),n=allPlugins(i);return!1!==s||e?createDescriptors(t,n,s,e):[]}_notifyStateChanges(t){const e=this._oldCache||[],i=this._cache,s=(t,e)=>t.filter((t=>!e.some((e=>t.plugin.id===e.plugin.id))));this._notify(s(e,i),t,"stop"),this._notify(s(i,e),t,"start")}}function allPlugins(t){const e={},i=[],s=Object.keys(registry.plugins.items);for(let t=0;t<s.length;t++)i.push(registry.getPlugin(s[t]));const n=t.plugins||[];for(let t=0;t<n.length;t++){const s=n[t];-1===i.indexOf(s)&&(i.push(s),e[s.id]=!0)}return{plugins:i,localIds:e}}function getOpts(t,e){return e||!1!==t?!0===t?{}:t:null}function createDescriptors(t,{plugins:e,localIds:i},s,n){const o=[],a=t.getContext();for(const r of e){const e=r.id,l=getOpts(s[e],n);null!==l&&o.push({plugin:r,options:pluginOpts(t.config,{plugin:r,local:i[e]},l,a)})}return o}function pluginOpts(t,{plugin:e,local:i},s,n){const o=t.pluginScopeKeys(e),a=t.getOptionScopes(s,o);return i&&e.defaults&&a.push(e.defaults),t.createResolver(a,n,[""],{scriptable:!1,indexable:!1,allKeys:!0})}function getIndexAxis(t,e){const i=defaults.datasets[t]||{};return((e.datasets||{})[t]||{}).indexAxis||e.indexAxis||i.indexAxis||"x"}function getAxisFromDefaultScaleID(t,e){let i=t;return"_index_"===t?i=e:"_value_"===t&&(i="x"===e?"y":"x"),i}function getDefaultScaleIDFromAxis(t,e){return t===e?"_index_":"_value_"}function idMatchesAxis(t){if("x"===t||"y"===t||"r"===t)return t}function axisFromPosition(t){return"top"===t||"bottom"===t?"x":"left"===t||"right"===t?"y":void 0}function determineAxis(t,...e){if(idMatchesAxis(t))return t;for(const i of e){const e=i.axis||axisFromPosition(i.position)||t.length>1&&idMatchesAxis(t[0].toLowerCase());if(e)return e}throw new Error(`Cannot determine type of '${t}' axis. Please provide 'axis' or 'position' option.`)}function getAxisFromDataset(t,e,i){if(i[e+"AxisID"]===t)return{axis:e}}function retrieveAxisFromDatasets(t,e){if(e.data&&e.data.datasets){const i=e.data.datasets.filter((e=>e.xAxisID===t||e.yAxisID===t));if(i.length)return getAxisFromDataset(t,"x",i[0])||getAxisFromDataset(t,"y",i[0])}return{}}function mergeScaleConfig(t,e){const i=overrides[t.type]||{scales:{}},s=e.scales||{},n=getIndexAxis(t.type,e),o=Object.create(null);return Object.keys(s).forEach((e=>{const a=s[e];if(!isObject(a))return console.error(`Invalid scale configuration for scale: ${e}`);if(a._proxy)return console.warn(`Ignoring resolver passed as options for scale: ${e}`);const r=determineAxis(e,a,retrieveAxisFromDatasets(e,t),defaults.scales[a.type]),l=getDefaultScaleIDFromAxis(r,n),h=i.scales||{};o[e]=mergeIf(Object.create(null),[{axis:r},a,h[r],h[l]])})),t.data.datasets.forEach((i=>{const n=i.type||t.type,a=i.indexAxis||getIndexAxis(n,e),r=(overrides[n]||{}).scales||{};Object.keys(r).forEach((t=>{const e=getAxisFromDefaultScaleID(t,a),n=i[e+"AxisID"]||e;o[n]=o[n]||Object.create(null),mergeIf(o[n],[{axis:e},s[n],r[t]])}))})),Object.keys(o).forEach((t=>{const e=o[t];mergeIf(e,[defaults.scales[e.type],defaults.scale])})),o}function initOptions(t){const e=t.options||(t.options={});e.plugins=valueOrDefault(e.plugins,{}),e.scales=mergeScaleConfig(t,e)}function initData(t){return(t=t||{}).datasets=t.datasets||[],t.labels=t.labels||[],t}function initConfig(t){return(t=t||{}).data=initData(t.data),initOptions(t),t}const keyCache=new Map,keysCached=new Set;function cachedKeys(t,e){let i=keyCache.get(t);return i||(i=e(),keyCache.set(t,i),keysCached.add(i)),i}const addIfFound=(t,e,i)=>{const s=resolveObjectKey(e,i);void 0!==s&&t.add(s)};class Config{constructor(t){this._config=initConfig(t),this._scopeCache=new Map,this._resolverCache=new Map}get platform(){return this._config.platform}get type(){return this._config.type}set type(t){this._config.type=t}get data(){return this._config.data}set data(t){this._config.data=initData(t)}get options(){return this._config.options}set options(t){this._config.options=t}get plugins(){return this._config.plugins}update(){const t=this._config;this.clearCache(),initOptions(t)}clearCache(){this._scopeCache.clear(),this._resolverCache.clear()}datasetScopeKeys(t){return cachedKeys(t,(()=>[[`datasets.${t}`,""]]))}datasetAnimationScopeKeys(t,e){return cachedKeys(`${t}.transition.${e}`,(()=>[[`datasets.${t}.transitions.${e}`,`transitions.${e}`],[`datasets.${t}`,""]]))}datasetElementScopeKeys(t,e){return cachedKeys(`${t}-${e}`,(()=>[[`datasets.${t}.elements.${e}`,`datasets.${t}`,`elements.${e}`,""]]))}pluginScopeKeys(t){const e=t.id;return cachedKeys(`${this.type}-plugin-${e}`,(()=>[[`plugins.${e}`,...t.additionalOptionScopes||[]]]))}_cachedScopes(t,e){const i=this._scopeCache;let s=i.get(t);return s&&!e||(s=new Map,i.set(t,s)),s}getOptionScopes(t,e,i){const{options:s,type:n}=this,o=this._cachedScopes(t,i),a=o.get(e);if(a)return a;const r=new Set;e.forEach((e=>{t&&(r.add(t),e.forEach((e=>addIfFound(r,t,e)))),e.forEach((t=>addIfFound(r,s,t))),e.forEach((t=>addIfFound(r,overrides[n]||{},t))),e.forEach((t=>addIfFound(r,defaults,t))),e.forEach((t=>addIfFound(r,descriptors,t)))}));const l=Array.from(r);return 0===l.length&&l.push(Object.create(null)),keysCached.has(e)&&o.set(e,l),l}chartOptionScopes(){const{options:t,type:e}=this;return[t,overrides[e]||{},defaults.datasets[e]||{},{type:e},defaults,descriptors]}resolveNamedOptions(t,e,i,s=[""]){const n={$shared:!0},{resolver:o,subPrefixes:a}=getResolver(this._resolverCache,t,s);let r=o;if(needContext(o,e)){n.$shared=!1;r=_attachContext(o,i=isFunction(i)?i():i,this.createResolver(t,i,a))}for(const t of e)n[t]=r[t];return n}createResolver(t,e,i=[""],s){const{resolver:n}=getResolver(this._resolverCache,t,i);return isObject(e)?_attachContext(n,e,void 0,s):n}}function getResolver(t,e,i){let s=t.get(e);s||(s=new Map,t.set(e,s));const n=i.join();let o=s.get(n);if(!o){o={resolver:_createResolver(e,i),subPrefixes:i.filter((t=>!t.toLowerCase().includes("hover")))},s.set(n,o)}return o}const hasFunction=t=>isObject(t)&&Object.getOwnPropertyNames(t).some((e=>isFunction(t[e])));function needContext(t,e){const{isScriptable:i,isIndexable:s}=_descriptors(t);for(const n of e){const e=i(n),o=s(n),a=(o||e)&&t[n];if(e&&(isFunction(a)||hasFunction(a))||o&&isArray(a))return!0}return!1}var version="4.4.1";const KNOWN_POSITIONS=["top","bottom","left","right","chartArea"];function positionIsHorizontal(t,e){return"top"===t||"bottom"===t||-1===KNOWN_POSITIONS.indexOf(t)&&"x"===e}function compare2Level(t,e){return function(i,s){return i[t]===s[t]?i[e]-s[e]:i[t]-s[t]}}function onAnimationsComplete(t){const e=t.chart,i=e.options.animation;e.notifyPlugins("afterRender"),callback(i&&i.onComplete,[t],e)}function onAnimationProgress(t){const e=t.chart,i=e.options.animation;callback(i&&i.onProgress,[t],e)}function getCanvas(t){return _isDomSupported()&&"string"==typeof t?t=document.getElementById(t):t&&t.length&&(t=t[0]),t&&t.canvas&&(t=t.canvas),t}const instances={},getChart=t=>{const e=getCanvas(t);return Object.values(instances).filter((t=>t.canvas===e)).pop()};function moveNumericKeys(t,e,i){const s=Object.keys(t);for(const n of s){const s=+n;if(s>=e){const o=t[n];delete t[n],(i>0||s>e)&&(t[s+i]=o)}}}function determineLastEvent(t,e,i,s){return i&&"mouseout"!==t.type?s?e:t:null}function getSizeForArea(t,e,i){return t.options.clip?t[i]:e[i]}function getDatasetArea(t,e){const{xScale:i,yScale:s}=t;return i&&s?{left:getSizeForArea(i,e,"left"),right:getSizeForArea(i,e,"right"),top:getSizeForArea(s,e,"top"),bottom:getSizeForArea(s,e,"bottom")}:e}class Chart{static defaults=defaults;static instances=instances;static overrides=overrides;static registry=registry;static version=version;static getChart=getChart;static register(...t){registry.add(...t),invalidatePlugins()}static unregister(...t){registry.remove(...t),invalidatePlugins()}constructor(t,e){const i=this.config=new Config(e),s=getCanvas(t),n=getChart(s);if(n)throw new Error("Canvas is already in use. Chart with ID '"+n.id+"' must be destroyed before the canvas with ID '"+n.canvas.id+"' can be reused.");const o=i.createResolver(i.chartOptionScopes(),this.getContext());this.platform=new(i.platform||_detectPlatform(s)),this.platform.updateConfig(i);const a=this.platform.acquireContext(s,o.aspectRatio),r=a&&a.canvas,l=r&&r.height,h=r&&r.width;this.id=uid(),this.ctx=a,this.canvas=r,this.width=h,this.height=l,this._options=o,this._aspectRatio=this.aspectRatio,this._layers=[],this._metasets=[],this._stacks=void 0,this.boxes=[],this.currentDevicePixelRatio=void 0,this.chartArea=void 0,this._active=[],this._lastEvent=void 0,this._listeners={},this._responsiveListeners=void 0,this._sortedMetasets=[],this.scales={},this._plugins=new PluginService,this.$proxies={},this._hiddenIndices={},this.attached=!1,this._animationsDisabled=void 0,this.$context=void 0,this._doResize=debounce((t=>this.update(t)),o.resizeDelay||0),this._dataChanges=[],instances[this.id]=this,a&&r?(animator.listen(this,"complete",onAnimationsComplete),animator.listen(this,"progress",onAnimationProgress),this._initialize(),this.attached&&this.update()):console.error("Failed to create chart: can't acquire context from the given item")}get aspectRatio(){const{options:{aspectRatio:t,maintainAspectRatio:e},width:i,height:s,_aspectRatio:n}=this;return isNullOrUndef(t)?e&&n?n:s?i/s:null:t}get data(){return this.config.data}set data(t){this.config.data=t}get options(){return this._options}set options(t){this.config.options=t}get registry(){return registry}_initialize(){return this.notifyPlugins("beforeInit"),this.options.responsive?this.resize():retinaScale(this,this.options.devicePixelRatio),this.bindEvents(),this.notifyPlugins("afterInit"),this}clear(){return clearCanvas(this.canvas,this.ctx),this}stop(){return animator.stop(this),this}resize(t,e){animator.running(this)?this._resizeBeforeDraw={width:t,height:e}:this._resize(t,e)}_resize(t,e){const i=this.options,s=this.canvas,n=i.maintainAspectRatio&&this.aspectRatio,o=this.platform.getMaximumSize(s,t,e,n),a=i.devicePixelRatio||this.platform.getDevicePixelRatio(),r=this.width?"resize":"attach";this.width=o.width,this.height=o.height,this._aspectRatio=this.aspectRatio,retinaScale(this,a,!0)&&(this.notifyPlugins("resize",{size:o}),callback(i.onResize,[this,o],this),this.attached&&this._doResize(r)&&this.render())}ensureScalesHaveIDs(){each(this.options.scales||{},((t,e)=>{t.id=e}))}buildOrUpdateScales(){const t=this.options,e=t.scales,i=this.scales,s=Object.keys(i).reduce(((t,e)=>(t[e]=!1,t)),{});let n=[];e&&(n=n.concat(Object.keys(e).map((t=>{const i=e[t],s=determineAxis(t,i),n="r"===s,o="x"===s;return{options:i,dposition:n?"chartArea":o?"bottom":"left",dtype:n?"radialLinear":o?"category":"linear"}})))),each(n,(e=>{const n=e.options,o=n.id,a=determineAxis(o,n),r=valueOrDefault(n.type,e.dtype);void 0!==n.position&&positionIsHorizontal(n.position,a)===positionIsHorizontal(e.dposition)||(n.position=e.dposition),s[o]=!0;let l=null;if(o in i&&i[o].type===r)l=i[o];else{l=new(registry.getScale(r))({id:o,type:r,ctx:this.ctx,chart:this}),i[l.id]=l}l.init(n,t)})),each(s,((t,e)=>{t||delete i[e]})),each(i,(t=>{layouts.configure(this,t,t.options),layouts.addBox(this,t)}))}_updateMetasets(){const t=this._metasets,e=this.data.datasets.length,i=t.length;if(t.sort(((t,e)=>t.index-e.index)),i>e){for(let t=e;t<i;++t)this._destroyDatasetMeta(t);t.splice(e,i-e)}this._sortedMetasets=t.slice(0).sort(compare2Level("order","index"))}_removeUnreferencedMetasets(){const{_metasets:t,data:{datasets:e}}=this;t.length>e.length&&delete this._stacks,t.forEach(((t,i)=>{0===e.filter((e=>e===t._dataset)).length&&this._destroyDatasetMeta(i)}))}buildOrUpdateControllers(){const t=[],e=this.data.datasets;let i,s;for(this._removeUnreferencedMetasets(),i=0,s=e.length;i<s;i++){const s=e[i];let n=this.getDatasetMeta(i);const o=s.type||this.config.type;if(n.type&&n.type!==o&&(this._destroyDatasetMeta(i),n=this.getDatasetMeta(i)),n.type=o,n.indexAxis=s.indexAxis||getIndexAxis(o,this.options),n.order=s.order||0,n.index=i,n.label=""+s.label,n.visible=this.isDatasetVisible(i),n.controller)n.controller.updateIndex(i),n.controller.linkScales();else{const e=registry.getController(o),{datasetElementType:s,dataElementType:a}=defaults.datasets[o];Object.assign(e,{dataElementType:registry.getElement(a),datasetElementType:s&&registry.getElement(s)}),n.controller=new e(this,i),t.push(n.controller)}}return this._updateMetasets(),t}_resetElements(){each(this.data.datasets,((t,e)=>{this.getDatasetMeta(e).controller.reset()}),this)}reset(){this._resetElements(),this.notifyPlugins("reset")}update(t){const e=this.config;e.update();const i=this._options=e.createResolver(e.chartOptionScopes(),this.getContext()),s=this._animationsDisabled=!i.animation;if(this._updateScales(),this._checkEventBindings(),this._updateHiddenIndices(),this._plugins.invalidate(),!1===this.notifyPlugins("beforeUpdate",{mode:t,cancelable:!0}))return;const n=this.buildOrUpdateControllers();this.notifyPlugins("beforeElementsUpdate");let o=0;for(let t=0,e=this.data.datasets.length;t<e;t++){const{controller:e}=this.getDatasetMeta(t),i=!s&&-1===n.indexOf(e);e.buildOrUpdateElements(i),o=Math.max(+e.getMaxOverflow(),o)}o=this._minPadding=i.layout.autoPadding?o:0,this._updateLayout(o),s||each(n,(t=>{t.reset()})),this._updateDatasets(t),this.notifyPlugins("afterUpdate",{mode:t}),this._layers.sort(compare2Level("z","_idx"));const{_active:a,_lastEvent:r}=this;r?this._eventHandler(r,!0):a.length&&this._updateHoverStyles(a,a,!0),this.render()}_updateScales(){each(this.scales,(t=>{layouts.removeBox(this,t)})),this.ensureScalesHaveIDs(),this.buildOrUpdateScales()}_checkEventBindings(){const t=this.options,e=new Set(Object.keys(this._listeners)),i=new Set(t.events);setsEqual(e,i)&&!!this._responsiveListeners===t.responsive||(this.unbindEvents(),this.bindEvents())}_updateHiddenIndices(){const{_hiddenIndices:t}=this,e=this._getUniformDataChanges()||[];for(const{method:i,start:s,count:n}of e){moveNumericKeys(t,s,"_removeElements"===i?-n:n)}}_getUniformDataChanges(){const t=this._dataChanges;if(!t||!t.length)return;this._dataChanges=[];const e=this.data.datasets.length,i=e=>new Set(t.filter((t=>t[0]===e)).map(((t,e)=>e+","+t.splice(1).join(",")))),s=i(0);for(let t=1;t<e;t++)if(!setsEqual(s,i(t)))return;return Array.from(s).map((t=>t.split(","))).map((t=>({method:t[1],start:+t[2],count:+t[3]})))}_updateLayout(t){if(!1===this.notifyPlugins("beforeLayout",{cancelable:!0}))return;layouts.update(this,this.width,this.height,t);const e=this.chartArea,i=e.width<=0||e.height<=0;this._layers=[],each(this.boxes,(t=>{i&&"chartArea"===t.position||(t.configure&&t.configure(),this._layers.push(...t._layers()))}),this),this._layers.forEach(((t,e)=>{t._idx=e})),this.notifyPlugins("afterLayout")}_updateDatasets(t){if(!1!==this.notifyPlugins("beforeDatasetsUpdate",{mode:t,cancelable:!0})){for(let t=0,e=this.data.datasets.length;t<e;++t)this.getDatasetMeta(t).controller.configure();for(let e=0,i=this.data.datasets.length;e<i;++e)this._updateDataset(e,isFunction(t)?t({datasetIndex:e}):t);this.notifyPlugins("afterDatasetsUpdate",{mode:t})}}_updateDataset(t,e){const i=this.getDatasetMeta(t),s={meta:i,index:t,mode:e,cancelable:!0};!1!==this.notifyPlugins("beforeDatasetUpdate",s)&&(i.controller._update(e),s.cancelable=!1,this.notifyPlugins("afterDatasetUpdate",s))}render(){!1!==this.notifyPlugins("beforeRender",{cancelable:!0})&&(animator.has(this)?this.attached&&!animator.running(this)&&animator.start(this):(this.draw(),onAnimationsComplete({chart:this})))}draw(){let t;if(this._resizeBeforeDraw){const{width:t,height:e}=this._resizeBeforeDraw;this._resize(t,e),this._resizeBeforeDraw=null}if(this.clear(),this.width<=0||this.height<=0)return;if(!1===this.notifyPlugins("beforeDraw",{cancelable:!0}))return;const e=this._layers;for(t=0;t<e.length&&e[t].z<=0;++t)e[t].draw(this.chartArea);for(this._drawDatasets();t<e.length;++t)e[t].draw(this.chartArea);this.notifyPlugins("afterDraw")}_getSortedDatasetMetas(t){const e=this._sortedMetasets,i=[];let s,n;for(s=0,n=e.length;s<n;++s){const n=e[s];t&&!n.visible||i.push(n)}return i}getSortedVisibleDatasetMetas(){return this._getSortedDatasetMetas(!0)}_drawDatasets(){if(!1===this.notifyPlugins("beforeDatasetsDraw",{cancelable:!0}))return;const t=this.getSortedVisibleDatasetMetas();for(let e=t.length-1;e>=0;--e)this._drawDataset(t[e]);this.notifyPlugins("afterDatasetsDraw")}_drawDataset(t){const e=this.ctx,i=t._clip,s=!i.disabled,n=getDatasetArea(t,this.chartArea),o={meta:t,index:t.index,cancelable:!0};!1!==this.notifyPlugins("beforeDatasetDraw",o)&&(s&&clipArea(e,{left:!1===i.left?0:n.left-i.left,right:!1===i.right?this.width:n.right+i.right,top:!1===i.top?0:n.top-i.top,bottom:!1===i.bottom?this.height:n.bottom+i.bottom}),t.controller.draw(),s&&unclipArea(e),o.cancelable=!1,this.notifyPlugins("afterDatasetDraw",o))}isPointInArea(t){return _isPointInArea(t,this.chartArea,this._minPadding)}getElementsAtEventForMode(t,e,i,s){const n=Interaction.modes[e];return"function"==typeof n?n(this,t,i,s):[]}getDatasetMeta(t){const e=this.data.datasets[t],i=this._metasets;let s=i.filter((t=>t&&t._dataset===e)).pop();return s||(s={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null,order:e&&e.order||0,index:t,_dataset:e,_parsed:[],_sorted:!1},i.push(s)),s}getContext(){return this.$context||(this.$context=createContext(null,{chart:this,type:"chart"}))}getVisibleDatasetCount(){return this.getSortedVisibleDatasetMetas().length}isDatasetVisible(t){const e=this.data.datasets[t];if(!e)return!1;const i=this.getDatasetMeta(t);return"boolean"==typeof i.hidden?!i.hidden:!e.hidden}setDatasetVisibility(t,e){this.getDatasetMeta(t).hidden=!e}toggleDataVisibility(t){this._hiddenIndices[t]=!this._hiddenIndices[t]}getDataVisibility(t){return!this._hiddenIndices[t]}_updateVisibility(t,e,i){const s=i?"show":"hide",n=this.getDatasetMeta(t),o=n.controller._resolveAnimations(void 0,s);defined(e)?(n.data[e].hidden=!i,this.update()):(this.setDatasetVisibility(t,i),o.update(n,{visible:i}),this.update((e=>e.datasetIndex===t?s:void 0)))}hide(t,e){this._updateVisibility(t,e,!1)}show(t,e){this._updateVisibility(t,e,!0)}_destroyDatasetMeta(t){const e=this._metasets[t];e&&e.controller&&e.controller._destroy(),delete this._metasets[t]}_stop(){let t,e;for(this.stop(),animator.remove(this),t=0,e=this.data.datasets.length;t<e;++t)this._destroyDatasetMeta(t)}destroy(){this.notifyPlugins("beforeDestroy");const{canvas:t,ctx:e}=this;this._stop(),this.config.clearCache(),t&&(this.unbindEvents(),clearCanvas(t,e),this.platform.releaseContext(e),this.canvas=null,this.ctx=null),delete instances[this.id],this.notifyPlugins("afterDestroy")}toBase64Image(...t){return this.canvas.toDataURL(...t)}bindEvents(){this.bindUserEvents(),this.options.responsive?this.bindResponsiveEvents():this.attached=!0}bindUserEvents(){const t=this._listeners,e=this.platform,i=(i,s)=>{e.addEventListener(this,i,s),t[i]=s},s=(t,e,i)=>{t.offsetX=e,t.offsetY=i,this._eventHandler(t)};each(this.options.events,(t=>i(t,s)))}bindResponsiveEvents(){this._responsiveListeners||(this._responsiveListeners={});const t=this._responsiveListeners,e=this.platform,i=(i,s)=>{e.addEventListener(this,i,s),t[i]=s},s=(i,s)=>{t[i]&&(e.removeEventListener(this,i,s),delete t[i])},n=(t,e)=>{this.canvas&&this.resize(t,e)};let o;const a=()=>{s("attach",a),this.attached=!0,this.resize(),i("resize",n),i("detach",o)};o=()=>{this.attached=!1,s("resize",n),this._stop(),this._resize(0,0),i("attach",a)},e.isAttached(this.canvas)?a():o()}unbindEvents(){each(this._listeners,((t,e)=>{this.platform.removeEventListener(this,e,t)})),this._listeners={},each(this._responsiveListeners,((t,e)=>{this.platform.removeEventListener(this,e,t)})),this._responsiveListeners=void 0}updateHoverStyle(t,e,i){const s=i?"set":"remove";let n,o,a,r;for("dataset"===e&&(n=this.getDatasetMeta(t[0].datasetIndex),n.controller["_"+s+"DatasetHoverStyle"]()),a=0,r=t.length;a<r;++a){o=t[a];const e=o&&this.getDatasetMeta(o.datasetIndex).controller;e&&e[s+"HoverStyle"](o.element,o.datasetIndex,o.index)}}getActiveElements(){return this._active||[]}setActiveElements(t){const e=this._active||[],i=t.map((({datasetIndex:t,index:e})=>{const i=this.getDatasetMeta(t);if(!i)throw new Error("No dataset found at index "+t);return{datasetIndex:t,element:i.data[e],index:e}}));!_elementsEqual(i,e)&&(this._active=i,this._lastEvent=null,this._updateHoverStyles(i,e))}notifyPlugins(t,e,i){return this._plugins.notify(this,t,e,i)}isPluginEnabled(t){return 1===this._plugins._cache.filter((e=>e.plugin.id===t)).length}_updateHoverStyles(t,e,i){const s=this.options.hover,n=(t,e)=>t.filter((t=>!e.some((e=>t.datasetIndex===e.datasetIndex&&t.index===e.index)))),o=n(e,t),a=i?t:n(t,e);o.length&&this.updateHoverStyle(o,s.mode,!1),a.length&&s.mode&&this.updateHoverStyle(a,s.mode,!0)}_eventHandler(t,e){const i={event:t,replay:e,cancelable:!0,inChartArea:this.isPointInArea(t)},s=e=>(e.options.events||this.options.events).includes(t.native.type);if(!1===this.notifyPlugins("beforeEvent",i,s))return;const n=this._handleEvent(t,e,i.inChartArea);return i.cancelable=!1,this.notifyPlugins("afterEvent",i,s),(n||i.changed)&&this.render(),this}_handleEvent(t,e,i){const{_active:s=[],options:n}=this,o=e,a=this._getActiveElements(t,s,i,o),r=_isClickEvent(t),l=determineLastEvent(t,this._lastEvent,i,r);i&&(this._lastEvent=null,callback(n.onHover,[t,a,this],this),r&&callback(n.onClick,[t,a,this],this));const h=!_elementsEqual(a,s);return(h||e)&&(this._active=a,this._updateHoverStyles(a,s,e)),this._lastEvent=l,h}_getActiveElements(t,e,i,s){if("mouseout"===t.type)return[];if(!i)return e;const n=this.options.hover;return this.getElementsAtEventForMode(t,n.mode,n,s)}}function invalidatePlugins(){return each(Chart.instances,(t=>t._plugins.invalidate()))}function clipArc(t,e,i){const{startAngle:s,pixelMargin:n,x:o,y:a,outerRadius:r,innerRadius:l}=e;let h=n/r;t.beginPath(),t.arc(o,a,r,s-h,i+h),l>n?(h=n/l,t.arc(o,a,l,i+h,s-h,!0)):t.arc(o,a,n,i+HALF_PI,s-HALF_PI),t.closePath(),t.clip()}function toRadiusCorners(t){return _readValueToProps(t,["outerStart","outerEnd","innerStart","innerEnd"])}function parseBorderRadius$1(t,e,i,s){const n=toRadiusCorners(t.options.borderRadius),o=(i-e)/2,a=Math.min(o,s*e/2),r=t=>{const e=(i-Math.min(o,t))*s/2;return _limitValue(t,0,Math.min(o,e))};return{outerStart:r(n.outerStart),outerEnd:r(n.outerEnd),innerStart:_limitValue(n.innerStart,0,a),innerEnd:_limitValue(n.innerEnd,0,a)}}function rThetaToXY(t,e,i,s){return{x:i+t*Math.cos(e),y:s+t*Math.sin(e)}}function pathArc(t,e,i,s,n,o){const{x:a,y:r,startAngle:l,pixelMargin:h,innerRadius:c}=e,d=Math.max(e.outerRadius+s+i-h,0),u=c>0?c+s+i+h:0;let g=0;const f=n-l;if(s){const t=((c>0?c-s:0)+(d>0?d-s:0))/2;g=(f-(0!==t?f*t/(t+s):f))/2}const p=(f-Math.max(.001,f*d-i/PI)/d)/2,m=l+p+g,b=n-p-g,{outerStart:x,outerEnd:_,innerStart:y,innerEnd:v}=parseBorderRadius$1(e,u,d,b-m),S=d-x,k=d-_,P=m+x/S,M=b-_/k,w=u+y,A=u+v,C=m+y/w,O=b-v/A;if(t.beginPath(),o){const e=(P+M)/2;if(t.arc(a,r,d,P,e),t.arc(a,r,d,e,M),_>0){const e=rThetaToXY(k,M,a,r);t.arc(e.x,e.y,_,M,b+HALF_PI)}const i=rThetaToXY(A,b,a,r);if(t.lineTo(i.x,i.y),v>0){const e=rThetaToXY(A,O,a,r);t.arc(e.x,e.y,v,b+HALF_PI,O+Math.PI)}const s=(b-v/u+(m+y/u))/2;if(t.arc(a,r,u,b-v/u,s,!0),t.arc(a,r,u,s,m+y/u,!0),y>0){const e=rThetaToXY(w,C,a,r);t.arc(e.x,e.y,y,C+Math.PI,m-HALF_PI)}const n=rThetaToXY(S,m,a,r);if(t.lineTo(n.x,n.y),x>0){const e=rThetaToXY(S,P,a,r);t.arc(e.x,e.y,x,m-HALF_PI,P)}}else{t.moveTo(a,r);const e=Math.cos(P)*d+a,i=Math.sin(P)*d+r;t.lineTo(e,i);const s=Math.cos(M)*d+a,n=Math.sin(M)*d+r;t.lineTo(s,n)}t.closePath()}function drawArc(t,e,i,s,n){const{fullCircles:o,startAngle:a,circumference:r}=e;let l=e.endAngle;if(o){pathArc(t,e,i,s,l,n);for(let e=0;e<o;++e)t.fill();isNaN(r)||(l=a+(r%TAU||TAU))}return pathArc(t,e,i,s,l,n),t.fill(),l}function drawBorder(t,e,i,s,n){const{fullCircles:o,startAngle:a,circumference:r,options:l}=e,{borderWidth:h,borderJoinStyle:c,borderDash:d,borderDashOffset:u}=l,g="inner"===l.borderAlign;if(!h)return;t.setLineDash(d||[]),t.lineDashOffset=u,g?(t.lineWidth=2*h,t.lineJoin=c||"round"):(t.lineWidth=h,t.lineJoin=c||"bevel");let f=e.endAngle;if(o){pathArc(t,e,i,s,f,n);for(let e=0;e<o;++e)t.stroke();isNaN(r)||(f=a+(r%TAU||TAU))}g&&clipArc(t,e,f),o||(pathArc(t,e,i,s,f,n),t.stroke())}class ArcElement extends Element{static id="arc";static defaults={borderAlign:"center",borderColor:"#fff",borderDash:[],borderDashOffset:0,borderJoinStyle:void 0,borderRadius:0,borderWidth:2,offset:0,spacing:0,angle:void 0,circular:!0};static defaultRoutes={backgroundColor:"backgroundColor"};static descriptors={_scriptable:!0,_indexable:t=>"borderDash"!==t};circumference;endAngle;fullCircles;innerRadius;outerRadius;pixelMargin;startAngle;constructor(t){super(),this.options=void 0,this.circumference=void 0,this.startAngle=void 0,this.endAngle=void 0,this.innerRadius=void 0,this.outerRadius=void 0,this.pixelMargin=0,this.fullCircles=0,t&&Object.assign(this,t)}inRange(t,e,i){const s=this.getProps(["x","y"],i),{angle:n,distance:o}=getAngleFromPoint(s,{x:t,y:e}),{startAngle:a,endAngle:r,innerRadius:l,outerRadius:h,circumference:c}=this.getProps(["startAngle","endAngle","innerRadius","outerRadius","circumference"],i),d=(this.options.spacing+this.options.borderWidth)/2,u=valueOrDefault(c,r-a)>=TAU||_angleBetween(n,a,r),g=_isBetween(o,l+d,h+d);return u&&g}getCenterPoint(t){const{x:e,y:i,startAngle:s,endAngle:n,innerRadius:o,outerRadius:a}=this.getProps(["x","y","startAngle","endAngle","innerRadius","outerRadius"],t),{offset:r,spacing:l}=this.options,h=(s+n)/2,c=(o+a+l+r)/2;return{x:e+Math.cos(h)*c,y:i+Math.sin(h)*c}}tooltipPosition(t){return this.getCenterPoint(t)}draw(t){const{options:e,circumference:i}=this,s=(e.offset||0)/4,n=(e.spacing||0)/2,o=e.circular;if(this.pixelMargin="inner"===e.borderAlign?.33:0,this.fullCircles=i>TAU?Math.floor(i/TAU):0,0===i||this.innerRadius<0||this.outerRadius<0)return;t.save();const a=(this.startAngle+this.endAngle)/2;t.translate(Math.cos(a)*s,Math.sin(a)*s);const r=s*(1-Math.sin(Math.min(PI,i||0)));t.fillStyle=e.backgroundColor,t.strokeStyle=e.borderColor,drawArc(t,this,r,n,o),drawBorder(t,this,r,n,o),t.restore()}}function setStyle(t,e,i=e){t.lineCap=valueOrDefault(i.borderCapStyle,e.borderCapStyle),t.setLineDash(valueOrDefault(i.borderDash,e.borderDash)),t.lineDashOffset=valueOrDefault(i.borderDashOffset,e.borderDashOffset),t.lineJoin=valueOrDefault(i.borderJoinStyle,e.borderJoinStyle),t.lineWidth=valueOrDefault(i.borderWidth,e.borderWidth),t.strokeStyle=valueOrDefault(i.borderColor,e.borderColor)}function lineTo(t,e,i){t.lineTo(i.x,i.y)}function getLineMethod(t){return t.stepped?_steppedLineTo:t.tension||"monotone"===t.cubicInterpolationMode?_bezierCurveTo:lineTo}function pathVars(t,e,i={}){const s=t.length,{start:n=0,end:o=s-1}=i,{start:a,end:r}=e,l=Math.max(n,a),h=Math.min(o,r),c=n<a&&o<a||n>r&&o>r;return{count:s,start:l,loop:e.loop,ilen:h<l&&!c?s+h-l:h-l}}function pathSegment(t,e,i,s){const{points:n,options:o}=e,{count:a,start:r,loop:l,ilen:h}=pathVars(n,i,s),c=getLineMethod(o);let d,u,g,{move:f=!0,reverse:p}=s||{};for(d=0;d<=h;++d)u=n[(r+(p?h-d:d))%a],u.skip||(f?(t.moveTo(u.x,u.y),f=!1):c(t,g,u,p,o.stepped),g=u);return l&&(u=n[(r+(p?h:0))%a],c(t,g,u,p,o.stepped)),!!l}function fastPathSegment(t,e,i,s){const n=e.points,{count:o,start:a,ilen:r}=pathVars(n,i,s),{move:l=!0,reverse:h}=s||{};let c,d,u,g,f,p,m=0,b=0;const x=t=>(a+(h?r-t:t))%o,_=()=>{g!==f&&(t.lineTo(m,f),t.lineTo(m,g),t.lineTo(m,p))};for(l&&(d=n[x(0)],t.moveTo(d.x,d.y)),c=0;c<=r;++c){if(d=n[x(c)],d.skip)continue;const e=d.x,i=d.y,s=0|e;s===u?(i<g?g=i:i>f&&(f=i),m=(b*m+e)/++b):(_(),t.lineTo(e,i),u=s,b=0,g=f=i),p=i}_()}function _getSegmentMethod(t){const e=t.options,i=e.borderDash&&e.borderDash.length;return!(t._decimated||t._loop||e.tension||"monotone"===e.cubicInterpolationMode||e.stepped||i)?fastPathSegment:pathSegment}function _getInterpolationMethod(t){return t.stepped?_steppedInterpolation:t.tension||"monotone"===t.cubicInterpolationMode?_bezierInterpolation:_pointInLine}function strokePathWithCache(t,e,i,s){let n=e._path;n||(n=e._path=new Path2D,e.path(n,i,s)&&n.closePath()),setStyle(t,e.options),t.stroke(n)}function strokePathDirect(t,e,i,s){const{segments:n,options:o}=e,a=_getSegmentMethod(e);for(const r of n)setStyle(t,o,r.style),t.beginPath(),a(t,e,r,{start:i,end:i+s-1})&&t.closePath(),t.stroke()}const usePath2D="function"==typeof Path2D;function draw(t,e,i,s){usePath2D&&!e.options.segment?strokePathWithCache(t,e,i,s):strokePathDirect(t,e,i,s)}class LineElement extends Element{static id="line";static defaults={borderCapStyle:"butt",borderDash:[],borderDashOffset:0,borderJoinStyle:"miter",borderWidth:3,capBezierPoints:!0,cubicInterpolationMode:"default",fill:!1,spanGaps:!1,stepped:!1,tension:0};static defaultRoutes={backgroundColor:"backgroundColor",borderColor:"borderColor"};static descriptors={_scriptable:!0,_indexable:t=>"borderDash"!==t&&"fill"!==t};constructor(t){super(),this.animated=!0,this.options=void 0,this._chart=void 0,this._loop=void 0,this._fullLoop=void 0,this._path=void 0,this._points=void 0,this._segments=void 0,this._decimated=!1,this._pointsUpdated=!1,this._datasetIndex=void 0,t&&Object.assign(this,t)}updateControlPoints(t,e){const i=this.options;if((i.tension||"monotone"===i.cubicInterpolationMode)&&!i.stepped&&!this._pointsUpdated){const s=i.spanGaps?this._loop:this._fullLoop;_updateBezierControlPoints(this._points,i,t,s,e),this._pointsUpdated=!0}}set points(t){this._points=t,delete this._segments,delete this._path,this._pointsUpdated=!1}get points(){return this._points}get segments(){return this._segments||(this._segments=_computeSegments(this,this.options.segment))}first(){const t=this.segments,e=this.points;return t.length&&e[t[0].start]}last(){const t=this.segments,e=this.points,i=t.length;return i&&e[t[i-1].end]}interpolate(t,e){const i=this.options,s=t[e],n=this.points,o=_boundSegments(this,{property:e,start:s,end:s});if(!o.length)return;const a=[],r=_getInterpolationMethod(i);let l,h;for(l=0,h=o.length;l<h;++l){const{start:h,end:c}=o[l],d=n[h],u=n[c];if(d===u){a.push(d);continue}const g=r(d,u,Math.abs((s-d[e])/(u[e]-d[e])),i.stepped);g[e]=t[e],a.push(g)}return 1===a.length?a[0]:a}pathSegment(t,e,i){return _getSegmentMethod(this)(t,this,e,i)}path(t,e,i){const s=this.segments,n=_getSegmentMethod(this);let o=this._loop;e=e||0,i=i||this.points.length-e;for(const a of s)o&=n(t,this,a,{start:e,end:e+i-1});return!!o}draw(t,e,i,s){const n=this.options||{};(this.points||[]).length&&n.borderWidth&&(t.save(),draw(t,this,i,s),t.restore()),this.animated&&(this._pointsUpdated=!1,this._path=void 0)}}function inRange$1(t,e,i,s){const n=t.options,{[i]:o}=t.getProps([i],s);return Math.abs(e-o)<n.radius+n.hitRadius}class PointElement extends Element{static id="point";parsed;skip;stop;static defaults={borderWidth:1,hitRadius:1,hoverBorderWidth:1,hoverRadius:4,pointStyle:"circle",radius:3,rotation:0};static defaultRoutes={backgroundColor:"backgroundColor",borderColor:"borderColor"};constructor(t){super(),this.options=void 0,this.parsed=void 0,this.skip=void 0,this.stop=void 0,t&&Object.assign(this,t)}inRange(t,e,i){const s=this.options,{x:n,y:o}=this.getProps(["x","y"],i);return Math.pow(t-n,2)+Math.pow(e-o,2)<Math.pow(s.hitRadius+s.radius,2)}inXRange(t,e){return inRange$1(this,t,"x",e)}inYRange(t,e){return inRange$1(this,t,"y",e)}getCenterPoint(t){const{x:e,y:i}=this.getProps(["x","y"],t);return{x:e,y:i}}size(t){let e=(t=t||this.options||{}).radius||0;e=Math.max(e,e&&t.hoverRadius||0);return 2*(e+(e&&t.borderWidth||0))}draw(t,e){const i=this.options;this.skip||i.radius<.1||!_isPointInArea(this,e,this.size(i)/2)||(t.strokeStyle=i.borderColor,t.lineWidth=i.borderWidth,t.fillStyle=i.backgroundColor,drawPoint(t,i,this.x,this.y))}getRange(){const t=this.options||{};return t.radius+t.hitRadius}}function getBarBounds(t,e){const{x:i,y:s,base:n,width:o,height:a}=t.getProps(["x","y","base","width","height"],e);let r,l,h,c,d;return t.horizontal?(d=a/2,r=Math.min(i,n),l=Math.max(i,n),h=s-d,c=s+d):(d=o/2,r=i-d,l=i+d,h=Math.min(s,n),c=Math.max(s,n)),{left:r,top:h,right:l,bottom:c}}function skipOrLimit(t,e,i,s){return t?0:_limitValue(e,i,s)}function parseBorderWidth(t,e,i){const s=t.options.borderWidth,n=t.borderSkipped,o=toTRBL(s);return{t:skipOrLimit(n.top,o.top,0,i),r:skipOrLimit(n.right,o.right,0,e),b:skipOrLimit(n.bottom,o.bottom,0,i),l:skipOrLimit(n.left,o.left,0,e)}}function parseBorderRadius(t,e,i){const{enableBorderRadius:s}=t.getProps(["enableBorderRadius"]),n=t.options.borderRadius,o=toTRBLCorners(n),a=Math.min(e,i),r=t.borderSkipped,l=s||isObject(n);return{topLeft:skipOrLimit(!l||r.top||r.left,o.topLeft,0,a),topRight:skipOrLimit(!l||r.top||r.right,o.topRight,0,a),bottomLeft:skipOrLimit(!l||r.bottom||r.left,o.bottomLeft,0,a),bottomRight:skipOrLimit(!l||r.bottom||r.right,o.bottomRight,0,a)}}function boundingRects(t){const e=getBarBounds(t),i=e.right-e.left,s=e.bottom-e.top,n=parseBorderWidth(t,i/2,s/2),o=parseBorderRadius(t,i/2,s/2);return{outer:{x:e.left,y:e.top,w:i,h:s,radius:o},inner:{x:e.left+n.l,y:e.top+n.t,w:i-n.l-n.r,h:s-n.t-n.b,radius:{topLeft:Math.max(0,o.topLeft-Math.max(n.t,n.l)),topRight:Math.max(0,o.topRight-Math.max(n.t,n.r)),bottomLeft:Math.max(0,o.bottomLeft-Math.max(n.b,n.l)),bottomRight:Math.max(0,o.bottomRight-Math.max(n.b,n.r))}}}}function inRange(t,e,i,s){const n=null===e,o=null===i,a=t&&!(n&&o)&&getBarBounds(t,s);return a&&(n||_isBetween(e,a.left,a.right))&&(o||_isBetween(i,a.top,a.bottom))}function hasRadius(t){return t.topLeft||t.topRight||t.bottomLeft||t.bottomRight}function addNormalRectPath(t,e){t.rect(e.x,e.y,e.w,e.h)}function inflateRect(t,e,i={}){const s=t.x!==i.x?-e:0,n=t.y!==i.y?-e:0,o=(t.x+t.w!==i.x+i.w?e:0)-s,a=(t.y+t.h!==i.y+i.h?e:0)-n;return{x:t.x+s,y:t.y+n,w:t.w+o,h:t.h+a,radius:t.radius}}class BarElement extends Element{static id="bar";static defaults={borderSkipped:"start",borderWidth:0,borderRadius:0,inflateAmount:"auto",pointStyle:void 0};static defaultRoutes={backgroundColor:"backgroundColor",borderColor:"borderColor"};constructor(t){super(),this.options=void 0,this.horizontal=void 0,this.base=void 0,this.width=void 0,this.height=void 0,this.inflateAmount=void 0,t&&Object.assign(this,t)}draw(t){const{inflateAmount:e,options:{borderColor:i,backgroundColor:s}}=this,{inner:n,outer:o}=boundingRects(this),a=hasRadius(o.radius)?addRoundedRectPath:addNormalRectPath;t.save(),o.w===n.w&&o.h===n.h||(t.beginPath(),a(t,inflateRect(o,e,n)),t.clip(),a(t,inflateRect(n,-e,o)),t.fillStyle=i,t.fill("evenodd")),t.beginPath(),a(t,inflateRect(n,e)),t.fillStyle=s,t.fill(),t.restore()}inRange(t,e,i){return inRange(this,t,e,i)}inXRange(t,e){return inRange(this,t,null,e)}inYRange(t,e){return inRange(this,null,t,e)}getCenterPoint(t){const{x:e,y:i,base:s,horizontal:n}=this.getProps(["x","y","base","horizontal"],t);return{x:n?(e+s)/2:e,y:n?i:(i+s)/2}}getRange(t){return"x"===t?this.width/2:this.height/2}}var elements=Object.freeze({__proto__:null,ArcElement,BarElement,LineElement,PointElement});const BORDER_COLORS=["rgb(54, 162, 235)","rgb(255, 99, 132)","rgb(255, 159, 64)","rgb(255, 205, 86)","rgb(75, 192, 192)","rgb(153, 102, 255)","rgb(201, 203, 207)"],BACKGROUND_COLORS=BORDER_COLORS.map((t=>t.replace("rgb(","rgba(").replace(")",", 0.5)")));function getBorderColor(t){return BORDER_COLORS[t%BORDER_COLORS.length]}function getBackgroundColor(t){return BACKGROUND_COLORS[t%BACKGROUND_COLORS.length]}function colorizeDefaultDataset(t,e){return t.borderColor=getBorderColor(e),t.backgroundColor=getBackgroundColor(e),++e}function colorizeDoughnutDataset(t,e){return t.backgroundColor=t.data.map((()=>getBorderColor(e++))),e}function colorizePolarAreaDataset(t,e){return t.backgroundColor=t.data.map((()=>getBackgroundColor(e++))),e}function getColorizer(t){let e=0;return(i,s)=>{const n=t.getDatasetMeta(s).controller;n instanceof DoughnutController?e=colorizeDoughnutDataset(i,e):n instanceof PolarAreaController?e=colorizePolarAreaDataset(i,e):n&&(e=colorizeDefaultDataset(i,e))}}function containsColorsDefinitions(t){let e;for(e in t)if(t[e].borderColor||t[e].backgroundColor)return!0;return!1}function containsColorsDefinition(t){return t&&(t.borderColor||t.backgroundColor)}var plugin_colors={id:"colors",defaults:{enabled:!0,forceOverride:!1},beforeLayout(t,e,i){if(!i.enabled)return;const{data:{datasets:s},options:n}=t.config,{elements:o}=n;if(!i.forceOverride&&(containsColorsDefinitions(s)||containsColorsDefinition(n)||o&&containsColorsDefinitions(o)))return;const a=getColorizer(t);s.forEach(a)}};function lttbDecimation(t,e,i,s,n){const o=n.samples||s;if(o>=i)return t.slice(e,e+i);const a=[],r=(i-2)/(o-2);let l=0;const h=e+i-1;let c,d,u,g,f,p=e;for(a[l++]=t[p],c=0;c<o-2;c++){let s,n=0,o=0;const h=Math.floor((c+1)*r)+1+e,m=Math.min(Math.floor((c+2)*r)+1,i)+e,b=m-h;for(s=h;s<m;s++)n+=t[s].x,o+=t[s].y;n/=b,o/=b;const x=Math.floor(c*r)+1+e,_=Math.min(Math.floor((c+1)*r)+1,i)+e,{x:y,y:v}=t[p];for(u=g=-1,s=x;s<_;s++)g=.5*Math.abs((y-n)*(t[s].y-v)-(y-t[s].x)*(o-v)),g>u&&(u=g,d=t[s],f=s);a[l++]=d,p=f}return a[l++]=t[h],a}function minMaxDecimation(t,e,i,s){let n,o,a,r,l,h,c,d,u,g,f=0,p=0;const m=[],b=e+i-1,x=t[e].x,_=t[b].x-x;for(n=e;n<e+i;++n){o=t[n],a=(o.x-x)/_*s,r=o.y;const e=0|a;if(e===l)r<u?(u=r,h=n):r>g&&(g=r,c=n),f=(p*f+o.x)/++p;else{const i=n-1;if(!isNullOrUndef(h)&&!isNullOrUndef(c)){const e=Math.min(h,c),s=Math.max(h,c);e!==d&&e!==i&&m.push({...t[e],x:f}),s!==d&&s!==i&&m.push({...t[s],x:f})}n>0&&i!==d&&m.push(t[i]),m.push(o),l=e,p=0,u=g=r,h=c=d=n}}return m}function cleanDecimatedDataset(t){if(t._decimated){const e=t._data;delete t._decimated,delete t._data,Object.defineProperty(t,"data",{configurable:!0,enumerable:!0,writable:!0,value:e})}}function cleanDecimatedData(t){t.data.datasets.forEach((t=>{cleanDecimatedDataset(t)}))}function getStartAndCountOfVisiblePointsSimplified(t,e){const i=e.length;let s,n=0;const{iScale:o}=t,{min:a,max:r,minDefined:l,maxDefined:h}=o.getUserBounds();return l&&(n=_limitValue(_lookupByKey(e,o.axis,a).lo,0,i-1)),s=h?_limitValue(_lookupByKey(e,o.axis,r).hi+1,n,i)-n:i-n,{start:n,count:s}}var plugin_decimation={id:"decimation",defaults:{algorithm:"min-max",enabled:!1},beforeElementsUpdate:(t,e,i)=>{if(!i.enabled)return void cleanDecimatedData(t);const s=t.width;t.data.datasets.forEach(((e,n)=>{const{_data:o,indexAxis:a}=e,r=t.getDatasetMeta(n),l=o||e.data;if("y"===resolve([a,t.options.indexAxis]))return;if(!r.controller.supportsDecimation)return;const h=t.scales[r.xAxisID];if("linear"!==h.type&&"time"!==h.type)return;if(t.options.parsing)return;let{start:c,count:d}=getStartAndCountOfVisiblePointsSimplified(r,l);if(d<=(i.threshold||4*s))return void cleanDecimatedDataset(e);let u;switch(isNullOrUndef(o)&&(e._data=l,delete e.data,Object.defineProperty(e,"data",{configurable:!0,enumerable:!0,get:function(){return this._decimated},set:function(t){this._data=t}})),i.algorithm){case"lttb":u=lttbDecimation(l,c,d,s,i);break;case"min-max":u=minMaxDecimation(l,c,d,s);break;default:throw new Error(`Unsupported decimation algorithm '${i.algorithm}'`)}e._decimated=u}))},destroy(t){cleanDecimatedData(t)}};function _segments(t,e,i){const s=t.segments,n=t.points,o=e.points,a=[];for(const t of s){let{start:s,end:r}=t;r=_findSegmentEnd(s,r,n);const l=_getBounds(i,n[s],n[r],t.loop);if(!e.segments){a.push({source:t,target:l,start:n[s],end:n[r]});continue}const h=_boundSegments(e,l);for(const e of h){const s=_getBounds(i,o[e.start],o[e.end],e.loop),r=_boundSegment(t,n,s);for(const t of r)a.push({source:t,target:e,start:{[i]:_getEdge(l,s,"start",Math.max)},end:{[i]:_getEdge(l,s,"end",Math.min)}})}}return a}function _getBounds(t,e,i,s){if(s)return;let n=e[t],o=i[t];return"angle"===t&&(n=_normalizeAngle(n),o=_normalizeAngle(o)),{property:t,start:n,end:o}}function _pointsFromSegments(t,e){const{x:i=null,y:s=null}=t||{},n=e.points,o=[];return e.segments.forEach((({start:t,end:e})=>{e=_findSegmentEnd(t,e,n);const a=n[t],r=n[e];null!==s?(o.push({x:a.x,y:s}),o.push({x:r.x,y:s})):null!==i&&(o.push({x:i,y:a.y}),o.push({x:i,y:r.y}))})),o}function _findSegmentEnd(t,e,i){for(;e>t;e--){const t=i[e];if(!isNaN(t.x)&&!isNaN(t.y))break}return e}function _getEdge(t,e,i,s){return t&&e?s(t[i],e[i]):t?t[i]:e?e[i]:0}function _createBoundaryLine(t,e){let i=[],s=!1;return isArray(t)?(s=!0,i=t):i=_pointsFromSegments(t,e),i.length?new LineElement({points:i,options:{tension:0},_loop:s,_fullLoop:s}):null}function _shouldApplyFill(t){return t&&!1!==t.fill}function _resolveTarget(t,e,i){let s=t[e].fill;const n=[e];let o;if(!i)return s;for(;!1!==s&&-1===n.indexOf(s);){if(!isNumberFinite(s))return s;if(o=t[s],!o)return!1;if(o.visible)return s;n.push(s),s=o.fill}return!1}function _decodeFill(t,e,i){const s=parseFillOption(t);if(isObject(s))return!isNaN(s.value)&&s;let n=parseFloat(s);return isNumberFinite(n)&&Math.floor(n)===n?decodeTargetIndex(s[0],e,n,i):["origin","start","end","stack","shape"].indexOf(s)>=0&&s}function decodeTargetIndex(t,e,i,s){return"-"!==t&&"+"!==t||(i=e+i),!(i===e||i<0||i>=s)&&i}function _getTargetPixel(t,e){let i=null;return"start"===t?i=e.bottom:"end"===t?i=e.top:isObject(t)?i=e.getPixelForValue(t.value):e.getBasePixel&&(i=e.getBasePixel()),i}function _getTargetValue(t,e,i){let s;return s="start"===t?i:"end"===t?e.options.reverse?e.min:e.max:isObject(t)?t.value:e.getBaseValue(),s}function parseFillOption(t){const e=t.options,i=e.fill;let s=valueOrDefault(i&&i.target,i);return void 0===s&&(s=!!e.backgroundColor),!1!==s&&null!==s&&(!0===s?"origin":s)}function _buildStackLine(t){const{scale:e,index:i,line:s}=t,n=[],o=s.segments,a=s.points,r=getLinesBelow(e,i);r.push(_createBoundaryLine({x:null,y:e.bottom},s));for(let t=0;t<o.length;t++){const e=o[t];for(let t=e.start;t<=e.end;t++)addPointsBelow(n,a[t],r)}return new LineElement({points:n,options:{}})}function getLinesBelow(t,e){const i=[],s=t.getMatchingVisibleMetas("line");for(let t=0;t<s.length;t++){const n=s[t];if(n.index===e)break;n.hidden||i.unshift(n.dataset)}return i}function addPointsBelow(t,e,i){const s=[];for(let n=0;n<i.length;n++){const o=i[n],{first:a,last:r,point:l}=findPoint(o,e,"x");if(!(!l||a&&r))if(a)s.unshift(l);else if(t.push(l),!r)break}t.push(...s)}function findPoint(t,e,i){const s=t.interpolate(e,i);if(!s)return{};const n=s[i],o=t.segments,a=t.points;let r=!1,l=!1;for(let t=0;t<o.length;t++){const e=o[t],s=a[e.start][i],h=a[e.end][i];if(_isBetween(n,s,h)){r=n===s,l=n===h;break}}return{first:r,last:l,point:s}}class simpleArc{constructor(t){this.x=t.x,this.y=t.y,this.radius=t.radius}pathSegment(t,e,i){const{x:s,y:n,radius:o}=this;return e=e||{start:0,end:TAU},t.arc(s,n,o,e.end,e.start,!0),!i.bounds}interpolate(t){const{x:e,y:i,radius:s}=this,n=t.angle;return{x:e+Math.cos(n)*s,y:i+Math.sin(n)*s,angle:n}}}function _getTarget(t){const{chart:e,fill:i,line:s}=t;if(isNumberFinite(i))return getLineByIndex(e,i);if("stack"===i)return _buildStackLine(t);if("shape"===i)return!0;const n=computeBoundary(t);return n instanceof simpleArc?n:_createBoundaryLine(n,s)}function getLineByIndex(t,e){const i=t.getDatasetMeta(e);return i&&t.isDatasetVisible(e)?i.dataset:null}function computeBoundary(t){return(t.scale||{}).getPointPositionForValue?computeCircularBoundary(t):computeLinearBoundary(t)}function computeLinearBoundary(t){const{scale:e={},fill:i}=t,s=_getTargetPixel(i,e);if(isNumberFinite(s)){const t=e.isHorizontal();return{x:t?s:null,y:t?null:s}}return null}function computeCircularBoundary(t){const{scale:e,fill:i}=t,s=e.options,n=e.getLabels().length,o=s.reverse?e.max:e.min,a=_getTargetValue(i,e,o),r=[];if(s.grid.circular){const t=e.getPointPositionForValue(0,o);return new simpleArc({x:t.x,y:t.y,radius:e.getDistanceFromCenterForValue(a)})}for(let t=0;t<n;++t)r.push(e.getPointPositionForValue(t,a));return r}function _drawfill(t,e,i){const s=_getTarget(e),{line:n,scale:o,axis:a}=e,r=n.options,l=r.fill,h=r.backgroundColor,{above:c=h,below:d=h}=l||{};s&&n.points.length&&(clipArea(t,i),doFill(t,{line:n,target:s,above:c,below:d,area:i,scale:o,axis:a}),unclipArea(t))}function doFill(t,e){const{line:i,target:s,above:n,below:o,area:a,scale:r}=e,l=i._loop?"angle":e.axis;t.save(),"x"===l&&o!==n&&(clipVertical(t,s,a.top),fill(t,{line:i,target:s,color:n,scale:r,property:l}),t.restore(),t.save(),clipVertical(t,s,a.bottom)),fill(t,{line:i,target:s,color:o,scale:r,property:l}),t.restore()}function clipVertical(t,e,i){const{segments:s,points:n}=e;let o=!0,a=!1;t.beginPath();for(const r of s){const{start:s,end:l}=r,h=n[s],c=n[_findSegmentEnd(s,l,n)];o?(t.moveTo(h.x,h.y),o=!1):(t.lineTo(h.x,i),t.lineTo(h.x,h.y)),a=!!e.pathSegment(t,r,{move:a}),a?t.closePath():t.lineTo(c.x,i)}t.lineTo(e.first().x,i),t.closePath(),t.clip()}function fill(t,e){const{line:i,target:s,property:n,color:o,scale:a}=e,r=_segments(i,s,n);for(const{source:e,target:l,start:h,end:c}of r){const{style:{backgroundColor:r=o}={}}=e,d=!0!==s;t.save(),t.fillStyle=r,clipBounds(t,a,d&&_getBounds(n,h,c)),t.beginPath();const u=!!i.pathSegment(t,e);let g;if(d){u?t.closePath():interpolatedLineTo(t,s,c,n);const e=!!s.pathSegment(t,l,{move:u,reverse:!0});g=u&&e,g||interpolatedLineTo(t,s,h,n)}t.closePath(),t.fill(g?"evenodd":"nonzero"),t.restore()}}function clipBounds(t,e,i){const{top:s,bottom:n}=e.chart.chartArea,{property:o,start:a,end:r}=i||{};"x"===o&&(t.beginPath(),t.rect(a,s,r-a,n-s),t.clip())}function interpolatedLineTo(t,e,i,s){const n=e.interpolate(i,s);n&&t.lineTo(n.x,n.y)}var index={id:"filler",afterDatasetsUpdate(t,e,i){const s=(t.data.datasets||[]).length,n=[];let o,a,r,l;for(a=0;a<s;++a)o=t.getDatasetMeta(a),r=o.dataset,l=null,r&&r.options&&r instanceof LineElement&&(l={visible:t.isDatasetVisible(a),index:a,fill:_decodeFill(r,a,s),chart:t,axis:o.controller.options.indexAxis,scale:o.vScale,line:r}),o.$filler=l,n.push(l);for(a=0;a<s;++a)l=n[a],l&&!1!==l.fill&&(l.fill=_resolveTarget(n,a,i.propagate))},beforeDraw(t,e,i){const s="beforeDraw"===i.drawTime,n=t.getSortedVisibleDatasetMetas(),o=t.chartArea;for(let e=n.length-1;e>=0;--e){const i=n[e].$filler;i&&(i.line.updateControlPoints(o,i.axis),s&&i.fill&&_drawfill(t.ctx,i,o))}},beforeDatasetsDraw(t,e,i){if("beforeDatasetsDraw"!==i.drawTime)return;const s=t.getSortedVisibleDatasetMetas();for(let e=s.length-1;e>=0;--e){const i=s[e].$filler;_shouldApplyFill(i)&&_drawfill(t.ctx,i,t.chartArea)}},beforeDatasetDraw(t,e,i){const s=e.meta.$filler;_shouldApplyFill(s)&&"beforeDatasetDraw"===i.drawTime&&_drawfill(t.ctx,s,t.chartArea)},defaults:{propagate:!0,drawTime:"beforeDatasetDraw"}};const getBoxSize=(t,e)=>{let{boxHeight:i=e,boxWidth:s=e}=t;return t.usePointStyle&&(i=Math.min(i,e),s=t.pointStyleWidth||Math.min(s,e)),{boxWidth:s,boxHeight:i,itemHeight:Math.max(e,i)}},itemsEqual=(t,e)=>null!==t&&null!==e&&t.datasetIndex===e.datasetIndex&&t.index===e.index;class Legend extends Element{constructor(t){super(),this._added=!1,this.legendHitBoxes=[],this._hoveredItem=null,this.doughnutMode=!1,this.chart=t.chart,this.options=t.options,this.ctx=t.ctx,this.legendItems=void 0,this.columnSizes=void 0,this.lineWidths=void 0,this.maxHeight=void 0,this.maxWidth=void 0,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.height=void 0,this.width=void 0,this._margins=void 0,this.position=void 0,this.weight=void 0,this.fullSize=void 0}update(t,e,i){this.maxWidth=t,this.maxHeight=e,this._margins=i,this.setDimensions(),this.buildLabels(),this.fit()}setDimensions(){this.isHorizontal()?(this.width=this.maxWidth,this.left=this._margins.left,this.right=this.width):(this.height=this.maxHeight,this.top=this._margins.top,this.bottom=this.height)}buildLabels(){const t=this.options.labels||{};let e=callback(t.generateLabels,[this.chart],this)||[];t.filter&&(e=e.filter((e=>t.filter(e,this.chart.data)))),t.sort&&(e=e.sort(((e,i)=>t.sort(e,i,this.chart.data)))),this.options.reverse&&e.reverse(),this.legendItems=e}fit(){const{options:t,ctx:e}=this;if(!t.display)return void(this.width=this.height=0);const i=t.labels,s=toFont(i.font),n=s.size,o=this._computeTitleHeight(),{boxWidth:a,itemHeight:r}=getBoxSize(i,n);let l,h;e.font=s.string,this.isHorizontal()?(l=this.maxWidth,h=this._fitRows(o,n,a,r)+10):(h=this.maxHeight,l=this._fitCols(o,s,a,r)+10),this.width=Math.min(l,t.maxWidth||this.maxWidth),this.height=Math.min(h,t.maxHeight||this.maxHeight)}_fitRows(t,e,i,s){const{ctx:n,maxWidth:o,options:{labels:{padding:a}}}=this,r=this.legendHitBoxes=[],l=this.lineWidths=[0],h=s+a;let c=t;n.textAlign="left",n.textBaseline="middle";let d=-1,u=-h;return this.legendItems.forEach(((t,g)=>{const f=i+e/2+n.measureText(t.text).width;(0===g||l[l.length-1]+f+2*a>o)&&(c+=h,l[l.length-(g>0?0:1)]=0,u+=h,d++),r[g]={left:0,top:u,row:d,width:f,height:s},l[l.length-1]+=f+a})),c}_fitCols(t,e,i,s){const{ctx:n,maxHeight:o,options:{labels:{padding:a}}}=this,r=this.legendHitBoxes=[],l=this.columnSizes=[],h=o-t;let c=a,d=0,u=0,g=0,f=0;return this.legendItems.forEach(((t,o)=>{const{itemWidth:p,itemHeight:m}=calculateItemSize(i,e,n,t,s);o>0&&u+m+2*a>h&&(c+=d+a,l.push({width:d,height:u}),g+=d+a,f++,d=u=0),r[o]={left:g,top:u,col:f,width:p,height:m},d=Math.max(d,p),u+=m+a})),c+=d,l.push({width:d,height:u}),c}adjustHitBoxes(){if(!this.options.display)return;const t=this._computeTitleHeight(),{legendHitBoxes:e,options:{align:i,labels:{padding:s},rtl:n}}=this,o=getRtlAdapter(n,this.left,this.width);if(this.isHorizontal()){let n=0,a=_alignStartEnd(i,this.left+s,this.right-this.lineWidths[n]);for(const r of e)n!==r.row&&(n=r.row,a=_alignStartEnd(i,this.left+s,this.right-this.lineWidths[n])),r.top+=this.top+t+s,r.left=o.leftForLtr(o.x(a),r.width),a+=r.width+s}else{let n=0,a=_alignStartEnd(i,this.top+t+s,this.bottom-this.columnSizes[n].height);for(const r of e)r.col!==n&&(n=r.col,a=_alignStartEnd(i,this.top+t+s,this.bottom-this.columnSizes[n].height)),r.top=a,r.left+=this.left+s,r.left=o.leftForLtr(o.x(r.left),r.width),a+=r.height+s}}isHorizontal(){return"top"===this.options.position||"bottom"===this.options.position}draw(){if(this.options.display){const t=this.ctx;clipArea(t,this),this._draw(),unclipArea(t)}}_draw(){const{options:t,columnSizes:e,lineWidths:i,ctx:s}=this,{align:n,labels:o}=t,a=defaults.color,r=getRtlAdapter(t.rtl,this.left,this.width),l=toFont(o.font),{padding:h}=o,c=l.size,d=c/2;let u;this.drawTitle(),s.textAlign=r.textAlign("left"),s.textBaseline="middle",s.lineWidth=.5,s.font=l.string;const{boxWidth:g,boxHeight:f,itemHeight:p}=getBoxSize(o,c),m=this.isHorizontal(),b=this._computeTitleHeight();u=m?{x:_alignStartEnd(n,this.left+h,this.right-i[0]),y:this.top+h+b,line:0}:{x:this.left+h,y:_alignStartEnd(n,this.top+b+h,this.bottom-e[0].height),line:0},overrideTextDirection(this.ctx,t.textDirection);const x=p+h;this.legendItems.forEach(((_,y)=>{s.strokeStyle=_.fontColor,s.fillStyle=_.fontColor;const v=s.measureText(_.text).width,S=r.textAlign(_.textAlign||(_.textAlign=o.textAlign)),k=g+d+v;let P=u.x,M=u.y;r.setWidth(this.width),m?y>0&&P+k+h>this.right&&(M=u.y+=x,u.line++,P=u.x=_alignStartEnd(n,this.left+h,this.right-i[u.line])):y>0&&M+x>this.bottom&&(P=u.x=P+e[u.line].width+h,u.line++,M=u.y=_alignStartEnd(n,this.top+b+h,this.bottom-e[u.line].height));if(function(t,e,i){if(isNaN(g)||g<=0||isNaN(f)||f<0)return;s.save();const n=valueOrDefault(i.lineWidth,1);if(s.fillStyle=valueOrDefault(i.fillStyle,a),s.lineCap=valueOrDefault(i.lineCap,"butt"),s.lineDashOffset=valueOrDefault(i.lineDashOffset,0),s.lineJoin=valueOrDefault(i.lineJoin,"miter"),s.lineWidth=n,s.strokeStyle=valueOrDefault(i.strokeStyle,a),s.setLineDash(valueOrDefault(i.lineDash,[])),o.usePointStyle){const a={radius:f*Math.SQRT2/2,pointStyle:i.pointStyle,rotation:i.rotation,borderWidth:n},l=r.xPlus(t,g/2);drawPointLegend(s,a,l,e+d,o.pointStyleWidth&&g)}else{const o=e+Math.max((c-f)/2,0),a=r.leftForLtr(t,g),l=toTRBLCorners(i.borderRadius);s.beginPath(),Object.values(l).some((t=>0!==t))?addRoundedRectPath(s,{x:a,y:o,w:g,h:f,radius:l}):s.rect(a,o,g,f),s.fill(),0!==n&&s.stroke()}s.restore()}(r.x(P),M,_),P=_textX(S,P+g+d,m?P+k:this.right,t.rtl),function(t,e,i){renderText(s,i.text,t,e+p/2,l,{strikethrough:i.hidden,textAlign:r.textAlign(i.textAlign)})}(r.x(P),M,_),m)u.x+=k+h;else if("string"!=typeof _.text){const t=l.lineHeight;u.y+=calculateLegendItemHeight(_,t)+h}else u.y+=x})),restoreTextDirection(this.ctx,t.textDirection)}drawTitle(){const t=this.options,e=t.title,i=toFont(e.font),s=toPadding(e.padding);if(!e.display)return;const n=getRtlAdapter(t.rtl,this.left,this.width),o=this.ctx,a=e.position,r=i.size/2,l=s.top+r;let h,c=this.left,d=this.width;if(this.isHorizontal())d=Math.max(...this.lineWidths),h=this.top+l,c=_alignStartEnd(t.align,c,this.right-d);else{const e=this.columnSizes.reduce(((t,e)=>Math.max(t,e.height)),0);h=l+_alignStartEnd(t.align,this.top,this.bottom-e-t.labels.padding-this._computeTitleHeight())}const u=_alignStartEnd(a,c,c+d);o.textAlign=n.textAlign(_toLeftRightCenter(a)),o.textBaseline="middle",o.strokeStyle=e.color,o.fillStyle=e.color,o.font=i.string,renderText(o,e.text,u,h,i)}_computeTitleHeight(){const t=this.options.title,e=toFont(t.font),i=toPadding(t.padding);return t.display?e.lineHeight+i.height:0}_getLegendItemAt(t,e){let i,s,n;if(_isBetween(t,this.left,this.right)&&_isBetween(e,this.top,this.bottom))for(n=this.legendHitBoxes,i=0;i<n.length;++i)if(s=n[i],_isBetween(t,s.left,s.left+s.width)&&_isBetween(e,s.top,s.top+s.height))return this.legendItems[i];return null}handleEvent(t){const e=this.options;if(!isListened(t.type,e))return;const i=this._getLegendItemAt(t.x,t.y);if("mousemove"===t.type||"mouseout"===t.type){const s=this._hoveredItem,n=itemsEqual(s,i);s&&!n&&callback(e.onLeave,[t,s,this],this),this._hoveredItem=i,i&&!n&&callback(e.onHover,[t,i,this],this)}else i&&callback(e.onClick,[t,i,this],this)}}function calculateItemSize(t,e,i,s,n){return{itemWidth:calculateItemWidth(s,t,e,i),itemHeight:calculateItemHeight(n,s,e.lineHeight)}}function calculateItemWidth(t,e,i,s){let n=t.text;return n&&"string"!=typeof n&&(n=n.reduce(((t,e)=>t.length>e.length?t:e))),e+i.size/2+s.measureText(n).width}function calculateItemHeight(t,e,i){let s=t;return"string"!=typeof e.text&&(s=calculateLegendItemHeight(e,i)),s}function calculateLegendItemHeight(t,e){return e*(t.text?t.text.length:0)}function isListened(t,e){return!("mousemove"!==t&&"mouseout"!==t||!e.onHover&&!e.onLeave)||!(!e.onClick||"click"!==t&&"mouseup"!==t)}var plugin_legend={id:"legend",_element:Legend,start(t,e,i){const s=t.legend=new Legend({ctx:t.ctx,options:i,chart:t});layouts.configure(t,s,i),layouts.addBox(t,s)},stop(t){layouts.removeBox(t,t.legend),delete t.legend},beforeUpdate(t,e,i){const s=t.legend;layouts.configure(t,s,i),s.options=i},afterUpdate(t){const e=t.legend;e.buildLabels(),e.adjustHitBoxes()},afterEvent(t,e){e.replay||t.legend.handleEvent(e.event)},defaults:{display:!0,position:"top",align:"center",fullSize:!0,reverse:!1,weight:1e3,onClick(t,e,i){const s=e.datasetIndex,n=i.chart;n.isDatasetVisible(s)?(n.hide(s),e.hidden=!0):(n.show(s),e.hidden=!1)},onHover:null,onLeave:null,labels:{color:t=>t.chart.options.color,boxWidth:40,padding:10,generateLabels(t){const e=t.data.datasets,{labels:{usePointStyle:i,pointStyle:s,textAlign:n,color:o,useBorderRadius:a,borderRadius:r}}=t.legend.options;return t._getSortedDatasetMetas().map((t=>{const l=t.controller.getStyle(i?0:void 0),h=toPadding(l.borderWidth);return{text:e[t.index].label,fillStyle:l.backgroundColor,fontColor:o,hidden:!t.visible,lineCap:l.borderCapStyle,lineDash:l.borderDash,lineDashOffset:l.borderDashOffset,lineJoin:l.borderJoinStyle,lineWidth:(h.width+h.height)/4,strokeStyle:l.borderColor,pointStyle:s||l.pointStyle,rotation:l.rotation,textAlign:n||l.textAlign,borderRadius:a&&(r||l.borderRadius),datasetIndex:t.index}}),this)}},title:{color:t=>t.chart.options.color,display:!1,position:"center",text:""}},descriptors:{_scriptable:t=>!t.startsWith("on"),labels:{_scriptable:t=>!["generateLabels","filter","sort"].includes(t)}}};class Title extends Element{constructor(t){super(),this.chart=t.chart,this.options=t.options,this.ctx=t.ctx,this._padding=void 0,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.width=void 0,this.height=void 0,this.position=void 0,this.weight=void 0,this.fullSize=void 0}update(t,e){const i=this.options;if(this.left=0,this.top=0,!i.display)return void(this.width=this.height=this.right=this.bottom=0);this.width=this.right=t,this.height=this.bottom=e;const s=isArray(i.text)?i.text.length:1;this._padding=toPadding(i.padding);const n=s*toFont(i.font).lineHeight+this._padding.height;this.isHorizontal()?this.height=n:this.width=n}isHorizontal(){const t=this.options.position;return"top"===t||"bottom"===t}_drawArgs(t){const{top:e,left:i,bottom:s,right:n,options:o}=this,a=o.align;let r,l,h,c=0;return this.isHorizontal()?(l=_alignStartEnd(a,i,n),h=e+t,r=n-i):("left"===o.position?(l=i+t,h=_alignStartEnd(a,s,e),c=-.5*PI):(l=n-t,h=_alignStartEnd(a,e,s),c=.5*PI),r=s-e),{titleX:l,titleY:h,maxWidth:r,rotation:c}}draw(){const t=this.ctx,e=this.options;if(!e.display)return;const i=toFont(e.font),s=i.lineHeight/2+this._padding.top,{titleX:n,titleY:o,maxWidth:a,rotation:r}=this._drawArgs(s);renderText(t,e.text,0,0,i,{color:e.color,maxWidth:a,rotation:r,textAlign:_toLeftRightCenter(e.align),textBaseline:"middle",translation:[n,o]})}}function createTitle(t,e){const i=new Title({ctx:t.ctx,options:e,chart:t});layouts.configure(t,i,e),layouts.addBox(t,i),t.titleBlock=i}var plugin_title={id:"title",_element:Title,start(t,e,i){createTitle(t,i)},stop(t){const e=t.titleBlock;layouts.removeBox(t,e),delete t.titleBlock},beforeUpdate(t,e,i){const s=t.titleBlock;layouts.configure(t,s,i),s.options=i},defaults:{align:"center",display:!1,font:{weight:"bold"},fullSize:!0,padding:10,position:"top",text:"",weight:2e3},defaultRoutes:{color:"color"},descriptors:{_scriptable:!0,_indexable:!1}};const map=new WeakMap;var plugin_subtitle={id:"subtitle",start(t,e,i){const s=new Title({ctx:t.ctx,options:i,chart:t});layouts.configure(t,s,i),layouts.addBox(t,s),map.set(t,s)},stop(t){layouts.removeBox(t,map.get(t)),map.delete(t)},beforeUpdate(t,e,i){const s=map.get(t);layouts.configure(t,s,i),s.options=i},defaults:{align:"center",display:!1,font:{weight:"normal"},fullSize:!0,padding:0,position:"top",text:"",weight:1500},defaultRoutes:{color:"color"},descriptors:{_scriptable:!0,_indexable:!1}};const positioners={average(t){if(!t.length)return!1;let e,i,s=0,n=0,o=0;for(e=0,i=t.length;e<i;++e){const i=t[e].element;if(i&&i.hasValue()){const t=i.tooltipPosition();s+=t.x,n+=t.y,++o}}return{x:s/o,y:n/o}},nearest(t,e){if(!t.length)return!1;let i,s,n,o=e.x,a=e.y,r=Number.POSITIVE_INFINITY;for(i=0,s=t.length;i<s;++i){const s=t[i].element;if(s&&s.hasValue()){const t=distanceBetweenPoints(e,s.getCenterPoint());t<r&&(r=t,n=s)}}if(n){const t=n.tooltipPosition();o=t.x,a=t.y}return{x:o,y:a}}};function pushOrConcat(t,e){return e&&(isArray(e)?Array.prototype.push.apply(t,e):t.push(e)),t}function splitNewlines(t){return("string"==typeof t||t instanceof String)&&t.indexOf("\n")>-1?t.split("\n"):t}function createTooltipItem(t,e){const{element:i,datasetIndex:s,index:n}=e,o=t.getDatasetMeta(s).controller,{label:a,value:r}=o.getLabelAndValue(n);return{chart:t,label:a,parsed:o.getParsed(n),raw:t.data.datasets[s].data[n],formattedValue:r,dataset:o.getDataset(),dataIndex:n,datasetIndex:s,element:i}}function getTooltipSize(t,e){const i=t.chart.ctx,{body:s,footer:n,title:o}=t,{boxWidth:a,boxHeight:r}=e,l=toFont(e.bodyFont),h=toFont(e.titleFont),c=toFont(e.footerFont),d=o.length,u=n.length,g=s.length,f=toPadding(e.padding);let p=f.height,m=0,b=s.reduce(((t,e)=>t+e.before.length+e.lines.length+e.after.length),0);if(b+=t.beforeBody.length+t.afterBody.length,d&&(p+=d*h.lineHeight+(d-1)*e.titleSpacing+e.titleMarginBottom),b){p+=g*(e.displayColors?Math.max(r,l.lineHeight):l.lineHeight)+(b-g)*l.lineHeight+(b-1)*e.bodySpacing}u&&(p+=e.footerMarginTop+u*c.lineHeight+(u-1)*e.footerSpacing);let x=0;const _=function(t){m=Math.max(m,i.measureText(t).width+x)};return i.save(),i.font=h.string,each(t.title,_),i.font=l.string,each(t.beforeBody.concat(t.afterBody),_),x=e.displayColors?a+2+e.boxPadding:0,each(s,(t=>{each(t.before,_),each(t.lines,_),each(t.after,_)})),x=0,i.font=c.string,each(t.footer,_),i.restore(),m+=f.width,{width:m,height:p}}function determineYAlign(t,e){const{y:i,height:s}=e;return i<s/2?"top":i>t.height-s/2?"bottom":"center"}function doesNotFitWithAlign(t,e,i,s){const{x:n,width:o}=s,a=i.caretSize+i.caretPadding;return"left"===t&&n+o+a>e.width||("right"===t&&n-o-a<0||void 0)}function determineXAlign(t,e,i,s){const{x:n,width:o}=i,{width:a,chartArea:{left:r,right:l}}=t;let h="center";return"center"===s?h=n<=(r+l)/2?"left":"right":n<=o/2?h="left":n>=a-o/2&&(h="right"),doesNotFitWithAlign(h,t,e,i)&&(h="center"),h}function determineAlignment(t,e,i){const s=i.yAlign||e.yAlign||determineYAlign(t,i);return{xAlign:i.xAlign||e.xAlign||determineXAlign(t,e,i,s),yAlign:s}}function alignX(t,e){let{x:i,width:s}=t;return"right"===e?i-=s:"center"===e&&(i-=s/2),i}function alignY(t,e,i){let{y:s,height:n}=t;return"top"===e?s+=i:s-="bottom"===e?n+i:n/2,s}function getBackgroundPoint(t,e,i,s){const{caretSize:n,caretPadding:o,cornerRadius:a}=t,{xAlign:r,yAlign:l}=i,h=n+o,{topLeft:c,topRight:d,bottomLeft:u,bottomRight:g}=toTRBLCorners(a);let f=alignX(e,r);const p=alignY(e,l,h);return"center"===l?"left"===r?f+=h:"right"===r&&(f-=h):"left"===r?f-=Math.max(c,u)+n:"right"===r&&(f+=Math.max(d,g)+n),{x:_limitValue(f,0,s.width-e.width),y:_limitValue(p,0,s.height-e.height)}}function getAlignedX(t,e,i){const s=toPadding(i.padding);return"center"===e?t.x+t.width/2:"right"===e?t.x+t.width-s.right:t.x+s.left}function getBeforeAfterBodyLines(t){return pushOrConcat([],splitNewlines(t))}function createTooltipContext(t,e,i){return createContext(t,{tooltip:e,tooltipItems:i,type:"tooltip"})}function overrideCallbacks(t,e){const i=e&&e.dataset&&e.dataset.tooltip&&e.dataset.tooltip.callbacks;return i?t.override(i):t}const defaultCallbacks={beforeTitle:noop,title(t){if(t.length>0){const e=t[0],i=e.chart.data.labels,s=i?i.length:0;if(this&&this.options&&"dataset"===this.options.mode)return e.dataset.label||"";if(e.label)return e.label;if(s>0&&e.dataIndex<s)return i[e.dataIndex]}return""},afterTitle:noop,beforeBody:noop,beforeLabel:noop,label(t){if(this&&this.options&&"dataset"===this.options.mode)return t.label+": "+t.formattedValue||t.formattedValue;let e=t.dataset.label||"";e&&(e+=": ");const i=t.formattedValue;return isNullOrUndef(i)||(e+=i),e},labelColor(t){const e=t.chart.getDatasetMeta(t.datasetIndex).controller.getStyle(t.dataIndex);return{borderColor:e.borderColor,backgroundColor:e.backgroundColor,borderWidth:e.borderWidth,borderDash:e.borderDash,borderDashOffset:e.borderDashOffset,borderRadius:0}},labelTextColor(){return this.options.bodyColor},labelPointStyle(t){const e=t.chart.getDatasetMeta(t.datasetIndex).controller.getStyle(t.dataIndex);return{pointStyle:e.pointStyle,rotation:e.rotation}},afterLabel:noop,afterBody:noop,beforeFooter:noop,footer:noop,afterFooter:noop};function invokeCallbackWithFallback(t,e,i,s){const n=t[e].call(i,s);return void 0===n?defaultCallbacks[e].call(i,s):n}class Tooltip extends Element{static positioners=positioners;constructor(t){super(),this.opacity=0,this._active=[],this._eventPosition=void 0,this._size=void 0,this._cachedAnimations=void 0,this._tooltipItems=[],this.$animations=void 0,this.$context=void 0,this.chart=t.chart,this.options=t.options,this.dataPoints=void 0,this.title=void 0,this.beforeBody=void 0,this.body=void 0,this.afterBody=void 0,this.footer=void 0,this.xAlign=void 0,this.yAlign=void 0,this.x=void 0,this.y=void 0,this.height=void 0,this.width=void 0,this.caretX=void 0,this.caretY=void 0,this.labelColors=void 0,this.labelPointStyles=void 0,this.labelTextColors=void 0}initialize(t){this.options=t,this._cachedAnimations=void 0,this.$context=void 0}_resolveAnimations(){const t=this._cachedAnimations;if(t)return t;const e=this.chart,i=this.options.setContext(this.getContext()),s=i.enabled&&e.options.animation&&i.animations,n=new Animations(this.chart,s);return s._cacheable&&(this._cachedAnimations=Object.freeze(n)),n}getContext(){return this.$context||(this.$context=createTooltipContext(this.chart.getContext(),this,this._tooltipItems))}getTitle(t,e){const{callbacks:i}=e,s=invokeCallbackWithFallback(i,"beforeTitle",this,t),n=invokeCallbackWithFallback(i,"title",this,t),o=invokeCallbackWithFallback(i,"afterTitle",this,t);let a=[];return a=pushOrConcat(a,splitNewlines(s)),a=pushOrConcat(a,splitNewlines(n)),a=pushOrConcat(a,splitNewlines(o)),a}getBeforeBody(t,e){return getBeforeAfterBodyLines(invokeCallbackWithFallback(e.callbacks,"beforeBody",this,t))}getBody(t,e){const{callbacks:i}=e,s=[];return each(t,(t=>{const e={before:[],lines:[],after:[]},n=overrideCallbacks(i,t);pushOrConcat(e.before,splitNewlines(invokeCallbackWithFallback(n,"beforeLabel",this,t))),pushOrConcat(e.lines,invokeCallbackWithFallback(n,"label",this,t)),pushOrConcat(e.after,splitNewlines(invokeCallbackWithFallback(n,"afterLabel",this,t))),s.push(e)})),s}getAfterBody(t,e){return getBeforeAfterBodyLines(invokeCallbackWithFallback(e.callbacks,"afterBody",this,t))}getFooter(t,e){const{callbacks:i}=e,s=invokeCallbackWithFallback(i,"beforeFooter",this,t),n=invokeCallbackWithFallback(i,"footer",this,t),o=invokeCallbackWithFallback(i,"afterFooter",this,t);let a=[];return a=pushOrConcat(a,splitNewlines(s)),a=pushOrConcat(a,splitNewlines(n)),a=pushOrConcat(a,splitNewlines(o)),a}_createItems(t){const e=this._active,i=this.chart.data,s=[],n=[],o=[];let a,r,l=[];for(a=0,r=e.length;a<r;++a)l.push(createTooltipItem(this.chart,e[a]));return t.filter&&(l=l.filter(((e,s,n)=>t.filter(e,s,n,i)))),t.itemSort&&(l=l.sort(((e,s)=>t.itemSort(e,s,i)))),each(l,(e=>{const i=overrideCallbacks(t.callbacks,e);s.push(invokeCallbackWithFallback(i,"labelColor",this,e)),n.push(invokeCallbackWithFallback(i,"labelPointStyle",this,e)),o.push(invokeCallbackWithFallback(i,"labelTextColor",this,e))})),this.labelColors=s,this.labelPointStyles=n,this.labelTextColors=o,this.dataPoints=l,l}update(t,e){const i=this.options.setContext(this.getContext()),s=this._active;let n,o=[];if(s.length){const t=positioners[i.position].call(this,s,this._eventPosition);o=this._createItems(i),this.title=this.getTitle(o,i),this.beforeBody=this.getBeforeBody(o,i),this.body=this.getBody(o,i),this.afterBody=this.getAfterBody(o,i),this.footer=this.getFooter(o,i);const e=this._size=getTooltipSize(this,i),a=Object.assign({},t,e),r=determineAlignment(this.chart,i,a),l=getBackgroundPoint(i,a,r,this.chart);this.xAlign=r.xAlign,this.yAlign=r.yAlign,n={opacity:1,x:l.x,y:l.y,width:e.width,height:e.height,caretX:t.x,caretY:t.y}}else 0!==this.opacity&&(n={opacity:0});this._tooltipItems=o,this.$context=void 0,n&&this._resolveAnimations().update(this,n),t&&i.external&&i.external.call(this,{chart:this.chart,tooltip:this,replay:e})}drawCaret(t,e,i,s){const n=this.getCaretPosition(t,i,s);e.lineTo(n.x1,n.y1),e.lineTo(n.x2,n.y2),e.lineTo(n.x3,n.y3)}getCaretPosition(t,e,i){const{xAlign:s,yAlign:n}=this,{caretSize:o,cornerRadius:a}=i,{topLeft:r,topRight:l,bottomLeft:h,bottomRight:c}=toTRBLCorners(a),{x:d,y:u}=t,{width:g,height:f}=e;let p,m,b,x,_,y;return"center"===n?(_=u+f/2,"left"===s?(p=d,m=p-o,x=_+o,y=_-o):(p=d+g,m=p+o,x=_-o,y=_+o),b=p):(m="left"===s?d+Math.max(r,h)+o:"right"===s?d+g-Math.max(l,c)-o:this.caretX,"top"===n?(x=u,_=x-o,p=m-o,b=m+o):(x=u+f,_=x+o,p=m+o,b=m-o),y=x),{x1:p,x2:m,x3:b,y1:x,y2:_,y3:y}}drawTitle(t,e,i){const s=this.title,n=s.length;let o,a,r;if(n){const l=getRtlAdapter(i.rtl,this.x,this.width);for(t.x=getAlignedX(this,i.titleAlign,i),e.textAlign=l.textAlign(i.titleAlign),e.textBaseline="middle",o=toFont(i.titleFont),a=i.titleSpacing,e.fillStyle=i.titleColor,e.font=o.string,r=0;r<n;++r)e.fillText(s[r],l.x(t.x),t.y+o.lineHeight/2),t.y+=o.lineHeight+a,r+1===n&&(t.y+=i.titleMarginBottom-a)}}_drawColorBox(t,e,i,s,n){const o=this.labelColors[i],a=this.labelPointStyles[i],{boxHeight:r,boxWidth:l}=n,h=toFont(n.bodyFont),c=getAlignedX(this,"left",n),d=s.x(c),u=r<h.lineHeight?(h.lineHeight-r)/2:0,g=e.y+u;if(n.usePointStyle){const e={radius:Math.min(l,r)/2,pointStyle:a.pointStyle,rotation:a.rotation,borderWidth:1},i=s.leftForLtr(d,l)+l/2,h=g+r/2;t.strokeStyle=n.multiKeyBackground,t.fillStyle=n.multiKeyBackground,drawPoint(t,e,i,h),t.strokeStyle=o.borderColor,t.fillStyle=o.backgroundColor,drawPoint(t,e,i,h)}else{t.lineWidth=isObject(o.borderWidth)?Math.max(...Object.values(o.borderWidth)):o.borderWidth||1,t.strokeStyle=o.borderColor,t.setLineDash(o.borderDash||[]),t.lineDashOffset=o.borderDashOffset||0;const e=s.leftForLtr(d,l),i=s.leftForLtr(s.xPlus(d,1),l-2),a=toTRBLCorners(o.borderRadius);Object.values(a).some((t=>0!==t))?(t.beginPath(),t.fillStyle=n.multiKeyBackground,addRoundedRectPath(t,{x:e,y:g,w:l,h:r,radius:a}),t.fill(),t.stroke(),t.fillStyle=o.backgroundColor,t.beginPath(),addRoundedRectPath(t,{x:i,y:g+1,w:l-2,h:r-2,radius:a}),t.fill()):(t.fillStyle=n.multiKeyBackground,t.fillRect(e,g,l,r),t.strokeRect(e,g,l,r),t.fillStyle=o.backgroundColor,t.fillRect(i,g+1,l-2,r-2))}t.fillStyle=this.labelTextColors[i]}drawBody(t,e,i){const{body:s}=this,{bodySpacing:n,bodyAlign:o,displayColors:a,boxHeight:r,boxWidth:l,boxPadding:h}=i,c=toFont(i.bodyFont);let d=c.lineHeight,u=0;const g=getRtlAdapter(i.rtl,this.x,this.width),f=function(i){e.fillText(i,g.x(t.x+u),t.y+d/2),t.y+=d+n},p=g.textAlign(o);let m,b,x,_,y,v,S;for(e.textAlign=o,e.textBaseline="middle",e.font=c.string,t.x=getAlignedX(this,p,i),e.fillStyle=i.bodyColor,each(this.beforeBody,f),u=a&&"right"!==p?"center"===o?l/2+h:l+2+h:0,_=0,v=s.length;_<v;++_){for(m=s[_],b=this.labelTextColors[_],e.fillStyle=b,each(m.before,f),x=m.lines,a&&x.length&&(this._drawColorBox(e,t,_,g,i),d=Math.max(c.lineHeight,r)),y=0,S=x.length;y<S;++y)f(x[y]),d=c.lineHeight;each(m.after,f)}u=0,d=c.lineHeight,each(this.afterBody,f),t.y-=n}drawFooter(t,e,i){const s=this.footer,n=s.length;let o,a;if(n){const r=getRtlAdapter(i.rtl,this.x,this.width);for(t.x=getAlignedX(this,i.footerAlign,i),t.y+=i.footerMarginTop,e.textAlign=r.textAlign(i.footerAlign),e.textBaseline="middle",o=toFont(i.footerFont),e.fillStyle=i.footerColor,e.font=o.string,a=0;a<n;++a)e.fillText(s[a],r.x(t.x),t.y+o.lineHeight/2),t.y+=o.lineHeight+i.footerSpacing}}drawBackground(t,e,i,s){const{xAlign:n,yAlign:o}=this,{x:a,y:r}=t,{width:l,height:h}=i,{topLeft:c,topRight:d,bottomLeft:u,bottomRight:g}=toTRBLCorners(s.cornerRadius);e.fillStyle=s.backgroundColor,e.strokeStyle=s.borderColor,e.lineWidth=s.borderWidth,e.beginPath(),e.moveTo(a+c,r),"top"===o&&this.drawCaret(t,e,i,s),e.lineTo(a+l-d,r),e.quadraticCurveTo(a+l,r,a+l,r+d),"center"===o&&"right"===n&&this.drawCaret(t,e,i,s),e.lineTo(a+l,r+h-g),e.quadraticCurveTo(a+l,r+h,a+l-g,r+h),"bottom"===o&&this.drawCaret(t,e,i,s),e.lineTo(a+u,r+h),e.quadraticCurveTo(a,r+h,a,r+h-u),"center"===o&&"left"===n&&this.drawCaret(t,e,i,s),e.lineTo(a,r+c),e.quadraticCurveTo(a,r,a+c,r),e.closePath(),e.fill(),s.borderWidth>0&&e.stroke()}_updateAnimationTarget(t){const e=this.chart,i=this.$animations,s=i&&i.x,n=i&&i.y;if(s||n){const i=positioners[t.position].call(this,this._active,this._eventPosition);if(!i)return;const o=this._size=getTooltipSize(this,t),a=Object.assign({},i,this._size),r=determineAlignment(e,t,a),l=getBackgroundPoint(t,a,r,e);s._to===l.x&&n._to===l.y||(this.xAlign=r.xAlign,this.yAlign=r.yAlign,this.width=o.width,this.height=o.height,this.caretX=i.x,this.caretY=i.y,this._resolveAnimations().update(this,l))}}_willRender(){return!!this.opacity}draw(t){const e=this.options.setContext(this.getContext());let i=this.opacity;if(!i)return;this._updateAnimationTarget(e);const s={width:this.width,height:this.height},n={x:this.x,y:this.y};i=Math.abs(i)<.001?0:i;const o=toPadding(e.padding),a=this.title.length||this.beforeBody.length||this.body.length||this.afterBody.length||this.footer.length;e.enabled&&a&&(t.save(),t.globalAlpha=i,this.drawBackground(n,t,s,e),overrideTextDirection(t,e.textDirection),n.y+=o.top,this.drawTitle(n,t,e),this.drawBody(n,t,e),this.drawFooter(n,t,e),restoreTextDirection(t,e.textDirection),t.restore())}getActiveElements(){return this._active||[]}setActiveElements(t,e){const i=this._active,s=t.map((({datasetIndex:t,index:e})=>{const i=this.chart.getDatasetMeta(t);if(!i)throw new Error("Cannot find a dataset at index "+t);return{datasetIndex:t,element:i.data[e],index:e}})),n=!_elementsEqual(i,s),o=this._positionChanged(s,e);(n||o)&&(this._active=s,this._eventPosition=e,this._ignoreReplayEvents=!0,this.update(!0))}handleEvent(t,e,i=!0){if(e&&this._ignoreReplayEvents)return!1;this._ignoreReplayEvents=!1;const s=this.options,n=this._active||[],o=this._getActiveElements(t,n,e,i),a=this._positionChanged(o,t),r=e||!_elementsEqual(o,n)||a;return r&&(this._active=o,(s.enabled||s.external)&&(this._eventPosition={x:t.x,y:t.y},this.update(!0,e))),r}_getActiveElements(t,e,i,s){const n=this.options;if("mouseout"===t.type)return[];if(!s)return e.filter((t=>this.chart.data.datasets[t.datasetIndex]&&void 0!==this.chart.getDatasetMeta(t.datasetIndex).controller.getParsed(t.index)));const o=this.chart.getElementsAtEventForMode(t,n.mode,n,i);return n.reverse&&o.reverse(),o}_positionChanged(t,e){const{caretX:i,caretY:s,options:n}=this,o=positioners[n.position].call(this,t,e);return!1!==o&&(i!==o.x||s!==o.y)}}var plugin_tooltip={id:"tooltip",_element:Tooltip,positioners,afterInit(t,e,i){i&&(t.tooltip=new Tooltip({chart:t,options:i}))},beforeUpdate(t,e,i){t.tooltip&&t.tooltip.initialize(i)},reset(t,e,i){t.tooltip&&t.tooltip.initialize(i)},afterDraw(t){const e=t.tooltip;if(e&&e._willRender()){const i={tooltip:e};if(!1===t.notifyPlugins("beforeTooltipDraw",{...i,cancelable:!0}))return;e.draw(t.ctx),t.notifyPlugins("afterTooltipDraw",i)}},afterEvent(t,e){if(t.tooltip){const i=e.replay;t.tooltip.handleEvent(e.event,i,e.inChartArea)&&(e.changed=!0)}},defaults:{enabled:!0,external:null,position:"average",backgroundColor:"rgba(0,0,0,0.8)",titleColor:"#fff",titleFont:{weight:"bold"},titleSpacing:2,titleMarginBottom:6,titleAlign:"left",bodyColor:"#fff",bodySpacing:2,bodyFont:{},bodyAlign:"left",footerColor:"#fff",footerSpacing:2,footerMarginTop:6,footerFont:{weight:"bold"},footerAlign:"left",padding:6,caretPadding:2,caretSize:5,cornerRadius:6,boxHeight:(t,e)=>e.bodyFont.size,boxWidth:(t,e)=>e.bodyFont.size,multiKeyBackground:"#fff",displayColors:!0,boxPadding:0,borderColor:"rgba(0,0,0,0)",borderWidth:0,animation:{duration:400,easing:"easeOutQuart"},animations:{numbers:{type:"number",properties:["x","y","width","height","caretX","caretY"]},opacity:{easing:"linear",duration:200}},callbacks:defaultCallbacks},defaultRoutes:{bodyFont:"font",footerFont:"font",titleFont:"font"},descriptors:{_scriptable:t=>"filter"!==t&&"itemSort"!==t&&"external"!==t,_indexable:!1,callbacks:{_scriptable:!1,_indexable:!1},animation:{_fallback:!1},animations:{_fallback:"animation"}},additionalOptionScopes:["interaction"]},plugins=Object.freeze({__proto__:null,Colors:plugin_colors,Decimation:plugin_decimation,Filler:index,Legend:plugin_legend,SubTitle:plugin_subtitle,Title:plugin_title,Tooltip:plugin_tooltip});const addIfString=(t,e,i,s)=>("string"==typeof e?(i=t.push(e)-1,s.unshift({index:i,label:e})):isNaN(e)&&(i=null),i);function findOrAddLabel(t,e,i,s){const n=t.indexOf(e);if(-1===n)return addIfString(t,e,i,s);return n!==t.lastIndexOf(e)?i:n}const validIndex=(t,e)=>null===t?null:_limitValue(Math.round(t),0,e);function _getLabelForValue(t){const e=this.getLabels();return t>=0&&t<e.length?e[t]:t}class CategoryScale extends Scale{static id="category";static defaults={ticks:{callback:_getLabelForValue}};constructor(t){super(t),this._startValue=void 0,this._valueRange=0,this._addedLabels=[]}init(t){const e=this._addedLabels;if(e.length){const t=this.getLabels();for(const{index:i,label:s}of e)t[i]===s&&t.splice(i,1);this._addedLabels=[]}super.init(t)}parse(t,e){if(isNullOrUndef(t))return null;const i=this.getLabels();return e=isFinite(e)&&i[e]===t?e:findOrAddLabel(i,t,valueOrDefault(e,t),this._addedLabels),validIndex(e,i.length-1)}determineDataLimits(){const{minDefined:t,maxDefined:e}=this.getUserBounds();let{min:i,max:s}=this.getMinMax(!0);"ticks"===this.options.bounds&&(t||(i=0),e||(s=this.getLabels().length-1)),this.min=i,this.max=s}buildTicks(){const t=this.min,e=this.max,i=this.options.offset,s=[];let n=this.getLabels();n=0===t&&e===n.length-1?n:n.slice(t,e+1),this._valueRange=Math.max(n.length-(i?0:1),1),this._startValue=this.min-(i?.5:0);for(let i=t;i<=e;i++)s.push({value:i});return s}getLabelForValue(t){return _getLabelForValue.call(this,t)}configure(){super.configure(),this.isHorizontal()||(this._reversePixels=!this._reversePixels)}getPixelForValue(t){return"number"!=typeof t&&(t=this.parse(t)),null===t?NaN:this.getPixelForDecimal((t-this._startValue)/this._valueRange)}getPixelForTick(t){const e=this.ticks;return t<0||t>e.length-1?null:this.getPixelForValue(e[t].value)}getValueForPixel(t){return Math.round(this._startValue+this.getDecimalForPixel(t)*this._valueRange)}getBasePixel(){return this.bottom}}function generateTicks$1(t,e){const i=[],{bounds:s,step:n,min:o,max:a,precision:r,count:l,maxTicks:h,maxDigits:c,includeBounds:d}=t,u=n||1,g=h-1,{min:f,max:p}=e,m=!isNullOrUndef(o),b=!isNullOrUndef(a),x=!isNullOrUndef(l),_=(p-f)/(c+1);let y,v,S,k,P=niceNum((p-f)/g/u)*u;if(P<1e-14&&!m&&!b)return[{value:f},{value:p}];k=Math.ceil(p/P)-Math.floor(f/P),k>g&&(P=niceNum(k*P/g/u)*u),isNullOrUndef(r)||(y=Math.pow(10,r),P=Math.ceil(P*y)/y),"ticks"===s?(v=Math.floor(f/P)*P,S=Math.ceil(p/P)*P):(v=f,S=p),m&&b&&n&&almostWhole((a-o)/n,P/1e3)?(k=Math.round(Math.min((a-o)/P,h)),P=(a-o)/k,v=o,S=a):x?(v=m?o:v,S=b?a:S,k=l-1,P=(S-v)/k):(k=(S-v)/P,k=almostEquals(k,Math.round(k),P/1e3)?Math.round(k):Math.ceil(k));const M=Math.max(_decimalPlaces(P),_decimalPlaces(v));y=Math.pow(10,isNullOrUndef(r)?M:r),v=Math.round(v*y)/y,S=Math.round(S*y)/y;let w=0;for(m&&(d&&v!==o?(i.push({value:o}),v<o&&w++,almostEquals(Math.round((v+w*P)*y)/y,o,relativeLabelSize(o,_,t))&&w++):v<o&&w++);w<k;++w){const t=Math.round((v+w*P)*y)/y;if(b&&t>a)break;i.push({value:t})}return b&&d&&S!==a?i.length&&almostEquals(i[i.length-1].value,a,relativeLabelSize(a,_,t))?i[i.length-1].value=a:i.push({value:a}):b&&S!==a||i.push({value:S}),i}function relativeLabelSize(t,e,{horizontal:i,minRotation:s}){const n=toRadians(s),o=(i?Math.sin(n):Math.cos(n))||.001,a=.75*e*(""+t).length;return Math.min(e/o,a)}class LinearScaleBase extends Scale{constructor(t){super(t),this.start=void 0,this.end=void 0,this._startValue=void 0,this._endValue=void 0,this._valueRange=0}parse(t,e){return isNullOrUndef(t)||("number"==typeof t||t instanceof Number)&&!isFinite(+t)?null:+t}handleTickRangeOptions(){const{beginAtZero:t}=this.options,{minDefined:e,maxDefined:i}=this.getUserBounds();let{min:s,max:n}=this;const o=t=>s=e?s:t,a=t=>n=i?n:t;if(t){const t=sign(s),e=sign(n);t<0&&e<0?a(0):t>0&&e>0&&o(0)}if(s===n){let e=0===n?1:Math.abs(.05*n);a(n+e),t||o(s-e)}this.min=s,this.max=n}getTickLimit(){const t=this.options.ticks;let e,{maxTicksLimit:i,stepSize:s}=t;return s?(e=Math.ceil(this.max/s)-Math.floor(this.min/s)+1,e>1e3&&(console.warn(`scales.${this.id}.ticks.stepSize: ${s} would result generating up to ${e} ticks. Limiting to 1000.`),e=1e3)):(e=this.computeTickLimit(),i=i||11),i&&(e=Math.min(i,e)),e}computeTickLimit(){return Number.POSITIVE_INFINITY}buildTicks(){const t=this.options,e=t.ticks;let i=this.getTickLimit();i=Math.max(2,i);const s=generateTicks$1({maxTicks:i,bounds:t.bounds,min:t.min,max:t.max,precision:e.precision,step:e.stepSize,count:e.count,maxDigits:this._maxDigits(),horizontal:this.isHorizontal(),minRotation:e.minRotation||0,includeBounds:!1!==e.includeBounds},this._range||this);return"ticks"===t.bounds&&_setMinAndMaxByKey(s,this,"value"),t.reverse?(s.reverse(),this.start=this.max,this.end=this.min):(this.start=this.min,this.end=this.max),s}configure(){const t=this.ticks;let e=this.min,i=this.max;if(super.configure(),this.options.offset&&t.length){const s=(i-e)/Math.max(t.length-1,1)/2;e-=s,i+=s}this._startValue=e,this._endValue=i,this._valueRange=i-e}getLabelForValue(t){return formatNumber(t,this.chart.options.locale,this.options.ticks.format)}}class LinearScale extends LinearScaleBase{static id="linear";static defaults={ticks:{callback:Ticks.formatters.numeric}};determineDataLimits(){const{min:t,max:e}=this.getMinMax(!0);this.min=isNumberFinite(t)?t:0,this.max=isNumberFinite(e)?e:1,this.handleTickRangeOptions()}computeTickLimit(){const t=this.isHorizontal(),e=t?this.width:this.height,i=toRadians(this.options.ticks.minRotation),s=(t?Math.sin(i):Math.cos(i))||.001,n=this._resolveTickFontOptions(0);return Math.ceil(e/Math.min(40,n.lineHeight/s))}getPixelForValue(t){return null===t?NaN:this.getPixelForDecimal((t-this._startValue)/this._valueRange)}getValueForPixel(t){return this._startValue+this.getDecimalForPixel(t)*this._valueRange}}const log10Floor=t=>Math.floor(log10(t)),changeExponent=(t,e)=>Math.pow(10,log10Floor(t)+e);function isMajor(t){return 1===t/Math.pow(10,log10Floor(t))}function steps(t,e,i){const s=Math.pow(10,i),n=Math.floor(t/s);return Math.ceil(e/s)-n}function startExp(t,e){let i=log10Floor(e-t);for(;steps(t,e,i)>10;)i++;for(;steps(t,e,i)<10;)i--;return Math.min(i,log10Floor(t))}function generateTicks(t,{min:e,max:i}){e=finiteOrDefault(t.min,e);const s=[],n=log10Floor(e);let o=startExp(e,i),a=o<0?Math.pow(10,Math.abs(o)):1;const r=Math.pow(10,o),l=n>o?Math.pow(10,n):0,h=Math.round((e-l)*a)/a,c=Math.floor((e-l)/r/10)*r*10;let d=Math.floor((h-c)/Math.pow(10,o)),u=finiteOrDefault(t.min,Math.round((l+c+d*Math.pow(10,o))*a)/a);for(;u<i;)s.push({value:u,major:isMajor(u),significand:d}),d>=10?d=d<15?15:20:d++,d>=20&&(o++,d=2,a=o>=0?1:a),u=Math.round((l+c+d*Math.pow(10,o))*a)/a;const g=finiteOrDefault(t.max,u);return s.push({value:g,major:isMajor(g),significand:d}),s}class LogarithmicScale extends Scale{static id="logarithmic";static defaults={ticks:{callback:Ticks.formatters.logarithmic,major:{enabled:!0}}};constructor(t){super(t),this.start=void 0,this.end=void 0,this._startValue=void 0,this._valueRange=0}parse(t,e){const i=LinearScaleBase.prototype.parse.apply(this,[t,e]);if(0!==i)return isNumberFinite(i)&&i>0?i:null;this._zero=!0}determineDataLimits(){const{min:t,max:e}=this.getMinMax(!0);this.min=isNumberFinite(t)?Math.max(0,t):null,this.max=isNumberFinite(e)?Math.max(0,e):null,this.options.beginAtZero&&(this._zero=!0),this._zero&&this.min!==this._suggestedMin&&!isNumberFinite(this._userMin)&&(this.min=t===changeExponent(this.min,0)?changeExponent(this.min,-1):changeExponent(this.min,0)),this.handleTickRangeOptions()}handleTickRangeOptions(){const{minDefined:t,maxDefined:e}=this.getUserBounds();let i=this.min,s=this.max;const n=e=>i=t?i:e,o=t=>s=e?s:t;i===s&&(i<=0?(n(1),o(10)):(n(changeExponent(i,-1)),o(changeExponent(s,1)))),i<=0&&n(changeExponent(s,-1)),s<=0&&o(changeExponent(i,1)),this.min=i,this.max=s}buildTicks(){const t=this.options,e=generateTicks({min:this._userMin,max:this._userMax},this);return"ticks"===t.bounds&&_setMinAndMaxByKey(e,this,"value"),t.reverse?(e.reverse(),this.start=this.max,this.end=this.min):(this.start=this.min,this.end=this.max),e}getLabelForValue(t){return void 0===t?"0":formatNumber(t,this.chart.options.locale,this.options.ticks.format)}configure(){const t=this.min;super.configure(),this._startValue=log10(t),this._valueRange=log10(this.max)-log10(t)}getPixelForValue(t){return void 0!==t&&0!==t||(t=this.min),null===t||isNaN(t)?NaN:this.getPixelForDecimal(t===this.min?0:(log10(t)-this._startValue)/this._valueRange)}getValueForPixel(t){const e=this.getDecimalForPixel(t);return Math.pow(10,this._startValue+e*this._valueRange)}}function getTickBackdropHeight(t){const e=t.ticks;if(e.display&&t.display){const t=toPadding(e.backdropPadding);return valueOrDefault(e.font&&e.font.size,defaults.font.size)+t.height}return 0}function measureLabelSize(t,e,i){return i=isArray(i)?i:[i],{w:_longestText(t,e.string,i),h:i.length*e.lineHeight}}function determineLimits(t,e,i,s,n){return t===s||t===n?{start:e-i/2,end:e+i/2}:t<s||t>n?{start:e-i,end:e}:{start:e,end:e+i}}function fitWithPointLabels(t){const e={l:t.left+t._padding.left,r:t.right-t._padding.right,t:t.top+t._padding.top,b:t.bottom-t._padding.bottom},i=Object.assign({},e),s=[],n=[],o=t._pointLabels.length,a=t.options.pointLabels,r=a.centerPointLabels?PI/o:0;for(let l=0;l<o;l++){const o=a.setContext(t.getPointLabelContext(l));n[l]=o.padding;const h=t.getPointPosition(l,t.drawingArea+n[l],r),c=toFont(o.font),d=measureLabelSize(t.ctx,c,t._pointLabels[l]);s[l]=d;const u=_normalizeAngle(t.getIndexAngle(l)+r),g=Math.round(toDegrees(u));updateLimits(i,e,u,determineLimits(g,h.x,d.w,0,180),determineLimits(g,h.y,d.h,90,270))}t.setCenterPoint(e.l-i.l,i.r-e.r,e.t-i.t,i.b-e.b),t._pointLabelItems=buildPointLabelItems(t,s,n)}function updateLimits(t,e,i,s,n){const o=Math.abs(Math.sin(i)),a=Math.abs(Math.cos(i));let r=0,l=0;s.start<e.l?(r=(e.l-s.start)/o,t.l=Math.min(t.l,e.l-r)):s.end>e.r&&(r=(s.end-e.r)/o,t.r=Math.max(t.r,e.r+r)),n.start<e.t?(l=(e.t-n.start)/a,t.t=Math.min(t.t,e.t-l)):n.end>e.b&&(l=(n.end-e.b)/a,t.b=Math.max(t.b,e.b+l))}function createPointLabelItem(t,e,i){const s=t.drawingArea,{extra:n,additionalAngle:o,padding:a,size:r}=i,l=t.getPointPosition(e,s+n+a,o),h=Math.round(toDegrees(_normalizeAngle(l.angle+HALF_PI))),c=yForAngle(l.y,r.h,h),d=getTextAlignForAngle(h),u=leftForTextAlign(l.x,r.w,d);return{visible:!0,x:l.x,y:c,textAlign:d,left:u,top:c,right:u+r.w,bottom:c+r.h}}function isNotOverlapped(t,e){if(!e)return!0;const{left:i,top:s,right:n,bottom:o}=t;return!(_isPointInArea({x:i,y:s},e)||_isPointInArea({x:i,y:o},e)||_isPointInArea({x:n,y:s},e)||_isPointInArea({x:n,y:o},e))}function buildPointLabelItems(t,e,i){const s=[],n=t._pointLabels.length,o=t.options,{centerPointLabels:a,display:r}=o.pointLabels,l={extra:getTickBackdropHeight(o)/2,additionalAngle:a?PI/n:0};let h;for(let o=0;o<n;o++){l.padding=i[o],l.size=e[o];const n=createPointLabelItem(t,o,l);s.push(n),"auto"===r&&(n.visible=isNotOverlapped(n,h),n.visible&&(h=n))}return s}function getTextAlignForAngle(t){return 0===t||180===t?"center":t<180?"left":"right"}function leftForTextAlign(t,e,i){return"right"===i?t-=e:"center"===i&&(t-=e/2),t}function yForAngle(t,e,i){return 90===i||270===i?t-=e/2:(i>270||i<90)&&(t-=e),t}function drawPointLabelBox(t,e,i){const{left:s,top:n,right:o,bottom:a}=i,{backdropColor:r}=e;if(!isNullOrUndef(r)){const i=toTRBLCorners(e.borderRadius),l=toPadding(e.backdropPadding);t.fillStyle=r;const h=s-l.left,c=n-l.top,d=o-s+l.width,u=a-n+l.height;Object.values(i).some((t=>0!==t))?(t.beginPath(),addRoundedRectPath(t,{x:h,y:c,w:d,h:u,radius:i}),t.fill()):t.fillRect(h,c,d,u)}}function drawPointLabels(t,e){const{ctx:i,options:{pointLabels:s}}=t;for(let n=e-1;n>=0;n--){const e=t._pointLabelItems[n];if(!e.visible)continue;const o=s.setContext(t.getPointLabelContext(n));drawPointLabelBox(i,o,e);const a=toFont(o.font),{x:r,y:l,textAlign:h}=e;renderText(i,t._pointLabels[n],r,l+a.lineHeight/2,a,{color:o.color,textAlign:h,textBaseline:"middle"})}}function pathRadiusLine(t,e,i,s){const{ctx:n}=t;if(i)n.arc(t.xCenter,t.yCenter,e,0,TAU);else{let i=t.getPointPosition(0,e);n.moveTo(i.x,i.y);for(let o=1;o<s;o++)i=t.getPointPosition(o,e),n.lineTo(i.x,i.y)}}function drawRadiusLine(t,e,i,s,n){const o=t.ctx,a=e.circular,{color:r,lineWidth:l}=e;!a&&!s||!r||!l||i<0||(o.save(),o.strokeStyle=r,o.lineWidth=l,o.setLineDash(n.dash),o.lineDashOffset=n.dashOffset,o.beginPath(),pathRadiusLine(t,i,a,s),o.closePath(),o.stroke(),o.restore())}function createPointLabelContext(t,e,i){return createContext(t,{label:i,index:e,type:"pointLabel"})}class RadialLinearScale extends LinearScaleBase{static id="radialLinear";static defaults={display:!0,animate:!0,position:"chartArea",angleLines:{display:!0,lineWidth:1,borderDash:[],borderDashOffset:0},grid:{circular:!1},startAngle:0,ticks:{showLabelBackdrop:!0,callback:Ticks.formatters.numeric},pointLabels:{backdropColor:void 0,backdropPadding:2,display:!0,font:{size:10},callback:t=>t,padding:5,centerPointLabels:!1}};static defaultRoutes={"angleLines.color":"borderColor","pointLabels.color":"color","ticks.color":"color"};static descriptors={angleLines:{_fallback:"grid"}};constructor(t){super(t),this.xCenter=void 0,this.yCenter=void 0,this.drawingArea=void 0,this._pointLabels=[],this._pointLabelItems=[]}setDimensions(){const t=this._padding=toPadding(getTickBackdropHeight(this.options)/2),e=this.width=this.maxWidth-t.width,i=this.height=this.maxHeight-t.height;this.xCenter=Math.floor(this.left+e/2+t.left),this.yCenter=Math.floor(this.top+i/2+t.top),this.drawingArea=Math.floor(Math.min(e,i)/2)}determineDataLimits(){const{min:t,max:e}=this.getMinMax(!1);this.min=isNumberFinite(t)&&!isNaN(t)?t:0,this.max=isNumberFinite(e)&&!isNaN(e)?e:0,this.handleTickRangeOptions()}computeTickLimit(){return Math.ceil(this.drawingArea/getTickBackdropHeight(this.options))}generateTickLabels(t){LinearScaleBase.prototype.generateTickLabels.call(this,t),this._pointLabels=this.getLabels().map(((t,e)=>{const i=callback(this.options.pointLabels.callback,[t,e],this);return i||0===i?i:""})).filter(((t,e)=>this.chart.getDataVisibility(e)))}fit(){const t=this.options;t.display&&t.pointLabels.display?fitWithPointLabels(this):this.setCenterPoint(0,0,0,0)}setCenterPoint(t,e,i,s){this.xCenter+=Math.floor((t-e)/2),this.yCenter+=Math.floor((i-s)/2),this.drawingArea-=Math.min(this.drawingArea/2,Math.max(t,e,i,s))}getIndexAngle(t){return _normalizeAngle(t*(TAU/(this._pointLabels.length||1))+toRadians(this.options.startAngle||0))}getDistanceFromCenterForValue(t){if(isNullOrUndef(t))return NaN;const e=this.drawingArea/(this.max-this.min);return this.options.reverse?(this.max-t)*e:(t-this.min)*e}getValueForDistanceFromCenter(t){if(isNullOrUndef(t))return NaN;const e=t/(this.drawingArea/(this.max-this.min));return this.options.reverse?this.max-e:this.min+e}getPointLabelContext(t){const e=this._pointLabels||[];if(t>=0&&t<e.length){const i=e[t];return createPointLabelContext(this.getContext(),t,i)}}getPointPosition(t,e,i=0){const s=this.getIndexAngle(t)-HALF_PI+i;return{x:Math.cos(s)*e+this.xCenter,y:Math.sin(s)*e+this.yCenter,angle:s}}getPointPositionForValue(t,e){return this.getPointPosition(t,this.getDistanceFromCenterForValue(e))}getBasePosition(t){return this.getPointPositionForValue(t||0,this.getBaseValue())}getPointLabelPosition(t){const{left:e,top:i,right:s,bottom:n}=this._pointLabelItems[t];return{left:e,top:i,right:s,bottom:n}}drawBackground(){const{backgroundColor:t,grid:{circular:e}}=this.options;if(t){const i=this.ctx;i.save(),i.beginPath(),pathRadiusLine(this,this.getDistanceFromCenterForValue(this._endValue),e,this._pointLabels.length),i.closePath(),i.fillStyle=t,i.fill(),i.restore()}}drawGrid(){const t=this.ctx,e=this.options,{angleLines:i,grid:s,border:n}=e,o=this._pointLabels.length;let a,r,l;if(e.pointLabels.display&&drawPointLabels(this,o),s.display&&this.ticks.forEach(((t,e)=>{if(0!==e){r=this.getDistanceFromCenterForValue(t.value);const i=this.getContext(e),a=s.setContext(i),l=n.setContext(i);drawRadiusLine(this,a,r,o,l)}})),i.display){for(t.save(),a=o-1;a>=0;a--){const s=i.setContext(this.getPointLabelContext(a)),{color:n,lineWidth:o}=s;o&&n&&(t.lineWidth=o,t.strokeStyle=n,t.setLineDash(s.borderDash),t.lineDashOffset=s.borderDashOffset,r=this.getDistanceFromCenterForValue(e.ticks.reverse?this.min:this.max),l=this.getPointPosition(a,r),t.beginPath(),t.moveTo(this.xCenter,this.yCenter),t.lineTo(l.x,l.y),t.stroke())}t.restore()}}drawBorder(){}drawLabels(){const t=this.ctx,e=this.options,i=e.ticks;if(!i.display)return;const s=this.getIndexAngle(0);let n,o;t.save(),t.translate(this.xCenter,this.yCenter),t.rotate(s),t.textAlign="center",t.textBaseline="middle",this.ticks.forEach(((s,a)=>{if(0===a&&!e.reverse)return;const r=i.setContext(this.getContext(a)),l=toFont(r.font);if(n=this.getDistanceFromCenterForValue(this.ticks[a].value),r.showLabelBackdrop){t.font=l.string,o=t.measureText(s.label).width,t.fillStyle=r.backdropColor;const e=toPadding(r.backdropPadding);t.fillRect(-o/2-e.left,-n-l.size/2-e.top,o+e.width,l.size+e.height)}renderText(t,s.label,0,-n,l,{color:r.color,strokeColor:r.textStrokeColor,strokeWidth:r.textStrokeWidth})})),t.restore()}drawTitle(){}}const INTERVALS={millisecond:{common:!0,size:1,steps:1e3},second:{common:!0,size:1e3,steps:60},minute:{common:!0,size:6e4,steps:60},hour:{common:!0,size:36e5,steps:24},day:{common:!0,size:864e5,steps:30},week:{common:!1,size:6048e5,steps:4},month:{common:!0,size:2628e6,steps:12},quarter:{common:!1,size:7884e6,steps:4},year:{common:!0,size:3154e7}},UNITS=Object.keys(INTERVALS);function sorter(t,e){return t-e}function parse(t,e){if(isNullOrUndef(e))return null;const i=t._adapter,{parser:s,round:n,isoWeekday:o}=t._parseOpts;let a=e;return"function"==typeof s&&(a=s(a)),isNumberFinite(a)||(a="string"==typeof s?i.parse(a,s):i.parse(a)),null===a?null:(n&&(a="week"!==n||!isNumber(o)&&!0!==o?i.startOf(a,n):i.startOf(a,"isoWeek",o)),+a)}function determineUnitForAutoTicks(t,e,i,s){const n=UNITS.length;for(let o=UNITS.indexOf(t);o<n-1;++o){const t=INTERVALS[UNITS[o]],n=t.steps?t.steps:Number.MAX_SAFE_INTEGER;if(t.common&&Math.ceil((i-e)/(n*t.size))<=s)return UNITS[o]}return UNITS[n-1]}function determineUnitForFormatting(t,e,i,s,n){for(let o=UNITS.length-1;o>=UNITS.indexOf(i);o--){const i=UNITS[o];if(INTERVALS[i].common&&t._adapter.diff(n,s,i)>=e-1)return i}return UNITS[i?UNITS.indexOf(i):0]}function determineMajorUnit(t){for(let e=UNITS.indexOf(t)+1,i=UNITS.length;e<i;++e)if(INTERVALS[UNITS[e]].common)return UNITS[e]}function addTick(t,e,i){if(i){if(i.length){const{lo:s,hi:n}=_lookup(i,e);t[i[s]>=e?i[s]:i[n]]=!0}}else t[e]=!0}function setMajorTicks(t,e,i,s){const n=t._adapter,o=+n.startOf(e[0].value,s),a=e[e.length-1].value;let r,l;for(r=o;r<=a;r=+n.add(r,1,s))l=i[r],l>=0&&(e[l].major=!0);return e}function ticksFromTimestamps(t,e,i){const s=[],n={},o=e.length;let a,r;for(a=0;a<o;++a)r=e[a],n[r]=a,s.push({value:r,major:!1});return 0!==o&&i?setMajorTicks(t,s,n,i):s}class TimeScale extends Scale{static id="time";static defaults={bounds:"data",adapters:{},time:{parser:!1,unit:!1,round:!1,isoWeekday:!1,minUnit:"millisecond",displayFormats:{}},ticks:{source:"auto",callback:!1,major:{enabled:!1}}};constructor(t){super(t),this._cache={data:[],labels:[],all:[]},this._unit="day",this._majorUnit=void 0,this._offsets={},this._normalized=!1,this._parseOpts=void 0}init(t,e={}){const i=t.time||(t.time={}),s=this._adapter=new adapters._date(t.adapters.date);s.init(e),mergeIf(i.displayFormats,s.formats()),this._parseOpts={parser:i.parser,round:i.round,isoWeekday:i.isoWeekday},super.init(t),this._normalized=e.normalized}parse(t,e){return void 0===t?null:parse(this,t)}beforeLayout(){super.beforeLayout(),this._cache={data:[],labels:[],all:[]}}determineDataLimits(){const t=this.options,e=this._adapter,i=t.time.unit||"day";let{min:s,max:n,minDefined:o,maxDefined:a}=this.getUserBounds();function r(t){o||isNaN(t.min)||(s=Math.min(s,t.min)),a||isNaN(t.max)||(n=Math.max(n,t.max))}o&&a||(r(this._getLabelBounds()),"ticks"===t.bounds&&"labels"===t.ticks.source||r(this.getMinMax(!1))),s=isNumberFinite(s)&&!isNaN(s)?s:+e.startOf(Date.now(),i),n=isNumberFinite(n)&&!isNaN(n)?n:+e.endOf(Date.now(),i)+1,this.min=Math.min(s,n-1),this.max=Math.max(s+1,n)}_getLabelBounds(){const t=this.getLabelTimestamps();let e=Number.POSITIVE_INFINITY,i=Number.NEGATIVE_INFINITY;return t.length&&(e=t[0],i=t[t.length-1]),{min:e,max:i}}buildTicks(){const t=this.options,e=t.time,i=t.ticks,s="labels"===i.source?this.getLabelTimestamps():this._generate();"ticks"===t.bounds&&s.length&&(this.min=this._userMin||s[0],this.max=this._userMax||s[s.length-1]);const n=this.min,o=_filterBetween(s,n,this.max);return this._unit=e.unit||(i.autoSkip?determineUnitForAutoTicks(e.minUnit,this.min,this.max,this._getLabelCapacity(n)):determineUnitForFormatting(this,o.length,e.minUnit,this.min,this.max)),this._majorUnit=i.major.enabled&&"year"!==this._unit?determineMajorUnit(this._unit):void 0,this.initOffsets(s),t.reverse&&o.reverse(),ticksFromTimestamps(this,o,this._majorUnit)}afterAutoSkip(){this.options.offsetAfterAutoskip&&this.initOffsets(this.ticks.map((t=>+t.value)))}initOffsets(t=[]){let e,i,s=0,n=0;this.options.offset&&t.length&&(e=this.getDecimalForValue(t[0]),s=1===t.length?1-e:(this.getDecimalForValue(t[1])-e)/2,i=this.getDecimalForValue(t[t.length-1]),n=1===t.length?i:(i-this.getDecimalForValue(t[t.length-2]))/2);const o=t.length<3?.5:.25;s=_limitValue(s,0,o),n=_limitValue(n,0,o),this._offsets={start:s,end:n,factor:1/(s+1+n)}}_generate(){const t=this._adapter,e=this.min,i=this.max,s=this.options,n=s.time,o=n.unit||determineUnitForAutoTicks(n.minUnit,e,i,this._getLabelCapacity(e)),a=valueOrDefault(s.ticks.stepSize,1),r="week"===o&&n.isoWeekday,l=isNumber(r)||!0===r,h={};let c,d,u=e;if(l&&(u=+t.startOf(u,"isoWeek",r)),u=+t.startOf(u,l?"day":o),t.diff(i,e,o)>1e5*a)throw new Error(e+" and "+i+" are too far apart with stepSize of "+a+" "+o);const g="data"===s.ticks.source&&this.getDataTimestamps();for(c=u,d=0;c<i;c=+t.add(c,a,o),d++)addTick(h,c,g);return c!==i&&"ticks"!==s.bounds&&1!==d||addTick(h,c,g),Object.keys(h).sort(sorter).map((t=>+t))}getLabelForValue(t){const e=this._adapter,i=this.options.time;return i.tooltipFormat?e.format(t,i.tooltipFormat):e.format(t,i.displayFormats.datetime)}format(t,e){const i=this.options.time.displayFormats,s=this._unit,n=e||i[s];return this._adapter.format(t,n)}_tickFormatFunction(t,e,i,s){const n=this.options,o=n.ticks.callback;if(o)return callback(o,[t,e,i],this);const a=n.time.displayFormats,r=this._unit,l=this._majorUnit,h=r&&a[r],c=l&&a[l],d=i[e],u=l&&c&&d&&d.major;return this._adapter.format(t,s||(u?c:h))}generateTickLabels(t){let e,i,s;for(e=0,i=t.length;e<i;++e)s=t[e],s.label=this._tickFormatFunction(s.value,e,t)}getDecimalForValue(t){return null===t?NaN:(t-this.min)/(this.max-this.min)}getPixelForValue(t){const e=this._offsets,i=this.getDecimalForValue(t);return this.getPixelForDecimal((e.start+i)*e.factor)}getValueForPixel(t){const e=this._offsets,i=this.getDecimalForPixel(t)/e.factor-e.end;return this.min+i*(this.max-this.min)}_getLabelSize(t){const e=this.options.ticks,i=this.ctx.measureText(t).width,s=toRadians(this.isHorizontal()?e.maxRotation:e.minRotation),n=Math.cos(s),o=Math.sin(s),a=this._resolveTickFontOptions(0).size;return{w:i*n+a*o,h:i*o+a*n}}_getLabelCapacity(t){const e=this.options.time,i=e.displayFormats,s=i[e.unit]||i.millisecond,n=this._tickFormatFunction(t,0,ticksFromTimestamps(this,[t],this._majorUnit),s),o=this._getLabelSize(n),a=Math.floor(this.isHorizontal()?this.width/o.w:this.height/o.h)-1;return a>0?a:1}getDataTimestamps(){let t,e,i=this._cache.data||[];if(i.length)return i;const s=this.getMatchingVisibleMetas();if(this._normalized&&s.length)return this._cache.data=s[0].controller.getAllParsedValues(this);for(t=0,e=s.length;t<e;++t)i=i.concat(s[t].controller.getAllParsedValues(this));return this._cache.data=this.normalize(i)}getLabelTimestamps(){const t=this._cache.labels||[];let e,i;if(t.length)return t;const s=this.getLabels();for(e=0,i=s.length;e<i;++e)t.push(parse(this,s[e]));return this._cache.labels=this._normalized?t:this.normalize(t)}normalize(t){return _arrayUnique(t.sort(sorter))}}function interpolate(t,e,i){let s,n,o,a,r=0,l=t.length-1;i?(e>=t[r].pos&&e<=t[l].pos&&({lo:r,hi:l}=_lookupByKey(t,"pos",e)),({pos:s,time:o}=t[r]),({pos:n,time:a}=t[l])):(e>=t[r].time&&e<=t[l].time&&({lo:r,hi:l}=_lookupByKey(t,"time",e)),({time:s,pos:o}=t[r]),({time:n,pos:a}=t[l]));const h=n-s;return h?o+(a-o)*(e-s)/h:o}class TimeSeriesScale extends TimeScale{static id="timeseries";static defaults=TimeScale.defaults;constructor(t){super(t),this._table=[],this._minPos=void 0,this._tableRange=void 0}initOffsets(){const t=this._getTimestampsForTable(),e=this._table=this.buildLookupTable(t);this._minPos=interpolate(e,this.min),this._tableRange=interpolate(e,this.max)-this._minPos,super.initOffsets(t)}buildLookupTable(t){const{min:e,max:i}=this,s=[],n=[];let o,a,r,l,h;for(o=0,a=t.length;o<a;++o)l=t[o],l>=e&&l<=i&&s.push(l);if(s.length<2)return[{time:e,pos:0},{time:i,pos:1}];for(o=0,a=s.length;o<a;++o)h=s[o+1],r=s[o-1],l=s[o],Math.round((h+r)/2)!==l&&n.push({time:l,pos:o/(a-1)});return n}_generate(){const t=this.min,e=this.max;let i=super.getDataTimestamps();return i.includes(t)&&i.length||i.splice(0,0,t),i.includes(e)&&1!==i.length||i.push(e),i.sort(((t,e)=>t-e))}_getTimestampsForTable(){let t=this._cache.all||[];if(t.length)return t;const e=this.getDataTimestamps(),i=this.getLabelTimestamps();return t=e.length&&i.length?this.normalize(e.concat(i)):e.length?e:i,t=this._cache.all=t,t}getDecimalForValue(t){return(interpolate(this._table,t)-this._minPos)/this._tableRange}getValueForPixel(t){const e=this._offsets,i=this.getDecimalForPixel(t)/e.factor-e.end;return interpolate(this._table,i*this._tableRange+this._minPos,!0)}}var scales=Object.freeze({__proto__:null,CategoryScale,LinearScale,LogarithmicScale,RadialLinearScale,TimeScale,TimeSeriesScale});const registerables=[controllers,elements,plugins,scales];export{Animation,Animations,ArcElement,BarController,BarElement,BasePlatform,BasicPlatform,BubbleController,CategoryScale,Chart,plugin_colors as Colors,DatasetController,plugin_decimation as Decimation,DomPlatform,DoughnutController,Element,index as Filler,Interaction,plugin_legend as Legend,LineController,LineElement,LinearScale,LogarithmicScale,PieController,PointElement,PolarAreaController,RadarController,RadialLinearScale,Scale,ScatterController,plugin_subtitle as SubTitle,Ticks,TimeScale,TimeSeriesScale,plugin_title as Title,plugin_tooltip as Tooltip,adapters as _adapters,_detectPlatform,animator,controllers,defaults,elements,layouts,plugins,registerables,registry,scales};
