/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import $ from"jquery";import{AbstractInteractableModule}from"@typo3/install/module/abstract-interactable-module.js";import Modal from"@typo3/backend/modal.js";import Notification from"@typo3/backend/notification.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import InfoBox from"@typo3/install/renderable/info-box.js";import ProgressBar from"@typo3/install/renderable/progress-bar.js";import Severity from"@typo3/install/renderable/severity.js";import Router from"@typo3/install/router.js";class DatabaseAnalyzer extends AbstractInteractableModule{constructor(){super(...arguments),this.selectorAnalyzeTrigger=".t3js-databaseAnalyzer-analyze",this.selectorExecuteTrigger=".t3js-databaseAnalyzer-execute",this.selectorOutputContainer=".t3js-databaseAnalyzer-output",this.selectorSuggestionBlock=".t3js-databaseAnalyzer-suggestion-block",this.selectorSuggestionList=".t3js-databaseAnalyzer-suggestion-list",this.selectorSuggestionLineTemplate=".t3js-databaseAnalyzer-suggestion-line-template"}initialize(e){this.currentModal=e,this.getData(),e.on("click",".t3js-databaseAnalyzer-suggestion-block-checkbox",(e=>{const t=$(e.currentTarget);t.closest("fieldset").find(":checkbox").prop("checked",t.get(0).checked)})),e.on("click",this.selectorAnalyzeTrigger,(e=>{e.preventDefault(),this.analyze()})),e.on("click",this.selectorExecuteTrigger,(e=>{e.preventDefault(),this.execute()}))}getData(){const e=this.getModalBody();new AjaxRequest(Router.getUrl("databaseAnalyzer")).get({cache:"no-cache"}).then((async t=>{const a=await t.resolve();!0===a.success?(e.empty().append(a.html),Modal.setButtons(a.buttons),this.analyze()):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(t=>{Router.handleAjaxError(t,e)}))}analyze(){this.setModalButtonsState(!1);const e=this.getModalBody(),t=this.getModalFooter(),a=e.find(this.selectorOutputContainer),s=t.find(this.selectorExecuteTrigger),o=t.find(this.selectorAnalyzeTrigger);a.empty().append(ProgressBar.render(Severity.loading,"Analyzing current database schema...","")),a.on("change",'input[type="checkbox"]',(()=>{const e=a.find(":checked").length>0;this.setModalButtonState(s,e)})),new AjaxRequest(Router.getUrl("databaseAnalyzerAnalyze")).get({cache:"no-cache"}).then((async t=>{const n=await t.resolve();!0===n.success?(Array.isArray(n.status)&&(a.find(".alert-loading").remove(),n.status.forEach((e=>{const t=InfoBox.render(e.severity,e.title,e.message);a.append(t)}))),Array.isArray(n.suggestions)&&(n.suggestions.forEach((t=>{const s=e.find(this.selectorSuggestionBlock).clone();s.removeClass(this.selectorSuggestionBlock.substr(1));const o=t.key;s.find(".t3js-databaseAnalyzer-suggestion-block-legend").text(t.label),s.find(".t3js-databaseAnalyzer-suggestion-block-checkbox").attr("id","t3-install-"+o+"-checkbox"),t.enabled&&s.find(".t3js-databaseAnalyzer-suggestion-block-checkbox").attr("checked","checked"),s.find(".t3js-databaseAnalyzer-suggestion-block-label").attr("for","t3-install-"+o+"-checkbox"),t.children.forEach((a=>{const o=e.find(this.selectorSuggestionLineTemplate).children().clone(),n=a.hash,r=o.find(".t3js-databaseAnalyzer-suggestion-line-checkbox");r.attr("id","t3-install-db-"+n).attr("data-hash",n),t.enabled&&r.attr("checked","checked"),o.find(".t3js-databaseAnalyzer-suggestion-line-label").attr("for","t3-install-db-"+n),o.find(".t3js-databaseAnalyzer-suggestion-line-statement").text(a.statement),void 0!==a.current&&(o.find(".t3js-databaseAnalyzer-suggestion-line-current-value").text(a.current),o.find(".t3js-databaseAnalyzer-suggestion-line-current").show()),void 0!==a.rowCount&&(o.find(".t3js-databaseAnalyzer-suggestion-line-count-value").text(a.rowCount),o.find(".t3js-databaseAnalyzer-suggestion-line-count").show()),s.find(this.selectorSuggestionList).append(o)})),a.append(s.html())})),this.setModalButtonState(o,!0),this.setModalButtonState(s,a.find(":checked").length>0)),0===n.suggestions.length&&0===n.status.length&&a.append(InfoBox.render(Severity.ok,"Database schema is up to date. Good job!",""))):(Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log."),this.setModalButtonState(o,!0),this.setModalButtonState(s,!1))}),(t=>{Router.handleAjaxError(t,e),this.setModalButtonState(o,!0),this.setModalButtonState(s,!1)}))}execute(){this.setModalButtonsState(!1);const e=this.getModalBody(),t=this.getModuleContent().data("database-analyzer-execute-token"),a=e.find(this.selectorOutputContainer),s=[];a.find(".t3js-databaseAnalyzer-suggestion-line input:checked").each(((e,t)=>{s.push($(t).data("hash"))})),a.empty().append(ProgressBar.render(Severity.loading,"Executing database updates...","")),new AjaxRequest(Router.getUrl()).post({install:{action:"databaseAnalyzerExecute",token:t,hashes:s}}).then((async e=>{const t=await e.resolve();Array.isArray(t.status)&&t.status.forEach((e=>{Notification.showMessage(e.title,e.message,e.severity)})),this.analyze()}),(t=>{Router.handleAjaxError(t,e)})).finally((()=>{this.setModalButtonState(this.getModalFooter().find(this.selectorAnalyzeTrigger),!0),this.setModalButtonState(this.getModalFooter().find(this.selectorExecuteTrigger),!1)}))}}export default new DatabaseAnalyzer;