/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import"bootstrap";import $ from"jquery";import"@typo3/install/renderable/clearable.js";import{AbstractInteractableModule}from"@typo3/install/module/abstract-interactable-module.js";import Notification from"@typo3/backend/notification.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import{topLevelModuleImport}from"@typo3/backend/utility/top-level-module-import.js";import Router from"@typo3/install/router.js";import DebounceEvent from"@typo3/core/event/debounce-event.js";import"@typo3/backend/element/icon-element.js";class UpgradeDocs extends AbstractInteractableModule{constructor(){super(...arguments),this.selectorFulltextSearch=".t3js-upgradeDocs-fulltext-search",this.selectorChosenField=".t3js-upgradeDocs-chosen-select",this.selectorChangeLogsForVersionContainer=".t3js-version-changes",this.selectorChangeLogsForVersion=".t3js-changelog-list",this.selectorUpgradeDoc=".t3js-upgrade-doc"}initialize(e){this.currentModal=e;window.location!==window.parent.location?topLevelModuleImport("@typo3/install/chosen.jquery.min.js").then((()=>{this.getContent()})):import("@typo3/install/chosen.jquery.min.js").then((()=>{this.getContent()})),e.on("click",".t3js-upgradeDocs-markRead",(e=>{this.markRead(e.target)})),e.on("click",".t3js-upgradeDocs-unmarkRead",(e=>{this.unmarkRead(e.target)})),$.expr[":"].contains=$.expr.createPseudo((e=>t=>$(t).text().toUpperCase().includes(e.toUpperCase())))}getContent(){const e=this.getModalBody();new AjaxRequest(Router.getUrl("upgradeDocsGetContent")).get({cache:"no-cache"}).then((async t=>{const o=await t.resolve();!0===o.success&&"undefined"!==o.html&&o.html.length>0&&(e.empty().append(o.html),this.initializeFullTextSearch(),this.initializeChosenSelector(),this.loadChangelogs())}),(t=>{Router.handleAjaxError(t,e)}))}loadChangelogs(){const e=[],t=this.getModalBody();this.findInModal(this.selectorChangeLogsForVersionContainer).each(((o,s)=>{const a=new AjaxRequest(Router.getUrl("upgradeDocsGetChangelogForVersion")).withQueryArguments({install:{version:s.dataset.version}}).get({cache:"no-cache"}).then((async e=>{const t=await e.resolve();if(!0===t.success){const e=$(s),o=e.find(this.selectorChangeLogsForVersion);o.html(t.html),this.moveNotRelevantDocuments(o),e.find(".t3js-panel-loading").remove()}else Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(e=>{Router.handleAjaxError(e,t)}));e.push(a)})),Promise.all(e).then((()=>{this.fulltextSearchField.prop("disabled",!1),this.appendItemsToChosenSelector()}))}initializeFullTextSearch(){this.fulltextSearchField=this.findInModal(this.selectorFulltextSearch);const e=this.fulltextSearchField.get(0);e.clearable({onClear:()=>{this.combinedFilterSearch()}}),e.focus(),new DebounceEvent("keyup",(()=>{this.combinedFilterSearch()})).bindTo(e)}initializeChosenSelector(){this.chosenField=this.getModalBody().find(this.selectorChosenField);const e={".chosen-select":{width:"100%",placeholder_text_multiple:"tags"},".chosen-select-deselect":{allow_single_deselect:!0},".chosen-select-no-single":{disable_search_threshold:10},".chosen-select-no-results":{no_results_text:"Oops, nothing found!"},".chosen-select-width":{width:"100%"}};for(const t in e)t in e&&this.findInModal(t).chosen(e[t]);this.chosenField.on("change",(()=>{this.combinedFilterSearch()}))}appendItemsToChosenSelector(){let e="";$(this.findInModal(this.selectorUpgradeDoc)).each(((t,o)=>{e+=$(o).data("item-tags")+","}));const t=[...new Set(e.slice(0,-1).split(",")).values()].reduce(((e,t)=>{const o=t.toLowerCase();return e.every((e=>e.toLowerCase()!==o))&&e.push(t),e}),[]).sort(((e,t)=>e.toLowerCase().localeCompare(t.toLowerCase())));this.chosenField.prop("disabled",!1);for(const e of t)this.chosenField.append($("<option>").text(e));this.chosenField.trigger("chosen:updated")}combinedFilterSearch(){const e=this.getModalBody(),t=e.find(this.selectorUpgradeDoc);if(this.chosenField.val().length<1&&this.fulltextSearchField.val().length<1){const e=this.currentModal.find(".panel-version .panel-collapse.show");return e.one("hidden.bs.collapse",(()=>{0===this.currentModal.find(".panel-version .panel-collapse.collapsing").length&&t.removeClass("hidden searchhit filterhit")})),void e.collapse("hide")}if(t.removeClass("searchhit filterhit"),this.chosenField.val().length>0){t.addClass("hidden").removeClass("filterhit");const o=this.chosenField.val().map((e=>'[data-item-tags*="'+e+'"]')).join("");e.find(o).removeClass("hidden").addClass("searchhit filterhit")}else t.addClass("filterhit").removeClass("hidden");const o=this.fulltextSearchField.val();e.find(".filterhit").each(((e,t)=>{const s=$(t);$(":contains("+o+")",s).length>0||$('input[value*="'+o+'"]',s).length>0?s.removeClass("hidden").addClass("searchhit"):s.removeClass("searchhit").addClass("hidden")})),e.find(".searchhit").closest(".panel-collapse").each(((e,t)=>{window.setTimeout((()=>{$(t).collapse("show")}),20)})),e.find(".panel-version").each(((e,t)=>{const o=$(t);o.find(".searchhit, .filterhit").length<1&&o.find(" > .panel-collapse").collapse("hide")}))}moveNotRelevantDocuments(e){e.find('[data-item-state="read"]').appendTo(this.findInModal(".panel-body-read")),e.find('[data-item-state="notAffected"]').appendTo(this.findInModal(".panel-body-not-affected"))}markRead(e){const t=this.getModalBody(),o=this.getModuleContent().data("upgrade-docs-mark-read-token"),s=$(e).closest("button");s.toggleClass("t3js-upgradeDocs-unmarkRead t3js-upgradeDocs-markRead"),s.find("typo3-backend-icon,.t3js-icon").replaceWith('<typo3-backend-icon identifier="actions-ban" size="small"></typo3-backend-icon>'),s.closest(".panel").appendTo(this.findInModal(".panel-body-read")),new AjaxRequest(Router.getUrl()).post({install:{ignoreFile:s.data("filepath"),token:o,action:"upgradeDocsMarkRead"}}).catch((e=>{Router.handleAjaxError(e,t)}))}unmarkRead(e){const t=this.getModalBody(),o=this.getModuleContent().data("upgrade-docs-unmark-read-token"),s=$(e).closest("button"),a=s.closest(".panel").data("item-version");s.toggleClass("t3js-upgradeDocs-markRead t3js-upgradeDocs-unmarkRead"),s.find("typo3-backend-icon,.t3js-icon").replaceWith('<typo3-backend-icon identifier="actions-check" size="small"></typo3-backend-icon>'),s.closest(".panel").appendTo(this.findInModal('*[data-group-version="'+a+'"] .panel-body')),new AjaxRequest(Router.getUrl()).post({install:{ignoreFile:s.data("filepath"),token:o,action:"upgradeDocsUnmarkRead"}}).catch((e=>{Router.handleAjaxError(e,t)}))}}export default new UpgradeDocs;